/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.presto;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.predicate.Domain;
import com.facebook.presto.spi.predicate.Range;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.Decimals;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.SmallintType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.scan.expression.ColumnExpression;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.scan.expression.LiteralExpression;
import org.apache.carbondata.core.scan.expression.conditional.EqualToExpression;
import org.apache.carbondata.core.scan.expression.conditional.GreaterThanEqualToExpression;
import org.apache.carbondata.core.scan.expression.conditional.GreaterThanExpression;
import org.apache.carbondata.core.scan.expression.conditional.InExpression;
import org.apache.carbondata.core.scan.expression.conditional.LessThanEqualToExpression;
import org.apache.carbondata.core.scan.expression.conditional.LessThanExpression;
import org.apache.carbondata.core.scan.expression.conditional.ListExpression;
import org.apache.carbondata.core.scan.expression.logical.AndExpression;
import org.apache.carbondata.core.scan.expression.logical.OrExpression;
import org.apache.carbondata.presto.CarbondataColumnHandle;

public class PrestoFilterUtil {
    private static Map<Integer, Expression> filterMap = new HashMap<Integer, Expression>();
    private static final String HIVE_DEFAULT_DYNAMIC_PARTITION = "__HIVE_DEFAULT_PARTITION__";

    private static DataType spi2CarbondataTypeMapper(CarbondataColumnHandle carbondataColumnHandle) {
        Type colType = carbondataColumnHandle.getColumnType();
        if (colType == BooleanType.BOOLEAN) {
            return DataTypes.BOOLEAN;
        }
        if (colType == SmallintType.SMALLINT) {
            return DataTypes.SHORT;
        }
        if (colType == IntegerType.INTEGER) {
            return DataTypes.INT;
        }
        if (colType == BigintType.BIGINT) {
            return DataTypes.LONG;
        }
        if (colType == DoubleType.DOUBLE) {
            return DataTypes.DOUBLE;
        }
        if (colType == VarcharType.VARCHAR) {
            return DataTypes.STRING;
        }
        if (colType == DateType.DATE) {
            return DataTypes.DATE;
        }
        if (colType == TimestampType.TIMESTAMP) {
            return DataTypes.TIMESTAMP;
        }
        if (colType.equals(DecimalType.createDecimalType((int)carbondataColumnHandle.getPrecision(), (int)carbondataColumnHandle.getScale()))) {
            return DataTypes.createDecimalType((int)carbondataColumnHandle.getPrecision(), (int)carbondataColumnHandle.getScale());
        }
        return DataTypes.STRING;
    }

    public static List<String> getPartitionFilters(CarbonTable carbonTable, TupleDomain<ColumnHandle> originalConstraint) {
        List columnSchemas = carbonTable.getPartitionInfo().getColumnSchemaList();
        ArrayList<String> filter = new ArrayList<String>();
        for (ColumnHandle columnHandle : ((Map)originalConstraint.getDomains().get()).keySet()) {
            CarbondataColumnHandle carbondataColumnHandle = (CarbondataColumnHandle)columnHandle;
            List partitionedColumnSchema = columnSchemas.stream().filter(columnSchema -> carbondataColumnHandle.getColumnName().equals(columnSchema.getColumnName())).collect(Collectors.toList());
            if (partitionedColumnSchema.size() == 0) continue;
            filter.addAll(PrestoFilterUtil.createPartitionFilters(originalConstraint, carbondataColumnHandle));
        }
        return filter;
    }

    private static List<String> createPartitionFilters(TupleDomain<ColumnHandle> originalConstraint, CarbondataColumnHandle carbonDataColumnHandle) {
        ArrayList<String> filter = new ArrayList<String>();
        Domain domain = (Domain)((Map)originalConstraint.getDomains().get()).get(carbonDataColumnHandle);
        if (domain != null && domain.isNullableSingleValue()) {
            Object value = domain.getNullableSingleValue();
            Type type = domain.getType();
            if (value == null) {
                filter.add(carbonDataColumnHandle.getColumnName() + "=" + HIVE_DEFAULT_DYNAMIC_PARTITION);
            } else if (carbonDataColumnHandle.getColumnType() instanceof DecimalType) {
                int scale = ((DecimalType)carbonDataColumnHandle.getColumnType()).getScale();
                if (value instanceof Long) {
                    BigDecimal decimalValue = new BigDecimal(new BigInteger(String.valueOf(value)), scale);
                    filter.add(carbonDataColumnHandle.getColumnName() + "=" + decimalValue.toString());
                } else if (value instanceof Slice) {
                    BigDecimal decimalValue = new BigDecimal(Decimals.decodeUnscaledValue((Slice)((Slice)value)), scale);
                    filter.add(carbonDataColumnHandle.getColumnName() + "=" + decimalValue.toString());
                }
            } else if (value instanceof Slice) {
                filter.add(carbonDataColumnHandle.getColumnName() + "=" + ((Slice)value).toStringUtf8());
            } else if (value instanceof Long && carbonDataColumnHandle.getColumnType().equals(DateType.DATE)) {
                Calendar c = Calendar.getInstance();
                c.setTime(new Date(0L));
                c.add(6, ((Long)value).intValue());
                Date date = new Date(c.getTime().getTime());
                filter.add(carbonDataColumnHandle.getColumnName() + "=" + date.toString());
            } else if (value instanceof Long && carbonDataColumnHandle.getColumnType().equals(TimestampType.TIMESTAMP)) {
                String timeStamp = new Timestamp((Long)value).toString();
                filter.add(carbonDataColumnHandle.getColumnName() + "=" + timeStamp.substring(0, timeStamp.indexOf(46)));
            } else if (value instanceof Boolean || value instanceof Double || value instanceof Long) {
                filter.add(carbonDataColumnHandle.getColumnName() + "=" + value.toString());
            } else {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported partition key type: %s", type.getDisplayName()));
            }
        }
        return filter;
    }

    static Expression parseFilterExpression(TupleDomain<ColumnHandle> originalConstraint) {
        AndExpression finalFilters = null;
        for (ColumnHandle c : ((Map)originalConstraint.getDomains().get()).keySet()) {
            CarbondataColumnHandle cdch = (CarbondataColumnHandle)c;
            Type type = cdch.getColumnType();
            DataType coltype = PrestoFilterUtil.spi2CarbondataTypeMapper(cdch);
            ColumnExpression colExpression = new ColumnExpression(cdch.getColumnName(), coltype);
            Domain domain = (Domain)((Map)originalConstraint.getDomains().get()).get(c);
            Preconditions.checkArgument((boolean)domain.getType().isOrderable(), (Object)"Domain type must be orderable");
            ArrayList<Object> singleValues = new ArrayList<Object>();
            AndExpression colValueExpression = null;
            for (Range range : domain.getValues().getRanges().getOrderedRanges()) {
                if (range.isSingleValue()) {
                    Object value = PrestoFilterUtil.convertDataByType(range.getLow().getValue(), type);
                    singleValues.add(value);
                    continue;
                }
                OrExpression rangeExpression = null;
                if (!range.getLow().isLowerUnbounded()) {
                    Object value = PrestoFilterUtil.convertDataByType(range.getLow().getValue(), type);
                    switch (range.getLow().getBound()) {
                        case ABOVE: {
                            rangeExpression = new GreaterThanExpression((Expression)colExpression, (Expression)new LiteralExpression(value, coltype));
                            break;
                        }
                        case EXACTLY: {
                            rangeExpression = new GreaterThanEqualToExpression((Expression)colExpression, (Expression)new LiteralExpression(value, coltype));
                            break;
                        }
                        case BELOW: {
                            throw new IllegalArgumentException("Low marker should never use BELOW bound");
                        }
                        default: {
                            throw new AssertionError((Object)("Unhandled bound: " + range.getLow().getBound()));
                        }
                    }
                }
                if (!range.getHigh().isUpperUnbounded()) {
                    LessThanEqualToExpression lessThanExpression;
                    Object value = PrestoFilterUtil.convertDataByType(range.getHigh().getValue(), type);
                    switch (range.getHigh().getBound()) {
                        case ABOVE: {
                            throw new IllegalArgumentException("High marker should never use ABOVE bound");
                        }
                        case EXACTLY: {
                            lessThanExpression = new LessThanEqualToExpression((Expression)colExpression, (Expression)new LiteralExpression(value, coltype));
                            break;
                        }
                        case BELOW: {
                            lessThanExpression = new LessThanExpression((Expression)colExpression, (Expression)new LiteralExpression(value, coltype));
                            break;
                        }
                        default: {
                            throw new AssertionError((Object)("Unhandled bound: " + range.getHigh().getBound()));
                        }
                    }
                    rangeExpression = rangeExpression == null ? lessThanExpression : new AndExpression((Expression)rangeExpression, (Expression)lessThanExpression);
                }
                colValueExpression = colValueExpression == null ? rangeExpression : new OrExpression((Expression)colValueExpression, (Expression)rangeExpression);
            }
            if (singleValues.size() == 1) {
                colValueExpression = new EqualToExpression((Expression)colExpression, (Expression)new LiteralExpression(singleValues.get(0), coltype));
            } else if (singleValues.size() > 1) {
                List exs = singleValues.stream().map(a -> new LiteralExpression(a, coltype)).collect(Collectors.toList());
                colValueExpression = new InExpression((Expression)colExpression, (Expression)new ListExpression(exs));
            }
            if (colValueExpression == null) continue;
            finalFilters = finalFilters == null ? colValueExpression : new AndExpression((Expression)finalFilters, (Expression)colValueExpression);
        }
        return finalFilters;
    }

    private static Object convertDataByType(Object rawdata, Type type) {
        if (type.equals(IntegerType.INTEGER) || type.equals(SmallintType.SMALLINT)) {
            return Integer.valueOf(rawdata.toString());
        }
        if (type.equals(BigintType.BIGINT)) {
            return rawdata;
        }
        if (type.equals(VarcharType.VARCHAR)) {
            if (rawdata instanceof Slice) {
                return ((Slice)rawdata).toStringUtf8();
            }
            return rawdata;
        }
        if (type.equals(BooleanType.BOOLEAN)) {
            return rawdata;
        }
        if (type.equals(DateType.DATE)) {
            Calendar c = Calendar.getInstance();
            c.setTime(new java.util.Date(0L));
            c.add(6, ((Long)rawdata).intValue());
            java.util.Date date = c.getTime();
            return date.getTime() * 1000L;
        }
        if (type instanceof DecimalType) {
            if (rawdata instanceof Double) {
                return new BigDecimal((Double)rawdata);
            }
            if (rawdata instanceof Long) {
                return new BigDecimal(new BigInteger(String.valueOf(rawdata)), ((DecimalType)type).getScale());
            }
            if (rawdata instanceof Slice) {
                return new BigDecimal(Decimals.decodeUnscaledValue((Slice)((Slice)rawdata)), ((DecimalType)type).getScale());
            }
        } else if (type.equals(TimestampType.TIMESTAMP)) {
            return (Long)rawdata * 1000L;
        }
        return rawdata;
    }

    static Expression getFilters(Integer key) {
        return filterMap.get(key);
    }

    static void setFilter(Integer tableId, Expression filter) {
        filterMap.put(tableId, filter);
    }
}

