/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.presto;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.FixedSplitSource;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.stats.QueryStatistic;
import org.apache.carbondata.core.stats.QueryStatisticsRecorder;
import org.apache.carbondata.core.util.CarbonTimeStatisticsFactory;
import org.apache.carbondata.presto.CarbondataColumnConstraint;
import org.apache.carbondata.presto.CarbondataColumnHandle;
import org.apache.carbondata.presto.CarbondataConnectorId;
import org.apache.carbondata.presto.CarbondataSplit;
import org.apache.carbondata.presto.CarbondataTableHandle;
import org.apache.carbondata.presto.CarbondataTableLayoutHandle;
import org.apache.carbondata.presto.PrestoFilterUtil;
import org.apache.carbondata.presto.Types;
import org.apache.carbondata.presto.impl.CarbonLocalMultiBlockSplit;
import org.apache.carbondata.presto.impl.CarbonTableCacheModel;
import org.apache.carbondata.presto.impl.CarbonTableReader;

public class CarbondataSplitManager
implements ConnectorSplitManager {
    private final String connectorId;
    private final CarbonTableReader carbonTableReader;

    @Inject
    public CarbondataSplitManager(CarbondataConnectorId connectorId, CarbonTableReader reader) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null").toString();
        this.carbonTableReader = Objects.requireNonNull(reader, "client is null");
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorTableLayoutHandle layout, ConnectorSplitManager.SplitSchedulingStrategy splitSchedulingStrategy) {
        CarbondataTableLayoutHandle layoutHandle = (CarbondataTableLayoutHandle)layout;
        CarbondataTableHandle tableHandle = layoutHandle.getTable();
        SchemaTableName key = tableHandle.getSchemaTableName();
        String queryId = System.nanoTime() + "";
        QueryStatistic statistic = new QueryStatistic();
        QueryStatisticsRecorder statisticRecorder = CarbonTimeStatisticsFactory.createDriverRecorder();
        statistic.addStatistics("Total Time taken in block(s) allocation", System.currentTimeMillis());
        statisticRecorder.recordStatisticsForDriver(statistic, queryId);
        statistic = new QueryStatistic();
        this.carbonTableReader.setQueryId(queryId);
        List<CarbondataColumnConstraint> rebuildConstraints = this.getColumnConstraints(layoutHandle.getConstraint());
        CarbonTableCacheModel cache = this.carbonTableReader.getCarbonCache(key);
        if (null != cache) {
            Expression filters = PrestoFilterUtil.parseFilterExpression(layoutHandle.getConstraint());
            try {
                List<CarbonLocalMultiBlockSplit> splits = this.carbonTableReader.getInputSplits2(cache, filters, layoutHandle.getConstraint());
                ImmutableList.Builder cSplits = ImmutableList.builder();
                long index = 0L;
                for (CarbonLocalMultiBlockSplit split : splits) {
                    cSplits.add((Object)new CarbondataSplit(this.connectorId, tableHandle.getSchemaTableName(), layoutHandle.getConstraint(), split, rebuildConstraints, queryId, ++index));
                }
                statisticRecorder.logStatisticsAsTableDriver();
                statistic.addStatistics("Time taken to identify Block(s) to scan", System.currentTimeMillis());
                statisticRecorder.recordStatisticsForDriver(statistic, queryId);
                statisticRecorder.logStatisticsAsTableDriver();
                return new FixedSplitSource((Iterable)cSplits.build());
            }
            catch (Exception ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }
        return null;
    }

    public List<CarbondataColumnConstraint> getColumnConstraints(TupleDomain<ColumnHandle> constraint) {
        ImmutableList.Builder constraintBuilder = ImmutableList.builder();
        for (TupleDomain.ColumnDomain columnDomain : (List)constraint.getColumnDomains().get()) {
            CarbondataColumnHandle columnHandle = Types.checkType(columnDomain.getColumn(), CarbondataColumnHandle.class, "column handle");
            constraintBuilder.add((Object)new CarbondataColumnConstraint(columnHandle.getColumnName(), Optional.of(columnDomain.getDomain()), columnHandle.isInvertedIndex()));
        }
        return constraintBuilder.build();
    }
}

