/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.presto;

import com.facebook.presto.spi.block.Block;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.carbondata.core.cache.dictionary.Dictionary;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.datatype.DecimalType;
import org.apache.carbondata.core.metadata.datatype.StructField;
import org.apache.carbondata.core.scan.result.vector.impl.CarbonColumnVectorImpl;
import org.apache.carbondata.presto.CarbonDictionaryDecodeReadSupport;
import org.apache.carbondata.presto.readers.BooleanStreamReader;
import org.apache.carbondata.presto.readers.DecimalSliceStreamReader;
import org.apache.carbondata.presto.readers.DoubleStreamReader;
import org.apache.carbondata.presto.readers.IntegerStreamReader;
import org.apache.carbondata.presto.readers.LongStreamReader;
import org.apache.carbondata.presto.readers.ObjectStreamReader;
import org.apache.carbondata.presto.readers.ShortStreamReader;
import org.apache.carbondata.presto.readers.SliceStreamReader;
import org.apache.carbondata.presto.readers.TimestampStreamReader;

public class CarbonVectorBatch {
    private static final int DEFAULT_BATCH_SIZE = 4096;
    private final int capacity;
    private final CarbonColumnVectorImpl[] columns;
    private final boolean[] filteredRows;
    private final Set<Integer> nullFilteredColumns;
    private int numRows;
    private int numRowsFiltered = 0;

    private CarbonVectorBatch(StructField[] schema, CarbonDictionaryDecodeReadSupport readSupport, int maxRows) {
        this.capacity = maxRows;
        this.columns = new CarbonColumnVectorImpl[schema.length];
        this.nullFilteredColumns = new HashSet<Integer>();
        this.filteredRows = new boolean[maxRows];
        Dictionary[] dictionaries = readSupport.getDictionaries();
        DataType[] dataTypes = readSupport.getDataTypes();
        for (int i = 0; i < schema.length; ++i) {
            this.columns[i] = this.createDirectStreamReader(maxRows, dataTypes[i], schema[i], dictionaries[i], readSupport.getDictionaryBlock(i));
        }
    }

    public static CarbonVectorBatch allocate(StructField[] schema, CarbonDictionaryDecodeReadSupport readSupport) {
        return new CarbonVectorBatch(schema, readSupport, 4096);
    }

    private CarbonColumnVectorImpl createDirectStreamReader(int batchSize, DataType dataType, StructField field, Dictionary dictionary, Block dictionaryBlock) {
        if (dataType == DataTypes.BOOLEAN) {
            return new BooleanStreamReader(batchSize, field.getDataType(), dictionary);
        }
        if (dataType == DataTypes.SHORT) {
            return new ShortStreamReader(batchSize, field.getDataType(), dictionary);
        }
        if (dataType == DataTypes.INT || dataType == DataTypes.DATE) {
            return new IntegerStreamReader(batchSize, field.getDataType(), dictionary);
        }
        if (dataType == DataTypes.TIMESTAMP) {
            return new TimestampStreamReader(batchSize, field.getDataType(), dictionary);
        }
        if (dataType == DataTypes.LONG) {
            return new LongStreamReader(batchSize, field.getDataType(), dictionary);
        }
        if (dataType == DataTypes.DOUBLE) {
            return new DoubleStreamReader(batchSize, field.getDataType(), dictionary);
        }
        if (dataType == DataTypes.STRING) {
            return new SliceStreamReader(batchSize, field.getDataType(), dictionaryBlock);
        }
        if (DataTypes.isDecimal((DataType)dataType)) {
            return new DecimalSliceStreamReader(batchSize, (DecimalType)field.getDataType(), dictionary);
        }
        return new ObjectStreamReader(batchSize, field.getDataType());
    }

    public void reset() {
        for (int i = 0; i < this.numCols(); ++i) {
            this.columns[i].reset();
        }
        if (this.numRowsFiltered > 0) {
            Arrays.fill(this.filteredRows, false);
        }
        this.numRows = 0;
        this.numRowsFiltered = 0;
    }

    public int numCols() {
        return this.columns.length;
    }

    public void setNumRows(int numRows) {
        assert (numRows <= this.capacity);
        this.numRows = numRows;
        for (int ordinal : this.nullFilteredColumns) {
            for (int rowId = 0; rowId < numRows; ++rowId) {
                if (this.filteredRows[rowId] || !this.columns[ordinal].isNull(rowId)) continue;
                this.filteredRows[rowId] = true;
                ++this.numRowsFiltered;
            }
        }
    }

    public int numRows() {
        return this.numRows;
    }

    public int numValidRows() {
        assert (this.numRowsFiltered <= this.numRows);
        return this.numRows - this.numRowsFiltered;
    }

    public CarbonColumnVectorImpl column(int ordinal) {
        return this.columns[ordinal];
    }

    public int capacity() {
        return this.capacity;
    }
}

