/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.presto.readers;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.DictionaryBlock;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import io.airlift.slice.Slices;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.scan.result.vector.impl.CarbonColumnVectorImpl;
import org.apache.carbondata.presto.readers.PrestoVectorBlockBuilder;

public class SliceStreamReader
extends CarbonColumnVectorImpl
implements PrestoVectorBlockBuilder {
    protected int batchSize;
    protected Type type = VarcharType.VARCHAR;
    protected BlockBuilder builder;
    int[] values;
    private Block dictionaryBlock;

    public SliceStreamReader(int batchSize, DataType dataType, Block dictionaryBlock) {
        super(batchSize, dataType);
        this.batchSize = batchSize;
        if (dictionaryBlock == null) {
            this.builder = this.type.createBlockBuilder(null, batchSize);
        } else {
            this.dictionaryBlock = dictionaryBlock;
            this.values = new int[batchSize];
        }
    }

    @Override
    public Block buildBlock() {
        if (this.dictionaryBlock == null) {
            return this.builder.build();
        }
        return new DictionaryBlock(this.batchSize, this.dictionaryBlock, this.values);
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void putInt(int rowId, int value) {
        this.values[rowId] = value;
    }

    public void putBytes(int rowId, byte[] value) {
        this.type.writeSlice(this.builder, Slices.wrappedBuffer((byte[])value));
    }

    public void putBytes(int rowId, int offset, int length, byte[] value) {
        byte[] byteArr = new byte[length];
        System.arraycopy(value, offset, byteArr, 0, length);
        this.type.writeSlice(this.builder, Slices.wrappedBuffer((byte[])byteArr));
    }

    public void putNull(int rowId) {
        if (this.dictionaryBlock == null) {
            this.builder.appendNull();
        }
    }

    public void reset() {
        this.builder = this.type.createBlockBuilder(null, this.batchSize);
    }
}

