/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.presto;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.carbondata.common.CarbonIterator;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.scan.executor.QueryExecutor;
import org.apache.carbondata.core.scan.executor.QueryExecutorFactory;
import org.apache.carbondata.core.scan.executor.exception.QueryExecutionException;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.scan.model.QueryModel;
import org.apache.carbondata.core.scan.result.iterator.AbstractDetailQueryResultIterator;
import org.apache.carbondata.core.util.CarbonTimeStatisticsFactory;
import org.apache.carbondata.hadoop.CarbonInputSplit;
import org.apache.carbondata.hadoop.CarbonMultiBlockSplit;
import org.apache.carbondata.hadoop.CarbonProjection;
import org.apache.carbondata.hadoop.api.CarbonTableInputFormat;
import org.apache.carbondata.presto.CarbonDictionaryDecodeReadSupport;
import org.apache.carbondata.presto.CarbondataColumnHandle;
import org.apache.carbondata.presto.CarbondataConnectorId;
import org.apache.carbondata.presto.CarbondataPageSource;
import org.apache.carbondata.presto.CarbondataSplit;
import org.apache.carbondata.presto.PrestoCarbonVectorizedRecordReader;
import org.apache.carbondata.presto.PrestoFilterUtil;
import org.apache.carbondata.presto.Types;
import org.apache.carbondata.presto.impl.CarbonLocalMultiBlockSplit;
import org.apache.carbondata.presto.impl.CarbonTableCacheModel;
import org.apache.carbondata.presto.impl.CarbonTableReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TaskAttemptContextImpl;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskType;

public class CarbondataPageSourceProvider
implements ConnectorPageSourceProvider {
    private String connectorId;
    private CarbonTableReader carbonTableReader;
    private String queryId;

    @Inject
    public CarbondataPageSourceProvider(CarbondataConnectorId connectorId, CarbonTableReader carbonTableReader) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null").toString();
        this.carbonTableReader = Objects.requireNonNull(carbonTableReader, "carbonTableReader is null");
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorSplit split, List<ColumnHandle> columns) {
        this.queryId = ((CarbondataSplit)split).getQueryId();
        CarbonDictionaryDecodeReadSupport readSupport = new CarbonDictionaryDecodeReadSupport();
        PrestoCarbonVectorizedRecordReader carbonRecordReader = this.createReader(split, columns, readSupport);
        return new CarbondataPageSource(carbonRecordReader, columns);
    }

    private PrestoCarbonVectorizedRecordReader createReader(ConnectorSplit split, List<? extends ColumnHandle> columns, CarbonDictionaryDecodeReadSupport readSupport) {
        CarbondataSplit carbondataSplit = Types.checkType(split, CarbondataSplit.class, "split is not class CarbondataSplit");
        Preconditions.checkArgument((boolean)carbondataSplit.getConnectorId().equals(this.connectorId), (Object)"split is not for this connector");
        QueryModel queryModel = this.createQueryModel(carbondataSplit, columns);
        QueryExecutor queryExecutor = QueryExecutorFactory.getQueryExecutor((QueryModel)queryModel, (Configuration)new Configuration());
        try {
            CarbonIterator iterator = queryExecutor.execute(queryModel);
            readSupport.initialize(queryModel.getProjectionColumns(), queryModel.getTable());
            PrestoCarbonVectorizedRecordReader reader = new PrestoCarbonVectorizedRecordReader(queryExecutor, queryModel, (AbstractDetailQueryResultIterator)iterator, readSupport);
            reader.setTaskId(carbondataSplit.getIndex());
            return reader;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to get the Query Model ", e);
        }
        catch (QueryExecutionException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    private QueryModel createQueryModel(CarbondataSplit carbondataSplit, List<? extends ColumnHandle> columns) {
        try {
            CarbonProjection carbonProjection = this.getCarbonProjection(columns);
            CarbonTable carbonTable = this.getCarbonTable(carbondataSplit);
            Configuration conf = new Configuration();
            conf.set("mapreduce.input.carboninputformat.segmentnumbers", "");
            String carbonTablePath = carbonTable.getAbsoluteTableIdentifier().getTablePath();
            conf.set("mapreduce.input.fileinputformat.inputdir", carbonTablePath);
            conf.set("query.id", this.queryId);
            JobConf jobConf = new JobConf(conf);
            CarbonTableInputFormat<Object> carbonTableInputFormat = this.createInputFormat((Configuration)jobConf, carbonTable, PrestoFilterUtil.parseFilterExpression(carbondataSplit.getConstraints()), carbonProjection);
            TaskAttemptContextImpl hadoopAttemptContext = new TaskAttemptContextImpl(jobConf, new TaskAttemptID("", 1, TaskType.MAP, 0, 0));
            CarbonMultiBlockSplit carbonInputSplit = CarbonLocalMultiBlockSplit.convertSplit(carbondataSplit.getLocalInputSplit());
            QueryModel queryModel = carbonTableInputFormat.createQueryModel((InputSplit)carbonInputSplit, (TaskAttemptContext)hadoopAttemptContext);
            queryModel.setQueryId(this.queryId);
            queryModel.setVectorReader(true);
            queryModel.setStatisticsRecorder(CarbonTimeStatisticsFactory.createExecutorRecorder((String)queryModel.getQueryId()));
            List tableBlockInfoList = CarbonInputSplit.createBlocks((List)carbonInputSplit.getAllSplits());
            queryModel.setTableBlockInfos(tableBlockInfoList);
            return queryModel;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to get the Query Model ", e);
        }
    }

    private CarbonTableInputFormat<Object> createInputFormat(Configuration conf, CarbonTable carbonTable, Expression filterExpression, CarbonProjection projection) {
        AbsoluteTableIdentifier identifier = carbonTable.getAbsoluteTableIdentifier();
        CarbonTableInputFormat format = new CarbonTableInputFormat();
        try {
            CarbonTableInputFormat.setTablePath((Configuration)conf, (String)identifier.appendWithLocalPrefix(identifier.getTablePath()));
            CarbonTableInputFormat.setDatabaseName((Configuration)conf, (String)identifier.getCarbonTableIdentifier().getDatabaseName());
            CarbonTableInputFormat.setTableName((Configuration)conf, (String)identifier.getCarbonTableIdentifier().getTableName());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create the CarbonTableInputFormat", e);
        }
        CarbonTableInputFormat.setFilterPredicates((Configuration)conf, (Expression)filterExpression);
        CarbonTableInputFormat.setColumnProjection((Configuration)conf, (CarbonProjection)projection);
        return format;
    }

    private CarbonProjection getCarbonProjection(List<? extends ColumnHandle> columns) {
        CarbonProjection carbonProjection = new CarbonProjection();
        ImmutableList.Builder handles = ImmutableList.builder();
        for (ColumnHandle columnHandle : columns) {
            handles.add((Object)Types.checkType(columnHandle, CarbondataColumnHandle.class, "handle"));
            carbonProjection.addColumn(((CarbondataColumnHandle)columnHandle).getColumnName());
        }
        return carbonProjection;
    }

    private CarbonTable getCarbonTable(CarbondataSplit carbonSplit) {
        CarbonTableCacheModel tableCacheModel = this.carbonTableReader.getCarbonCache(carbonSplit.getSchemaTableName());
        Preconditions.checkNotNull((Object)tableCacheModel, (Object)"tableCacheModel should not be null");
        Preconditions.checkNotNull((Object)tableCacheModel.carbonTable, (Object)"tableCacheModel.carbonTable should not be null");
        Preconditions.checkNotNull((Object)tableCacheModel.carbonTable.getTableInfo(), (Object)"tableCacheModel.carbonTable.tableInfo should not be null");
        return tableCacheModel.carbonTable;
    }
}

