/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.presto;

import com.facebook.presto.hadoop.;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.LazyBlock;
import com.facebook.presto.spi.block.LazyBlockLoader;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.carbondata.common.logging.LogService;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.presto.CarbonVectorBatch;
import org.apache.carbondata.presto.PrestoCarbonVectorizedRecordReader;
import org.apache.carbondata.presto.readers.PrestoVectorBlockBuilder;
import org.apache.carbondata.processing.loading.exception.CarbonDataLoadingException;

class CarbondataPageSource
implements ConnectorPageSource {
    private static final LogService logger = LogServiceFactory.getLogService((String)CarbondataPageSource.class.getName());
    private List<ColumnHandle> columnHandles;
    private boolean closed;
    private PrestoCarbonVectorizedRecordReader vectorReader;
    private long sizeOfData = 0L;
    private int batchId;
    private long nanoStart;
    private long nanoEnd;

    CarbondataPageSource(PrestoCarbonVectorizedRecordReader vectorizedRecordReader, List<ColumnHandle> columnHandles) {
        this.columnHandles = columnHandles;
        this.vectorReader = vectorizedRecordReader;
    }

    public long getCompletedBytes() {
        return this.sizeOfData;
    }

    public long getReadTimeNanos() {
        return this.nanoStart > 0L ? (this.nanoEnd == 0L ? System.nanoTime() : this.nanoEnd) - this.nanoStart : 0L;
    }

    public boolean isFinished() {
        return this.closed;
    }

    public Page getNextPage() {
        if (this.nanoStart == 0L) {
            this.nanoStart = System.nanoTime();
        }
        CarbonVectorBatch columnarBatch = null;
        int batchSize = 0;
        try {
            ++this.batchId;
            if (this.vectorReader.nextKeyValue()) {
                Object vectorBatch = this.vectorReader.getCurrentValue();
                if (vectorBatch instanceof CarbonVectorBatch && (batchSize = (columnarBatch = (CarbonVectorBatch)vectorBatch).numRows()) == 0) {
                    this.close();
                    return null;
                }
            } else {
                this.close();
                return null;
            }
            if (columnarBatch == null) {
                return null;
            }
            Block[] blocks = new Block[this.columnHandles.size()];
            for (int column = 0; column < blocks.length; ++column) {
                blocks[column] = new LazyBlock(batchSize, (LazyBlockLoader)new CarbondataBlockLoader(column));
            }
            Page page = new Page(batchSize, blocks);
            return page;
        }
        catch (PrestoException e) {
            this.closeWithSuppression(e);
            throw e;
        }
        catch (IOException | InterruptedException | RuntimeException e) {
            this.closeWithSuppression(e);
            throw new CarbonDataLoadingException("Exception when creating the Carbon data Block", (Throwable)e);
        }
    }

    public long getSystemMemoryUsage() {
        return this.sizeOfData;
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.vectorReader.close();
            this.nanoEnd = System.nanoTime();
        }
        catch (Exception e) {
            throw .Throwables.propagate((Throwable)e);
        }
    }

    private void closeWithSuppression(Throwable throwable) {
        block2: {
            Objects.requireNonNull(throwable, "throwable is null");
            try {
                this.close();
            }
            catch (RuntimeException e) {
                logger.error((Throwable)e, e.getMessage());
                if (throwable == e) break block2;
                throwable.addSuppressed(e);
            }
        }
    }

    private final class CarbondataBlockLoader
    implements LazyBlockLoader<LazyBlock> {
        private final int expectedBatchId;
        private final int columnIndex;
        private boolean loaded;

        CarbondataBlockLoader(int columnIndex) {
            this.expectedBatchId = CarbondataPageSource.this.batchId;
            this.columnIndex = columnIndex;
        }

        public final void load(LazyBlock lazyBlock) {
            if (this.loaded) {
                return;
            }
            Preconditions.checkState((CarbondataPageSource.this.batchId == this.expectedBatchId ? 1 : 0) != 0);
            try {
                PrestoVectorBlockBuilder blockBuilder = (PrestoVectorBlockBuilder)CarbondataPageSource.this.vectorReader.getColumnarBatch().column(this.columnIndex);
                blockBuilder.setBatchSize(lazyBlock.getPositionCount());
                Block block = blockBuilder.buildBlock();
                CarbondataPageSource.this.sizeOfData = CarbondataPageSource.this.sizeOfData + block.getSizeInBytes();
                lazyBlock.setBlock(block);
            }
            catch (Exception e) {
                throw new CarbonDataLoadingException("Error in Reading Data from Carbondata ", (Throwable)e);
            }
            this.loaded = true;
        }
    }
}

