/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.presto;

import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.classloader.ThreadContextClassLoader;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorContext;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.classloader.ClassLoaderSafeConnectorMetadata;
import com.facebook.presto.spi.connector.classloader.ClassLoaderSafeConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.classloader.ClassLoaderSafeConnectorSplitManager;
import com.google.common.base.Throwables;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.json.JsonModule;
import java.util.Map;
import java.util.Objects;
import org.apache.carbondata.presto.CarbondataConnector;
import org.apache.carbondata.presto.CarbondataHandleResolver;
import org.apache.carbondata.presto.CarbondataMetadata;
import org.apache.carbondata.presto.CarbondataModule;

public class CarbondataConnectorFactory
implements ConnectorFactory {
    private final String name;
    private final ClassLoader classLoader;

    public CarbondataConnectorFactory(String connectorName, ClassLoader classLoader) {
        this.name = connectorName;
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    public String getName() {
        return this.name;
    }

    public ConnectorHandleResolver getHandleResolver() {
        return new CarbondataHandleResolver();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Connector create(String connectorId, Map<String, String> config, ConnectorContext context) {
        Objects.requireNonNull(config, "config is null");
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Bootstrap app = new Bootstrap(new Module[]{new JsonModule(), new CarbondataModule(connectorId, context.getTypeManager())});
            Injector injector = app.strictConfig().doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
            LifeCycleManager lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
            ConnectorMetadata metadata = (ConnectorMetadata)injector.getInstance(CarbondataMetadata.class);
            ConnectorSplitManager splitManager = (ConnectorSplitManager)injector.getInstance(ConnectorSplitManager.class);
            ConnectorPageSourceProvider connectorPageSource = (ConnectorPageSourceProvider)injector.getInstance(ConnectorPageSourceProvider.class);
            CarbondataConnector carbondataConnector = new CarbondataConnector(lifeCycleManager, (ConnectorMetadata)new ClassLoaderSafeConnectorMetadata(metadata, this.classLoader), (ConnectorSplitManager)new ClassLoaderSafeConnectorSplitManager(splitManager, this.classLoader), this.classLoader, (ConnectorPageSourceProvider)new ClassLoaderSafeConnectorPageSourceProvider(connectorPageSource, this.classLoader));
            return carbondataConnector;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

