/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.presto.readers;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.DictionaryBlock;
import com.facebook.presto.spi.block.SliceArrayBlock;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import io.airlift.slice.Slices;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.scan.result.vector.impl.CarbonColumnVectorImpl;
import org.apache.carbondata.presto.readers.PrestoVectorBlockBuilder;

public class SliceStreamReader
extends CarbonColumnVectorImpl
implements PrestoVectorBlockBuilder {
    protected int batchSize;
    protected Type type = VarcharType.VARCHAR;
    protected BlockBuilder builder;
    int[] values;
    private SliceArrayBlock dictionarySliceArrayBlock;

    public SliceStreamReader(int batchSize, DataType dataType, SliceArrayBlock dictionarySliceArrayBlock) {
        super(batchSize, dataType);
        this.batchSize = batchSize;
        if (dictionarySliceArrayBlock == null) {
            this.builder = this.type.createBlockBuilder(new BlockBuilderStatus(), batchSize);
        } else {
            this.dictionarySliceArrayBlock = dictionarySliceArrayBlock;
            this.values = new int[batchSize];
        }
    }

    @Override
    public Block buildBlock() {
        if (this.dictionarySliceArrayBlock == null) {
            return this.builder.build();
        }
        return new DictionaryBlock(this.batchSize, (Block)this.dictionarySliceArrayBlock, this.values);
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void putInt(int rowId, int value) {
        this.values[rowId] = value;
    }

    public void putBytes(int rowId, byte[] value) {
        this.type.writeSlice(this.builder, Slices.wrappedBuffer((byte[])value));
    }

    public void putBytes(int rowId, int offset, int length, byte[] value) {
        byte[] byteArr = new byte[length];
        System.arraycopy(value, offset, byteArr, 0, length);
        this.type.writeSlice(this.builder, Slices.wrappedBuffer((byte[])byteArr));
    }

    public void putNull(int rowId) {
        if (this.dictionarySliceArrayBlock == null) {
            this.builder.appendNull();
        }
    }

    public void reset() {
        this.builder = this.type.createBlockBuilder(new BlockBuilderStatus(), this.batchSize);
    }
}

