/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.presto.readers;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.Type;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.scan.result.vector.impl.CarbonColumnVectorImpl;
import org.apache.carbondata.presto.readers.PrestoVectorBlockBuilder;

public class ObjectStreamReader
extends CarbonColumnVectorImpl
implements PrestoVectorBlockBuilder {
    protected int batchSize;
    protected Type type = IntegerType.INTEGER;
    protected BlockBuilder builder;

    public ObjectStreamReader(int batchSize, DataType dataType) {
        super(batchSize, dataType);
        this.batchSize = batchSize;
        this.builder = this.type.createBlockBuilder(new BlockBuilderStatus(), batchSize);
    }

    @Override
    public Block buildBlock() {
        return this.builder.build();
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void putObject(int rowId, Object value) {
        this.type.writeObject(this.builder, value);
    }

    public void putNull(int rowId) {
        this.builder.appendNull();
    }

    public void reset() {
        this.builder = this.type.createBlockBuilder(new BlockBuilderStatus(), this.batchSize);
    }
}

