/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.presto.readers;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.Decimals;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Objects;
import org.apache.carbondata.core.cache.dictionary.Dictionary;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.scan.result.vector.impl.CarbonColumnVectorImpl;
import org.apache.carbondata.core.util.DataTypeUtil;
import org.apache.carbondata.presto.readers.PrestoVectorBlockBuilder;

public class DecimalSliceStreamReader
extends CarbonColumnVectorImpl
implements PrestoVectorBlockBuilder {
    private final char[] buffer = new char[100];
    protected int batchSize;
    protected Type type;
    protected BlockBuilder builder;
    private Dictionary dictionary;

    public DecimalSliceStreamReader(int batchSize, org.apache.carbondata.core.metadata.datatype.DecimalType dataType, Dictionary dictionary) {
        super(batchSize, (DataType)dataType);
        this.type = DecimalType.createDecimalType((int)dataType.getPrecision(), (int)dataType.getScale());
        this.batchSize = batchSize;
        this.builder = this.type.createBlockBuilder(new BlockBuilderStatus(), batchSize);
        this.dictionary = dictionary;
    }

    @Override
    public Block buildBlock() {
        return this.builder.build();
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void putInt(int rowId, int value) {
        DecimalType decimalType = (DecimalType)this.type;
        Object data = DataTypeUtil.getDataBasedOnDataType((String)this.dictionary.getDictionaryValueForKey(value), (DataType)DataTypes.createDecimalType((int)decimalType.getPrecision(), (int)decimalType.getScale()));
        if (Objects.isNull(data)) {
            this.builder.appendNull();
        } else {
            this.decimalBlockWriter((BigDecimal)data);
        }
    }

    public void putDecimal(int rowId, BigDecimal value, int precision) {
        this.decimalBlockWriter(value);
    }

    public void putNull(int rowId) {
        this.builder.appendNull();
    }

    public void reset() {
        this.builder = this.type.createBlockBuilder(new BlockBuilderStatus(), this.batchSize);
    }

    private void decimalBlockWriter(BigDecimal value) {
        if (Decimals.isShortDecimal((Type)this.type)) {
            long rescaledDecimal = Decimals.rescale((long)value.unscaledValue().longValue(), (int)value.scale(), (int)((DecimalType)this.type).getScale());
            this.type.writeLong(this.builder, rescaledDecimal);
        } else {
            Slice slice = this.getSlice(value, this.type);
            this.type.writeSlice(this.builder, this.parseSlice((DecimalType)this.type, slice, slice.length()));
        }
    }

    private Slice getSlice(Object value, Type type) {
        if (type instanceof DecimalType) {
            DecimalType actual = (DecimalType)type;
            BigDecimal bigDecimalValue = (BigDecimal)value;
            if (Decimals.isShortDecimal((Type)type)) {
                return Slices.utf8Slice((String)value.toString());
            }
            if (bigDecimalValue.scale() > actual.getScale()) {
                BigInteger unscaledDecimal = Decimals.rescale((BigInteger)bigDecimalValue.unscaledValue(), (int)bigDecimalValue.scale(), (int)bigDecimalValue.scale());
                Slice decimalSlice = Decimals.encodeUnscaledValue((BigInteger)unscaledDecimal);
                return Slices.utf8Slice((String)Decimals.toString((Slice)decimalSlice, (int)actual.getScale()));
            }
            BigInteger unscaledDecimal = Decimals.rescale((BigInteger)bigDecimalValue.unscaledValue(), (int)bigDecimalValue.scale(), (int)actual.getScale());
            Slice decimalSlice = Decimals.encodeUnscaledValue((BigInteger)unscaledDecimal);
            return Slices.utf8Slice((String)Decimals.toString((Slice)decimalSlice, (int)actual.getScale()));
        }
        return Slices.utf8Slice((String)value.toString());
    }

    private Slice parseSlice(DecimalType type, Slice slice, int length) {
        BigDecimal decimal = this.parseBigDecimal(type, slice, length);
        return Decimals.encodeUnscaledValue((BigInteger)decimal.unscaledValue());
    }

    private BigDecimal parseBigDecimal(DecimalType type, Slice slice, int length) {
        int offset = 0;
        Preconditions.checkArgument((length < this.buffer.length ? 1 : 0) != 0);
        for (int i = 0; i < length; ++i) {
            this.buffer[i] = (char)slice.getByte(offset + i);
        }
        BigDecimal decimal = new BigDecimal(this.buffer, 0, length);
        Preconditions.checkState((decimal.scale() <= type.getScale() ? 1 : 0) != 0, (Object)"Read decimal value scale larger than column scale");
        decimal = decimal.setScale(type.getScale(), RoundingMode.HALF_UP);
        Preconditions.checkState((decimal.precision() <= type.getPrecision() ? 1 : 0) != 0, (Object)"Read decimal precision larger than column precision");
        return decimal;
    }
}

