/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.presto.readers;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import org.apache.carbondata.core.cache.dictionary.Dictionary;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.scan.result.vector.impl.CarbonColumnVectorImpl;
import org.apache.carbondata.core.util.DataTypeUtil;
import org.apache.carbondata.presto.readers.PrestoVectorBlockBuilder;

public class BooleanStreamReader
extends CarbonColumnVectorImpl
implements PrestoVectorBlockBuilder {
    protected int batchSize;
    protected Type type = BooleanType.BOOLEAN;
    protected BlockBuilder builder;
    private Dictionary dictionary;

    public BooleanStreamReader(int batchSize, DataType dataType, Dictionary dictionary) {
        super(batchSize, dataType);
        this.batchSize = batchSize;
        this.builder = this.type.createBlockBuilder(new BlockBuilderStatus(), batchSize);
        this.dictionary = dictionary;
    }

    @Override
    public Block buildBlock() {
        return this.builder.build();
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void putInt(int rowId, int value) {
        Object data = DataTypeUtil.getDataBasedOnDataType((String)this.dictionary.getDictionaryValueForKey(value), (DataType)DataTypes.BOOLEAN);
        if (data != null) {
            this.type.writeBoolean(this.builder, ((Boolean)data).booleanValue());
        } else {
            this.builder.appendNull();
        }
    }

    public void putBoolean(int rowId, boolean value) {
        this.type.writeBoolean(this.builder, value);
    }

    public void putNull(int rowId) {
        this.builder.appendNull();
    }

    public void reset() {
        this.builder = this.type.createBlockBuilder(new BlockBuilderStatus(), this.batchSize);
    }
}

