/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.presto.impl;

import com.facebook.presto.hadoop.;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.classloader.ThreadContextClassLoader;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.carbondata.common.logging.LogService;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datamap.DataMapStoreManager;
import org.apache.carbondata.core.datastore.filesystem.CarbonFile;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.indexstore.PartitionSpec;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.CarbonMetadata;
import org.apache.carbondata.core.metadata.CarbonTableIdentifier;
import org.apache.carbondata.core.metadata.SegmentFileStore;
import org.apache.carbondata.core.metadata.converter.ThriftWrapperSchemaConverterImpl;
import org.apache.carbondata.core.metadata.schema.PartitionInfo;
import org.apache.carbondata.core.metadata.schema.partition.PartitionType;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.reader.ThriftReader;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.statusmanager.LoadMetadataDetails;
import org.apache.carbondata.core.statusmanager.SegmentStatusManager;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.carbondata.format.TableInfo;
import org.apache.carbondata.hadoop.CarbonInputSplit;
import org.apache.carbondata.hadoop.api.CarbonTableInputFormat;
import org.apache.carbondata.presto.PrestoFilterUtil;
import org.apache.carbondata.presto.impl.CarbonLocalInputSplit;
import org.apache.carbondata.presto.impl.CarbonLocalMultiBlockSplit;
import org.apache.carbondata.presto.impl.CarbonTableCacheModel;
import org.apache.carbondata.presto.impl.CarbonTableConfig;
import org.apache.commons.lang.time.DateUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.thrift.TBase;

public class CarbonTableReader {
    private static final PathFilter DefaultFilter = new PathFilter(){

        public boolean accept(Path path) {
            return CarbonTablePath.isCarbonDataFile((String)path.getName());
        }
    };
    public CarbonTableConfig config;
    private .ConcurrentSet<SchemaTableName> tableList;
    private CarbonFile carbonFileList;
    private FileFactory.FileType fileType;
    private AtomicReference<HashMap<SchemaTableName, CarbonTableCacheModel>> carbonCache;
    private LoadMetadataDetails[] loadMetadataDetails;
    private String queryId;
    private static final LogService LOGGER = LogServiceFactory.getLogService((String)CarbonTableReader.class.getName());
    private List<String> schemaNames = new ArrayList<String>();

    @Inject
    public CarbonTableReader(CarbonTableConfig config) {
        this.config = Objects.requireNonNull(config, "CarbonTableConfig is null");
        this.carbonCache = new AtomicReference(new HashMap());
        this.tableList = new .ConcurrentSet();
        this.setS3Properties();
        this.populateCarbonProperties();
    }

    public CarbonTableCacheModel getCarbonCache(SchemaTableName table) {
        if (!this.carbonCache.get().containsKey(table) || this.carbonCache.get().get(table) == null) {
            block16: {
                try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(FileFactory.class.getClassLoader());){
                    if (this.carbonFileList != null) break block16;
                    this.fileType = FileFactory.getFileType((String)this.config.getStorePath());
                    try {
                        this.carbonFileList = FileFactory.getCarbonFile((String)this.config.getStorePath(), (FileFactory.FileType)this.fileType);
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                }
            }
            this.updateSchemaTables(table);
            this.parseCarbonMetadata(table);
        }
        if (this.carbonCache.get().containsKey(table)) {
            return this.carbonCache.get().get(table);
        }
        return null;
    }

    private void removeTableFromCache(SchemaTableName table) {
        DataMapStoreManager.getInstance().clearDataMaps(this.carbonCache.get().get((Object)table).carbonTable.getAbsoluteTableIdentifier());
        this.carbonCache.get().remove(table);
        this.tableList.remove((Object)table);
    }

    public List<String> getSchemaNames() {
        return this.updateSchemaList();
    }

    private boolean updateCarbonFile() {
        if (this.carbonFileList == null) {
            this.fileType = FileFactory.getFileType((String)this.config.getStorePath());
            try {
                this.carbonFileList = FileFactory.getCarbonFile((String)this.config.getStorePath(), (FileFactory.FileType)this.fileType);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return true;
    }

    private List<String> updateSchemaList() {
        this.updateCarbonFile();
        if (this.carbonFileList != null) {
            Stream.of(this.carbonFileList.listFiles()).forEach(this::getName);
            return this.schemaNames;
        }
        return ImmutableList.of();
    }

    private void getName(CarbonFile carbonFile) {
        if (!carbonFile.getName().equalsIgnoreCase("_system") && !carbonFile.getName().equalsIgnoreCase(".ds_store")) {
            this.schemaNames.add(carbonFile.getName());
        }
    }

    public Set<String> getTableNames(String schema) {
        Objects.requireNonNull(schema, "schema is null");
        return this.updateTableList(schema);
    }

    private Set<String> updateTableList(String schemaName) {
        this.updateCarbonFile();
        List schema = Stream.of(this.carbonFileList.listFiles()).filter(a -> schemaName.equals(a.getName())).collect(Collectors.toList());
        if (schema.size() > 0) {
            return Stream.of(((CarbonFile)schema.get(0)).listFiles()).map(CarbonFile::getName).collect(Collectors.toSet());
        }
        return ImmutableSet.of();
    }

    public CarbonTable getTable(SchemaTableName schemaTableName) {
        try {
            this.updateSchemaTables(schemaTableName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Objects.requireNonNull(schemaTableName, "schemaTableName is null");
        return this.loadTableMetadata(schemaTableName);
    }

    private void updateSchemaTables(SchemaTableName schemaTableName) {
        CarbonTableCacheModel carbonTableCacheModel;
        boolean isKeyExists = this.carbonCache.get().containsKey(schemaTableName);
        if (this.carbonFileList == null) {
            this.updateSchemaList();
        }
        try {
            if (isKeyExists && !FileFactory.isFileExist((String)CarbonTablePath.getSchemaFilePath((String)this.carbonCache.get().get((Object)schemaTableName).carbonTable.getTablePath()), (FileFactory.FileType)this.fileType)) {
                this.removeTableFromCache(schemaTableName);
                throw new TableNotFoundException(schemaTableName);
            }
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
        if (isKeyExists && (carbonTableCacheModel = this.carbonCache.get().get(schemaTableName)) != null && carbonTableCacheModel.carbonTable.getTableInfo() != null) {
            Long latestTime = FileFactory.getCarbonFile((String)CarbonTablePath.getSchemaFilePath((String)this.carbonCache.get().get((Object)schemaTableName).carbonTable.getTablePath())).getLastModifiedTime();
            Long oldTime = carbonTableCacheModel.carbonTable.getTableInfo().getLastUpdatedTime();
            if (DateUtils.truncate((Date)new Date(latestTime), (int)12).after(DateUtils.truncate((Date)new Date(oldTime), (int)12))) {
                this.removeTableFromCache(schemaTableName);
            }
        }
        if (!this.tableList.contains((Object)schemaTableName)) {
            for (CarbonFile cf : this.carbonFileList.listFiles()) {
                if (cf.getName().endsWith(".mdt")) continue;
                for (CarbonFile table : cf.listFiles()) {
                    this.tableList.add((Object)new SchemaTableName(cf.getName(), table.getName()));
                }
            }
        }
    }

    private CarbonTable loadTableMetadata(SchemaTableName schemaTableName) {
        for (SchemaTableName table : this.tableList) {
            if (!table.equals((Object)schemaTableName)) continue;
            return this.parseCarbonMetadata(table);
        }
        throw new TableNotFoundException(schemaTableName);
    }

    private CarbonTable parseCarbonMetadata(SchemaTableName table) {
        CarbonTable result = null;
        try {
            CarbonTableCacheModel cache = this.carbonCache.get().get(table);
            if (cache == null) {
                cache = new CarbonTableCacheModel();
            }
            if (cache.isValid()) {
                return cache.carbonTable;
            }
            CarbonTableIdentifier carbonTableIdentifier = new CarbonTableIdentifier(table.getSchemaName(), table.getTableName(), UUID.randomUUID().toString());
            String storePath = this.config.getStorePath();
            String tablePath = storePath + "/" + carbonTableIdentifier.getDatabaseName() + "/" + carbonTableIdentifier.getTableName();
            ThriftReader.TBaseCreator createTBase = new ThriftReader.TBaseCreator(){

                public TBase create() {
                    return new TableInfo();
                }
            };
            ThriftReader thriftReader = new ThriftReader(CarbonTablePath.getSchemaFilePath((String)tablePath), createTBase);
            thriftReader.open();
            TableInfo tableInfo = (TableInfo)thriftReader.read();
            thriftReader.close();
            ThriftWrapperSchemaConverterImpl schemaConverter = new ThriftWrapperSchemaConverterImpl();
            org.apache.carbondata.core.metadata.schema.table.TableInfo wrapperTableInfo = schemaConverter.fromExternalToWrapperTableInfo(tableInfo, table.getSchemaName(), table.getTableName(), tablePath);
            CarbonMetadata.getInstance().loadTableMetadata(wrapperTableInfo);
            cache.carbonTable = CarbonMetadata.getInstance().getCarbonTable(table.getSchemaName(), table.getTableName());
            this.carbonCache.get().put(table, cache);
            result = cache.carbonTable;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return result;
    }

    public List<CarbonLocalMultiBlockSplit> getInputSplits2(CarbonTableCacheModel tableCacheModel, Expression filters, TupleDomain<ColumnHandle> constraints) throws IOException {
        ArrayList<CarbonLocalInputSplit> result = new ArrayList<CarbonLocalInputSplit>();
        ArrayList<CarbonLocalMultiBlockSplit> multiBlockSplitList = new ArrayList<CarbonLocalMultiBlockSplit>();
        CarbonTable carbonTable = tableCacheModel.carbonTable;
        org.apache.carbondata.core.metadata.schema.table.TableInfo tableInfo = tableCacheModel.carbonTable.getTableInfo();
        Configuration config = new Configuration();
        config.set("mapreduce.input.carboninputformat.segmentnumbers", "");
        String carbonTablePath = carbonTable.getAbsoluteTableIdentifier().getTablePath();
        config.set("mapreduce.input.fileinputformat.inputdir", carbonTablePath);
        config.set("mapreduce.input.carboninputformat.databaseName", carbonTable.getDatabaseName());
        config.set("mapreduce.input.carboninputformat.tableName", carbonTable.getTableName());
        config.set("query.id", this.queryId);
        JobConf jobConf = new JobConf(config);
        List<PartitionSpec> filteredPartitions = new ArrayList<PartitionSpec>();
        PartitionInfo partitionInfo = carbonTable.getPartitionInfo(carbonTable.getTableName());
        if (partitionInfo != null && partitionInfo.getPartitionType() == PartitionType.NATIVE_HIVE) {
            try {
                this.loadMetadataDetails = SegmentStatusManager.readTableStatusFile((String)CarbonTablePath.getTableStatusFilePath((String)carbonTable.getTablePath()));
            }
            catch (IOException exception) {
                LOGGER.error(exception.getMessage());
                throw exception;
            }
            filteredPartitions = this.findRequiredPartitions(constraints, carbonTable, this.loadMetadataDetails);
        }
        try {
            CarbonTableInputFormat.setTableInfo((Configuration)config, (org.apache.carbondata.core.metadata.schema.table.TableInfo)tableInfo);
            CarbonTableInputFormat<Object> carbonTableInputFormat = this.createInputFormat((Configuration)jobConf, carbonTable.getAbsoluteTableIdentifier(), filters, filteredPartitions);
            Job job = Job.getInstance((Configuration)jobConf);
            List splits = carbonTableInputFormat.getSplits((JobContext)job);
            .Gson gson = new .Gson();
            if (splits != null && splits.size() > 0) {
                for (InputSplit inputSplit : splits) {
                    CarbonInputSplit carbonInputSplit = (CarbonInputSplit)inputSplit;
                    result.add(new CarbonLocalInputSplit(carbonInputSplit.getSegmentId(), carbonInputSplit.getPath().toString(), carbonInputSplit.getStart(), carbonInputSplit.getLength(), Arrays.asList(carbonInputSplit.getLocations()), carbonInputSplit.getNumberOfBlocklets(), carbonInputSplit.getVersion().number(), carbonInputSplit.getDeleteDeltaFiles(), carbonInputSplit.getBlockletId(), gson.toJson((Object)carbonInputSplit.getDetailInfo())));
                }
                ArrayList<List<CarbonLocalInputSplit>> inputSplits = new ArrayList<List<CarbonLocalInputSplit>>(result.stream().map(x -> x).collect(Collectors.groupingBy(carbonInput -> carbonInput.getSegmentId().concat(carbonInput.getPath()))).values());
                if (inputSplits != null) {
                    for (int j = 0; j < inputSplits.size(); ++j) {
                        multiBlockSplitList.add(new CarbonLocalMultiBlockSplit((List)inputSplits.get(j), (String[])((List)inputSplits.get(j)).stream().flatMap(f -> Arrays.stream(this.getLocations((CarbonLocalInputSplit)f))).distinct().toArray(String[]::new)));
                    }
                }
                LOGGER.error("Size fo MultiblockList   " + multiBlockSplitList.size());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating Splits from CarbonTableInputFormat", e);
        }
        return multiBlockSplitList;
    }

    private List<PartitionSpec> findRequiredPartitions(TupleDomain<ColumnHandle> constraints, CarbonTable carbonTable, LoadMetadataDetails[] loadMetadataDetails) throws IOException {
        HashSet partitionSpecs = new HashSet();
        ArrayList<PartitionSpec> prunePartitions = new ArrayList<PartitionSpec>();
        for (LoadMetadataDetails loadMetadataDetail : loadMetadataDetails) {
            SegmentFileStore segmentFileStore = null;
            try {
                segmentFileStore = new SegmentFileStore(carbonTable.getTablePath(), loadMetadataDetail.getSegmentFile());
                partitionSpecs.addAll(segmentFileStore.getPartitionSpecs());
            }
            catch (IOException exception) {
                LOGGER.error(exception.getMessage());
                throw exception;
            }
        }
        List<String> partitionValuesFromExpression = PrestoFilterUtil.getPartitionFilters(carbonTable, constraints);
        List partitionSpecList = partitionSpecs.stream().filter(partitionSpec -> .CollectionUtils.isSubCollection((Collection)partitionValuesFromExpression, (Collection)partitionSpec.getPartitions())).collect(Collectors.toList());
        prunePartitions.addAll(partitionSpecList);
        return prunePartitions;
    }

    private CarbonTableInputFormat<Object> createInputFormat(Configuration conf, AbsoluteTableIdentifier identifier, Expression filterExpression, List<PartitionSpec> filteredPartitions) throws IOException {
        CarbonTableInputFormat format = new CarbonTableInputFormat();
        CarbonTableInputFormat.setTablePath((Configuration)conf, (String)identifier.appendWithLocalPrefix(identifier.getTablePath()));
        CarbonTableInputFormat.setFilterPredicates((Configuration)conf, (Expression)filterExpression);
        if (filteredPartitions.size() != 0) {
            CarbonTableInputFormat.setPartitionsToPrune((Configuration)conf, filteredPartitions);
        }
        return format;
    }

    private void populateCarbonProperties() {
        this.addProperty("carbon.unsafe.working.memory.in.mb", this.config.getUnsafeMemoryInMb());
        this.addProperty("enable.unsafe.in.query.processing", this.config.getEnableUnsafeInQueryExecution());
        this.addProperty("enable.unsafe.columnpage", this.config.getEnableUnsafeColumnPage());
        this.addProperty("enable.unsafe.sort", this.config.getEnableUnsafeSort());
        this.addProperty("enable.query.statistics", this.config.getEnableQueryStatistics());
    }

    private void setS3Properties() {
        FileFactory.getConfiguration().set("fs.s3a.access.key", Objects.toString(this.config.getS3A_AcesssKey(), ""));
        FileFactory.getConfiguration().set("fs.s3a.secret.key", Objects.toString(this.config.getS3A_SecretKey()));
        FileFactory.getConfiguration().set("fs.s3.awsAccessKeyId", Objects.toString(this.config.getS3_AcesssKey(), ""));
        FileFactory.getConfiguration().set("fs.s3.awsSecretAccessKey", Objects.toString(this.config.getS3_SecretKey()));
        FileFactory.getConfiguration().set("fs.s3n.awsAccessKeyId", Objects.toString(this.config.getS3N_AcesssKey(), ""));
        FileFactory.getConfiguration().set("fs.s3n.awsSecretAccessKey", Objects.toString(this.config.getS3N_SecretKey(), ""));
        FileFactory.getConfiguration().set("fs.s3a.endpoint", Objects.toString(this.config.getS3EndPoint(), ""));
    }

    private void addProperty(String propertyName, String propertyValue) {
        if (propertyValue != null) {
            CarbonProperties.getInstance().addProperty(propertyName, propertyValue);
        }
    }

    private String[] getLocations(CarbonLocalInputSplit cis) {
        return cis.getLocations().toArray(new String[cis.getLocations().size()]);
    }

    public String getQueryId() {
        return this.queryId;
    }

    public void setQueryId(String queryId) {
        this.queryId = queryId;
    }
}

