/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.presto;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.carbondata.core.cache.dictionary.Dictionary;
import org.apache.carbondata.core.keygenerator.directdictionary.DirectDictionaryGenerator;
import org.apache.carbondata.core.keygenerator.directdictionary.DirectDictionaryKeyGeneratorFactory;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.datatype.StructField;
import org.apache.carbondata.core.metadata.encoder.Encoding;
import org.apache.carbondata.core.scan.executor.QueryExecutor;
import org.apache.carbondata.core.scan.executor.QueryExecutorFactory;
import org.apache.carbondata.core.scan.executor.exception.QueryExecutionException;
import org.apache.carbondata.core.scan.model.ProjectionDimension;
import org.apache.carbondata.core.scan.model.ProjectionMeasure;
import org.apache.carbondata.core.scan.model.QueryModel;
import org.apache.carbondata.core.scan.result.iterator.AbstractDetailQueryResultIterator;
import org.apache.carbondata.core.scan.result.vector.CarbonColumnVector;
import org.apache.carbondata.core.scan.result.vector.CarbonColumnarBatch;
import org.apache.carbondata.core.stats.QueryStatistic;
import org.apache.carbondata.core.stats.QueryStatisticsRecorder;
import org.apache.carbondata.core.stats.TaskStatistics;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.hadoop.AbstractRecordReader;
import org.apache.carbondata.hadoop.CarbonInputSplit;
import org.apache.carbondata.hadoop.CarbonMultiBlockSplit;
import org.apache.carbondata.presto.CarbonColumnVectorWrapper;
import org.apache.carbondata.presto.CarbonDictionaryDecodeReadSupport;
import org.apache.carbondata.presto.CarbonVectorBatch;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

class PrestoCarbonVectorizedRecordReader
extends AbstractRecordReader<Object> {
    private int batchIdx = 0;
    private int numBatched = 0;
    private CarbonVectorBatch columnarBatch;
    private CarbonColumnarBatch carbonColumnarBatch;
    private boolean returnColumnarBatch;
    private QueryModel queryModel;
    private AbstractDetailQueryResultIterator iterator;
    private QueryExecutor queryExecutor;
    private long taskId;
    private long queryStartTime;
    private CarbonDictionaryDecodeReadSupport readSupport;

    public PrestoCarbonVectorizedRecordReader(QueryExecutor queryExecutor, QueryModel queryModel, AbstractDetailQueryResultIterator iterator, CarbonDictionaryDecodeReadSupport readSupport) {
        this.queryModel = queryModel;
        this.iterator = iterator;
        this.queryExecutor = queryExecutor;
        this.readSupport = readSupport;
        this.enableReturningBatches();
        this.queryStartTime = System.currentTimeMillis();
    }

    public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException, UnsupportedOperationException {
        List<Object> splitList;
        if (inputSplit instanceof CarbonInputSplit) {
            splitList = new ArrayList<CarbonInputSplit>(1);
            splitList.add((CarbonInputSplit)inputSplit);
        } else if (inputSplit instanceof CarbonMultiBlockSplit) {
            CarbonMultiBlockSplit multiBlockSplit = (CarbonMultiBlockSplit)inputSplit;
            splitList = multiBlockSplit.getAllSplits();
        } else {
            throw new RuntimeException("unsupported input split type: " + inputSplit);
        }
        List tableBlockInfoList = CarbonInputSplit.createBlocks(splitList);
        this.queryModel.setTableBlockInfos(tableBlockInfoList);
        this.queryModel.setVectorReader(true);
        try {
            this.queryExecutor = QueryExecutorFactory.getQueryExecutor((QueryModel)this.queryModel);
            this.iterator = (AbstractDetailQueryResultIterator)this.queryExecutor.execute(this.queryModel);
        }
        catch (QueryExecutionException e) {
            throw new InterruptedException(e.getMessage());
        }
    }

    public void close() throws IOException {
        Map columnToDictionaryMapping;
        this.logStatistics(this.rowCount, this.queryModel.getStatisticsRecorder());
        if (this.columnarBatch != null) {
            this.columnarBatch = null;
        }
        if (null != (columnToDictionaryMapping = this.queryModel.getColumnToDictionaryMapping())) {
            for (Map.Entry entry : columnToDictionaryMapping.entrySet()) {
                CarbonUtil.clearDictionaryCache((Dictionary)((Dictionary)entry.getValue()));
            }
        }
        try {
            this.queryExecutor.finish();
        }
        catch (QueryExecutionException e) {
            throw new IOException(e);
        }
        this.logStatistics(this.taskId, this.queryStartTime, this.queryModel.getStatisticsRecorder());
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        this.resultBatch();
        if (this.returnColumnarBatch) {
            return this.nextBatch();
        }
        if (this.batchIdx >= this.numBatched && !this.nextBatch()) {
            return false;
        }
        ++this.batchIdx;
        return true;
    }

    public Object getCurrentValue() throws IOException, InterruptedException {
        if (this.returnColumnarBatch) {
            this.rowCount += this.columnarBatch.numValidRows();
            return this.columnarBatch;
        }
        return null;
    }

    public Void getCurrentKey() throws IOException, InterruptedException {
        return null;
    }

    public float getProgress() throws IOException, InterruptedException {
        return 0.0f;
    }

    private void initBatch() {
        List queryDimension = this.queryModel.getProjectionDimensions();
        List queryMeasures = this.queryModel.getProjectionMeasures();
        StructField[] fields = new StructField[queryDimension.size() + queryMeasures.size()];
        for (int i = 0; i < queryDimension.size(); ++i) {
            ProjectionDimension dim = (ProjectionDimension)queryDimension.get(i);
            if (dim.getDimension().hasEncoding(Encoding.DIRECT_DICTIONARY)) {
                DirectDictionaryGenerator generator = DirectDictionaryKeyGeneratorFactory.getDirectDictionaryGenerator((DataType)dim.getDimension().getDataType());
                fields[dim.getOrdinal()] = new StructField(dim.getColumnName(), generator.getReturnType());
                continue;
            }
            fields[dim.getOrdinal()] = !dim.getDimension().hasEncoding(Encoding.DICTIONARY) ? new StructField(dim.getColumnName(), dim.getDimension().getDataType()) : (dim.getDimension().isComplex() != false ? new StructField(dim.getColumnName(), dim.getDimension().getDataType()) : new StructField(dim.getColumnName(), DataTypes.INT));
        }
        for (ProjectionMeasure msr : queryMeasures) {
            DataType dataType = msr.getMeasure().getDataType();
            if (dataType == DataTypes.BOOLEAN || dataType == DataTypes.SHORT || dataType == DataTypes.INT || dataType == DataTypes.LONG) {
                fields[msr.getOrdinal()] = new StructField(msr.getColumnName(), msr.getMeasure().getDataType());
                continue;
            }
            if (DataTypes.isDecimal((DataType)dataType)) {
                fields[msr.getOrdinal()] = new StructField(msr.getColumnName(), msr.getMeasure().getDataType());
                continue;
            }
            fields[msr.getOrdinal()] = new StructField(msr.getColumnName(), DataTypes.DOUBLE);
        }
        this.columnarBatch = CarbonVectorBatch.allocate(fields, this.readSupport);
        CarbonColumnVector[] vectors = new CarbonColumnVector[fields.length];
        boolean[] filteredRows = new boolean[this.columnarBatch.capacity()];
        for (int i = 0; i < fields.length; ++i) {
            vectors[i] = new CarbonColumnVectorWrapper(this.columnarBatch.column(i), filteredRows);
        }
        this.carbonColumnarBatch = new CarbonColumnarBatch(vectors, this.columnarBatch.capacity(), filteredRows);
    }

    private CarbonVectorBatch resultBatch() {
        if (this.columnarBatch == null) {
            this.initBatch();
        }
        return this.columnarBatch;
    }

    private void enableReturningBatches() {
        this.returnColumnarBatch = true;
    }

    private boolean nextBatch() {
        this.columnarBatch.reset();
        this.carbonColumnarBatch.reset();
        if (this.iterator.hasNext()) {
            this.iterator.processNextBatch(this.carbonColumnarBatch);
            int actualSize = this.carbonColumnarBatch.getActualSize();
            this.columnarBatch.setNumRows(actualSize);
            this.numBatched = actualSize;
            this.batchIdx = 0;
            return true;
        }
        return false;
    }

    public CarbonVectorBatch getColumnarBatch() {
        return this.columnarBatch;
    }

    public void setTaskId(long taskId) {
        this.taskId = taskId;
    }

    private void logStatistics(Long taskId, Long queryStartTime, QueryStatisticsRecorder recorder) {
        if (null != recorder) {
            QueryStatistic queryStatistic = new QueryStatistic();
            queryStatistic.addFixedTimeStatistic("Total Time taken to execute the query in executor Side", System.currentTimeMillis() - queryStartTime);
            recorder.recordStatistics(queryStatistic);
            TaskStatistics statistics = recorder.statisticsForTask(taskId.longValue(), queryStartTime.longValue());
            recorder.logStatisticsForTask(statistics);
        }
    }
}

