/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.presto;

import java.math.BigDecimal;
import java.util.ArrayList;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.scan.result.vector.CarbonColumnVector;
import org.apache.carbondata.core.scan.result.vector.CarbonDictionary;
import org.apache.carbondata.core.scan.result.vector.impl.CarbonColumnVectorImpl;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.NullType;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType;

public class CarbonColumnVectorWrapper
implements CarbonColumnVector {
    private CarbonColumnVectorImpl columnVector;
    private boolean[] filteredRows;
    private int counter;
    private boolean filteredRowsExist;
    private DataType blockDataType;

    public CarbonColumnVectorWrapper(CarbonColumnVectorImpl columnVector, boolean[] filteredRows) {
        this.columnVector = columnVector;
        this.filteredRows = filteredRows;
    }

    public void putBoolean(int rowId, boolean value) {
        if (!this.filteredRows[rowId]) {
            this.columnVector.putBoolean(this.counter++, value);
        }
    }

    public void putFloat(int rowId, float value) {
        if (!this.filteredRows[rowId]) {
            this.columnVector.putFloat(this.counter++, value);
        }
    }

    public void putShort(int rowId, short value) {
        if (!this.filteredRows[rowId]) {
            this.columnVector.putShort(this.counter++, value);
        }
    }

    public void putShorts(int rowId, int count, short value) {
        if (this.filteredRowsExist) {
            for (int i = 0; i < count; ++i) {
                if (!this.filteredRows[rowId]) {
                    this.columnVector.putShort(this.counter++, value);
                }
                ++rowId;
            }
        } else {
            this.columnVector.putShorts(rowId, count, value);
        }
    }

    public void putInt(int rowId, int value) {
        if (!this.filteredRows[rowId]) {
            this.columnVector.putInt(this.counter++, value);
        }
    }

    public void putInts(int rowId, int count, int value) {
        if (this.filteredRowsExist) {
            for (int i = 0; i < count; ++i) {
                if (!this.filteredRows[rowId]) {
                    this.columnVector.putInt(this.counter++, value);
                }
                ++rowId;
            }
        } else {
            this.columnVector.putInts(rowId, count, value);
        }
    }

    public void putLong(int rowId, long value) {
        if (!this.filteredRows[rowId]) {
            this.columnVector.putLong(this.counter++, value);
        }
    }

    public void putLongs(int rowId, int count, long value) {
        if (this.filteredRowsExist) {
            for (int i = 0; i < count; ++i) {
                if (!this.filteredRows[rowId]) {
                    this.columnVector.putLong(this.counter++, value);
                }
                ++rowId;
            }
        } else {
            this.columnVector.putLongs(rowId, count, value);
        }
    }

    public void putDecimal(int rowId, BigDecimal value, int precision) {
        if (!this.filteredRows[rowId]) {
            this.columnVector.putDecimal(this.counter++, value, precision);
        }
    }

    public void putDecimals(int rowId, int count, BigDecimal value, int precision) {
        for (int i = 0; i < count; ++i) {
            if (!this.filteredRows[rowId]) {
                this.columnVector.putDecimal(this.counter++, value, precision);
            }
            ++rowId;
        }
    }

    public void putDouble(int rowId, double value) {
        if (!this.filteredRows[rowId]) {
            this.columnVector.putDouble(this.counter++, value);
        }
    }

    public void putDoubles(int rowId, int count, double value) {
        if (this.filteredRowsExist) {
            for (int i = 0; i < count; ++i) {
                if (!this.filteredRows[rowId]) {
                    this.columnVector.putDouble(this.counter++, value);
                }
                ++rowId;
            }
        } else {
            this.columnVector.putDoubles(rowId, count, value);
        }
    }

    public void putBytes(int rowId, byte[] value) {
        if (!this.filteredRows[rowId]) {
            this.columnVector.putBytes(this.counter++, value);
        }
    }

    public void putBytes(int rowId, int count, byte[] value) {
        for (int i = 0; i < count; ++i) {
            if (!this.filteredRows[rowId]) {
                this.columnVector.putBytes(this.counter++, value);
            }
            ++rowId;
        }
    }

    public void putBytes(int rowId, int offset, int length, byte[] value) {
        if (!this.filteredRows[rowId]) {
            this.columnVector.putBytes(this.counter++, offset, length, value);
        }
    }

    public void putNull(int rowId) {
        if (!this.filteredRows[rowId]) {
            this.columnVector.putNull(this.counter++);
        }
    }

    public void putNulls(int rowId, int count) {
        if (this.filteredRowsExist) {
            for (int i = 0; i < count; ++i) {
                if (!this.filteredRows[rowId]) {
                    this.columnVector.putNull(this.counter++);
                }
                ++rowId;
            }
        } else {
            this.columnVector.putNulls(rowId, count);
        }
    }

    public void putNotNull(int rowId) {
    }

    public void putNotNull(int rowId, int count) {
    }

    public boolean isNull(int rowId) {
        return this.columnVector.isNullAt(rowId);
    }

    public void putObject(int rowId, Object obj) {
    }

    public Object getData(int rowId) {
        return null;
    }

    public void reset() {
        this.counter = 0;
        this.filteredRowsExist = false;
    }

    public DataType getType() {
        return this.columnVector.getType();
    }

    public DataType getBlockDataType() {
        return this.blockDataType;
    }

    public void setBlockDataType(DataType blockDataType) {
        this.blockDataType = blockDataType;
    }

    public void setFilteredRowsExist(boolean filteredRowsExist) {
        this.filteredRowsExist = filteredRowsExist;
    }

    public void setDictionary(CarbonDictionary dictionary) {
        this.columnVector.setDictionary(dictionary);
    }

    public boolean hasDictionary() {
        return this.columnVector.hasDictionary();
    }

    public CarbonColumnVector getDictionaryVector() {
        return this.columnVector;
    }

    private DataType convertSparkToCarbonDataType(org.apache.spark.sql.types.DataType dataType) {
        if (dataType instanceof StringType) {
            return DataTypes.STRING;
        }
        if (dataType instanceof ShortType) {
            return DataTypes.SHORT;
        }
        if (dataType instanceof IntegerType) {
            return DataTypes.INT;
        }
        if (dataType instanceof LongType) {
            return DataTypes.LONG;
        }
        if (dataType instanceof DoubleType) {
            return DataTypes.DOUBLE;
        }
        if (dataType instanceof FloatType) {
            return DataTypes.FLOAT;
        }
        if (dataType instanceof DateType) {
            return DataTypes.DATE;
        }
        if (dataType instanceof BooleanType) {
            return DataTypes.BOOLEAN;
        }
        if (dataType instanceof TimestampType) {
            return DataTypes.TIMESTAMP;
        }
        if (dataType instanceof NullType) {
            return DataTypes.NULL;
        }
        if (dataType instanceof DecimalType) {
            DecimalType decimal = (DecimalType)dataType;
            return DataTypes.createDecimalType((int)decimal.precision(), (int)decimal.scale());
        }
        if (dataType instanceof ArrayType) {
            org.apache.spark.sql.types.DataType elementType = ((ArrayType)dataType).elementType();
            return DataTypes.createArrayType((DataType)this.convertSparkToCarbonDataType(elementType));
        }
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            StructField[] fields = structType.fields();
            ArrayList<org.apache.carbondata.core.metadata.datatype.StructField> carbonFields = new ArrayList<org.apache.carbondata.core.metadata.datatype.StructField>();
            for (StructField field : fields) {
                carbonFields.add(new org.apache.carbondata.core.metadata.datatype.StructField(field.name(), this.convertSparkToCarbonDataType(field.dataType())));
            }
            return DataTypes.createStructType(carbonFields);
        }
        throw new UnsupportedOperationException("getting " + dataType + " from presto");
    }
}

