/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.presto.readers;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.DictionaryBlock;
import com.facebook.presto.spi.block.SliceArrayBlock;
import com.facebook.presto.spi.type.Type;
import io.airlift.slice.Slices;
import java.io.IOException;
import org.apache.carbondata.presto.readers.AbstractStreamReader;

public class SliceStreamReader
extends AbstractStreamReader {
    private boolean isDictionary;
    private SliceArrayBlock dictionarySliceArrayBlock;

    public SliceStreamReader() {
    }

    public SliceStreamReader(boolean isDictionary, SliceArrayBlock dictionarySliceArrayBlock) {
        this.isDictionary = isDictionary;
        this.dictionarySliceArrayBlock = dictionarySliceArrayBlock;
    }

    @Override
    public Block readBlock(Type type) throws IOException {
        BlockBuilder builder;
        block7: {
            block6: {
                if (!this.isVectorReader) break block6;
                int numberOfRows = this.batchSize;
                builder = type.createBlockBuilder(new BlockBuilderStatus(), numberOfRows);
                if (this.columnVector == null) break block7;
                if (this.isDictionary) {
                    int[] values = new int[numberOfRows];
                    for (int i = 0; i < numberOfRows; ++i) {
                        if (this.columnVector.isNullAt(i)) continue;
                        values[i] = (Integer)this.columnVector.getData(i);
                    }
                    return new DictionaryBlock(this.batchSize, (Block)this.dictionarySliceArrayBlock, values);
                }
                for (int i = 0; i < numberOfRows; ++i) {
                    if (this.columnVector.isNullAt(i)) {
                        builder.appendNull();
                        continue;
                    }
                    type.writeSlice(builder, Slices.wrappedBuffer((byte[])((byte[])this.columnVector.getData(i))));
                }
                break block7;
            }
            int numberOfRows = this.streamData.length;
            builder = type.createBlockBuilder(new BlockBuilderStatus(), numberOfRows);
            if (this.streamData != null) {
                for (int i = 0; i < numberOfRows; ++i) {
                    type.writeSlice(builder, Slices.utf8Slice((String)this.streamData[i].toString()));
                }
            }
        }
        return builder.build();
    }
}

