/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.presto;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.carbondata.core.metadata.datatype.StructField;
import org.apache.carbondata.core.scan.result.vector.impl.CarbonColumnVectorImpl;

public class CarbonVectorBatch {
    private static final int DEFAULT_BATCH_SIZE = 1024;
    private final StructField[] schema;
    private final int capacity;
    private int numRows;
    private final CarbonColumnVectorImpl[] columns;
    private final boolean[] filteredRows;
    private final Set<Integer> nullFilteredColumns;
    private int numRowsFiltered = 0;

    private CarbonVectorBatch(StructField[] schema, int maxRows) {
        this.schema = schema;
        this.capacity = maxRows;
        this.columns = new CarbonColumnVectorImpl[schema.length];
        this.nullFilteredColumns = new HashSet<Integer>();
        this.filteredRows = new boolean[maxRows];
        for (int i = 0; i < schema.length; ++i) {
            StructField field = schema[i];
            this.columns[i] = new CarbonColumnVectorImpl(maxRows, field.getDataType());
        }
    }

    public static CarbonVectorBatch allocate(StructField[] schema) {
        return new CarbonVectorBatch(schema, 1024);
    }

    public static CarbonVectorBatch allocate(StructField[] schema, int maxRows) {
        return new CarbonVectorBatch(schema, maxRows);
    }

    public void reset() {
        for (int i = 0; i < this.numCols(); ++i) {
            this.columns[i].reset();
        }
        if (this.numRowsFiltered > 0) {
            Arrays.fill(this.filteredRows, false);
        }
        this.numRows = 0;
        this.numRowsFiltered = 0;
    }

    public int numCols() {
        return this.columns.length;
    }

    public void setNumRows(int numRows) {
        assert (numRows <= this.capacity);
        this.numRows = numRows;
        for (int ordinal : this.nullFilteredColumns) {
            for (int rowId = 0; rowId < numRows; ++rowId) {
                if (this.filteredRows[rowId] || !this.columns[ordinal].isNull(rowId)) continue;
                this.filteredRows[rowId] = true;
                ++this.numRowsFiltered;
            }
        }
    }

    public int numRows() {
        return this.numRows;
    }

    public int numValidRows() {
        assert (this.numRowsFiltered <= this.numRows);
        return this.numRows - this.numRowsFiltered;
    }

    public CarbonColumnVectorImpl column(int ordinal) {
        return this.columns[ordinal];
    }

    public int capacity() {
        return this.capacity;
    }
}

