/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.presto.readers;

import com.facebook.presto.spi.block.SliceArrayBlock;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.SmallintType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.Type;
import io.airlift.slice.Slice;
import org.apache.carbondata.core.cache.dictionary.Dictionary;
import org.apache.carbondata.presto.readers.BooleanStreamReader;
import org.apache.carbondata.presto.readers.DecimalSliceStreamReader;
import org.apache.carbondata.presto.readers.DoubleStreamReader;
import org.apache.carbondata.presto.readers.IntegerStreamReader;
import org.apache.carbondata.presto.readers.LongStreamReader;
import org.apache.carbondata.presto.readers.ObjectStreamReader;
import org.apache.carbondata.presto.readers.ShortStreamReader;
import org.apache.carbondata.presto.readers.SliceStreamReader;
import org.apache.carbondata.presto.readers.StreamReader;
import org.apache.carbondata.presto.readers.TimestampStreamReader;

public final class StreamReaders {
    public static StreamReader createStreamReader(Type type, SliceArrayBlock dictionarySliceArrayBlock, Dictionary dictionary) {
        Class javaType = type.getJavaType();
        if (dictionary != null) {
            if (javaType == Long.TYPE) {
                if (type instanceof IntegerType || type instanceof DateType) {
                    return new IntegerStreamReader(true, dictionary);
                }
                if (type instanceof DecimalType) {
                    return new DecimalSliceStreamReader(true, dictionary);
                }
                if (type instanceof SmallintType) {
                    return new ShortStreamReader(true, dictionary);
                }
                return new LongStreamReader(true, dictionary);
            }
            if (javaType == Double.TYPE) {
                return new DoubleStreamReader(true, dictionary);
            }
            if (javaType == Slice.class) {
                if (type instanceof DecimalType) {
                    return new DecimalSliceStreamReader(true, dictionary);
                }
                return new SliceStreamReader(true, dictionarySliceArrayBlock);
            }
            if (javaType == Boolean.TYPE) {
                return new BooleanStreamReader(true, dictionary);
            }
            return new ObjectStreamReader();
        }
        if (javaType == Long.TYPE) {
            if (type instanceof IntegerType || type instanceof DateType) {
                return new IntegerStreamReader();
            }
            if (type instanceof DecimalType) {
                return new DecimalSliceStreamReader();
            }
            if (type instanceof SmallintType) {
                return new ShortStreamReader();
            }
            if (type instanceof TimestampType) {
                return new TimestampStreamReader();
            }
            return new LongStreamReader();
        }
        if (javaType == Double.TYPE) {
            return new DoubleStreamReader();
        }
        if (javaType == Slice.class) {
            if (type instanceof DecimalType) {
                return new DecimalSliceStreamReader();
            }
            return new SliceStreamReader();
        }
        if (javaType == Boolean.TYPE) {
            return new BooleanStreamReader();
        }
        return new ObjectStreamReader();
    }
}

