/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.presto.readers;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.Type;
import java.io.IOException;
import org.apache.carbondata.core.cache.dictionary.Dictionary;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.util.DataTypeUtil;
import org.apache.carbondata.presto.readers.AbstractStreamReader;

public class LongStreamReader
extends AbstractStreamReader {
    private boolean isDictionary;
    private Dictionary dictionary;

    public LongStreamReader() {
    }

    public LongStreamReader(boolean isDictionary, Dictionary dictionary) {
        this.isDictionary = isDictionary;
        this.dictionary = dictionary;
    }

    @Override
    public Block readBlock(Type type) throws IOException {
        BlockBuilder builder;
        if (this.isVectorReader) {
            int numberOfRows = this.batchSize;
            builder = type.createBlockBuilder(new BlockBuilderStatus(), numberOfRows);
            if (this.columnVector != null) {
                if (this.columnVector.anyNullsSet()) {
                    this.handleNullInVector(type, numberOfRows, builder);
                } else {
                    this.populateVector(type, numberOfRows, builder);
                }
            }
        } else {
            int numberOfRows = this.streamData.length;
            builder = type.createBlockBuilder(new BlockBuilderStatus(), numberOfRows);
            if (this.streamData != null) {
                for (int i = 0; i < numberOfRows; ++i) {
                    type.writeLong(builder, ((Long)this.streamData[i]).longValue());
                }
            }
        }
        return builder.build();
    }

    private void handleNullInVector(Type type, int numberOfRows, BlockBuilder builder) {
        for (int i = 0; i < numberOfRows; ++i) {
            if (this.columnVector.isNullAt(i)) {
                builder.appendNull();
                continue;
            }
            type.writeLong(builder, ((Long)this.columnVector.getData(i)).longValue());
        }
    }

    private void populateVector(Type type, int numberOfRows, BlockBuilder builder) {
        for (int i = 0; i < numberOfRows; ++i) {
            if (this.isDictionary) {
                int value = (Integer)this.columnVector.getData(i);
                Object data = DataTypeUtil.getDataBasedOnDataType((String)this.dictionary.getDictionaryValueForKey(value), (DataType)DataTypes.LONG);
                if (data != null) {
                    type.writeLong(builder, ((Long)data).longValue());
                    continue;
                }
                builder.appendNull();
                continue;
            }
            type.writeLong(builder, ((Long)this.columnVector.getData(i)).longValue());
        }
    }
}

