/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.presto.readers;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.Type;
import java.io.IOException;
import org.apache.carbondata.core.cache.dictionary.Dictionary;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.util.DataTypeUtil;
import org.apache.carbondata.presto.readers.AbstractStreamReader;

public class IntegerStreamReader
extends AbstractStreamReader {
    private Dictionary dictionaryValues;
    private boolean isDictionary;

    public IntegerStreamReader() {
    }

    public IntegerStreamReader(boolean isDictionary, Dictionary dictionary) {
        this.dictionaryValues = dictionary;
        this.isDictionary = isDictionary;
    }

    @Override
    public Block readBlock(Type type) throws IOException {
        BlockBuilder builder;
        if (this.isVectorReader) {
            int numberOfRows = this.batchSize;
            builder = type.createBlockBuilder(new BlockBuilderStatus(), numberOfRows);
            if (this.columnVector != null) {
                if (this.columnVector.anyNullsSet()) {
                    this.handleNullInVector(type, numberOfRows, builder);
                } else {
                    this.populateVector(type, numberOfRows, builder);
                }
            }
        } else {
            int numberOfRows = this.streamData.length;
            builder = type.createBlockBuilder(new BlockBuilderStatus(), numberOfRows);
            if (this.streamData != null) {
                for (int i = 0; i < numberOfRows; ++i) {
                    type.writeLong(builder, ((Integer)this.streamData[i]).longValue());
                }
            }
        }
        return builder.build();
    }

    private void handleNullInVector(Type type, int numberOfRows, BlockBuilder builder) {
        for (int i = 0; i < numberOfRows; ++i) {
            if (this.columnVector.isNullAt(i)) {
                builder.appendNull();
                continue;
            }
            type.writeLong(builder, ((Integer)this.columnVector.getData(i)).longValue());
        }
    }

    private void populateVector(Type type, int numberOfRows, BlockBuilder builder) {
        if (this.isDictionary) {
            for (int i = 0; i < numberOfRows; ++i) {
                int value = (Integer)this.columnVector.getData(i);
                Object data = DataTypeUtil.getDataBasedOnDataType((String)this.dictionaryValues.getDictionaryValueForKey(value), (DataType)DataTypes.INT);
                if (data != null) {
                    type.writeLong(builder, ((Integer)data).longValue());
                    continue;
                }
                builder.appendNull();
            }
        } else {
            for (int i = 0; i < numberOfRows; ++i) {
                Integer value = (Integer)this.columnVector.getData(i);
                type.writeLong(builder, value.longValue());
            }
        }
    }
}

