/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.presto.readers;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.Decimals;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Objects;
import org.apache.carbondata.core.cache.dictionary.Dictionary;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.util.DataTypeUtil;
import org.apache.carbondata.presto.readers.AbstractStreamReader;

public class DecimalSliceStreamReader
extends AbstractStreamReader {
    private Dictionary dictionary;
    private boolean isDictionary;
    private final char[] buffer = new char[100];

    public DecimalSliceStreamReader() {
    }

    public DecimalSliceStreamReader(boolean isDictionary, Dictionary dictionary) {
        this.dictionary = dictionary;
        this.isDictionary = isDictionary;
    }

    @Override
    public Block readBlock(Type type) throws IOException {
        int numberOfRows = 0;
        BlockBuilder builder = null;
        if (this.isVectorReader) {
            numberOfRows = this.batchSize;
            builder = type.createBlockBuilder(new BlockBuilderStatus(), numberOfRows);
            if (this.columnVector != null) {
                if (this.columnVector.anyNullsSet()) {
                    this.handleNullInVector(type, numberOfRows, builder);
                } else if (Decimals.isShortDecimal((Type)type)) {
                    this.populateShortDecimalVector(type, numberOfRows, builder);
                } else {
                    this.populateLongDecimalVector(type, numberOfRows, builder);
                }
            }
        } else if (this.streamData != null) {
            numberOfRows = this.streamData.length;
            builder = type.createBlockBuilder(new BlockBuilderStatus(), numberOfRows);
            for (int i = 0; i < numberOfRows; ++i) {
                Slice slice = this.getSlice(this.streamData[i], type);
                if (Decimals.isShortDecimal((Type)type)) {
                    type.writeLong(builder, this.parseLong((DecimalType)type, slice, 0, slice.length()));
                    continue;
                }
                type.writeSlice(builder, this.parseSlice((DecimalType)type, slice, 0, slice.length()));
            }
        }
        if (builder == null) {
            return null;
        }
        return builder.build();
    }

    private Slice getSlice(Object value, Type type) {
        if (type instanceof DecimalType) {
            DecimalType actual = (DecimalType)type;
            BigDecimal bigDecimalValue = (BigDecimal)value;
            if (Decimals.isShortDecimal((Type)type)) {
                return Slices.utf8Slice((String)value.toString());
            }
            if (bigDecimalValue.scale() > actual.getScale()) {
                BigInteger unscaledDecimal = Decimals.rescale((BigInteger)bigDecimalValue.unscaledValue(), (int)bigDecimalValue.scale(), (int)bigDecimalValue.scale());
                Slice decimalSlice = Decimals.encodeUnscaledValue((BigInteger)unscaledDecimal);
                return Slices.utf8Slice((String)Decimals.toString((Slice)decimalSlice, (int)actual.getScale()));
            }
            BigInteger unscaledDecimal = Decimals.rescale((BigInteger)bigDecimalValue.unscaledValue(), (int)bigDecimalValue.scale(), (int)actual.getScale());
            Slice decimalSlice = Decimals.encodeUnscaledValue((BigInteger)unscaledDecimal);
            return Slices.utf8Slice((String)Decimals.toString((Slice)decimalSlice, (int)actual.getScale()));
        }
        return Slices.utf8Slice((String)value.toString());
    }

    private long parseLong(DecimalType type, Slice slice, int offset, int length) {
        BigDecimal decimal = this.parseBigDecimal(type, slice, offset, length);
        return decimal.unscaledValue().longValue();
    }

    private Slice parseSlice(DecimalType type, Slice slice, int offset, int length) {
        BigDecimal decimal = this.parseBigDecimal(type, slice, offset, length);
        return Decimals.encodeUnscaledValue((BigInteger)decimal.unscaledValue());
    }

    private BigDecimal parseBigDecimal(DecimalType type, Slice slice, int offset, int length) {
        Preconditions.checkArgument((length < this.buffer.length ? 1 : 0) != 0);
        for (int i = 0; i < length; ++i) {
            this.buffer[i] = (char)slice.getByte(offset + i);
        }
        BigDecimal decimal = new BigDecimal(this.buffer, 0, length);
        Preconditions.checkState((decimal.scale() <= type.getScale() ? 1 : 0) != 0, (Object)"Read decimal value scale larger than column scale");
        decimal = decimal.setScale(type.getScale(), RoundingMode.HALF_UP);
        Preconditions.checkState((decimal.precision() <= type.getPrecision() ? 1 : 0) != 0, (Object)"Read decimal precision larger than column precision");
        return decimal;
    }

    private void handleNullInVector(Type type, int numberOfRows, BlockBuilder builder) {
        for (int i = 0; i < numberOfRows; ++i) {
            if (this.columnVector.isNullAt(i)) {
                builder.appendNull();
                continue;
            }
            if (Decimals.isShortDecimal((Type)type)) {
                BigDecimal decimalValue = (BigDecimal)this.columnVector.getData(i);
                long rescaledDecimal = Decimals.rescale((long)decimalValue.unscaledValue().longValue(), (int)decimalValue.scale(), (int)((DecimalType)type).getScale());
                type.writeLong(builder, rescaledDecimal);
                continue;
            }
            Slice slice = this.getSlice(this.columnVector.getData(i), type);
            type.writeSlice(builder, this.parseSlice((DecimalType)type, slice, 0, slice.length()));
        }
    }

    private void populateShortDecimalVector(Type type, int numberOfRows, BlockBuilder builder) {
        DecimalType decimalType = (DecimalType)type;
        if (this.isDictionary) {
            for (int i = 0; i < numberOfRows; ++i) {
                int value = (Integer)this.columnVector.getData(i);
                Object data = DataTypeUtil.getDataBasedOnDataType((String)this.dictionary.getDictionaryValueForKey(value), (DataType)DataTypes.createDecimalType((int)decimalType.getPrecision(), (int)decimalType.getScale()));
                if (Objects.isNull(data)) {
                    builder.appendNull();
                    continue;
                }
                BigDecimal decimalValue = (BigDecimal)data;
                long rescaledDecimal = Decimals.rescale((long)decimalValue.unscaledValue().longValue(), (int)decimalValue.scale(), (int)decimalType.getScale());
                type.writeLong(builder, rescaledDecimal);
            }
        } else {
            for (int i = 0; i < numberOfRows; ++i) {
                BigDecimal decimalValue = (BigDecimal)this.columnVector.getData(i);
                long rescaledDecimal = Decimals.rescale((long)decimalValue.unscaledValue().longValue(), (int)decimalValue.scale(), (int)decimalType.getScale());
                type.writeLong(builder, rescaledDecimal);
            }
        }
    }

    private void populateLongDecimalVector(Type type, int numberOfRows, BlockBuilder builder) {
        if (this.isDictionary) {
            for (int i = 0; i < numberOfRows; ++i) {
                int value = (Integer)this.columnVector.getData(i);
                DecimalType decimalType = (DecimalType)type;
                Object data = DataTypeUtil.getDataBasedOnDataType((String)this.dictionary.getDictionaryValueForKey(value), (DataType)DataTypes.createDecimalType((int)decimalType.getPrecision(), (int)decimalType.getScale()));
                if (Objects.isNull(data)) {
                    builder.appendNull();
                    continue;
                }
                BigDecimal decimalValue = (BigDecimal)data;
                Slice slice = this.getSlice(decimalValue, type);
                type.writeSlice(builder, this.parseSlice((DecimalType)type, slice, 0, slice.length()));
            }
        } else {
            for (int i = 0; i < numberOfRows; ++i) {
                Slice slice = this.getSlice(this.columnVector.getData(i), type);
                type.writeSlice(builder, this.parseSlice((DecimalType)type, slice, 0, slice.length()));
            }
        }
    }
}

