/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.presto.impl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.Gson;
import java.io.IOException;
import java.util.List;
import org.apache.carbondata.core.indexstore.BlockletDetailInfo;
import org.apache.carbondata.core.metadata.ColumnarFormatVersion;
import org.apache.carbondata.hadoop.CarbonInputSplit;
import org.apache.hadoop.fs.Path;

public class CarbonLocalInputSplit {
    private static final long serialVersionUID = 3520344046772190207L;
    private String segmentId;
    private String path;
    private long start;
    private long length;
    private List<String> locations;
    private short version;
    private String[] deleteDeltaFiles;
    private String detailInfo;
    private int numberOfBlocklets = 0;

    @JsonProperty
    public short getVersion() {
        return this.version;
    }

    @JsonProperty
    public List<String> getLocations() {
        return this.locations;
    }

    @JsonProperty
    public long getLength() {
        return this.length;
    }

    @JsonProperty
    public long getStart() {
        return this.start;
    }

    @JsonProperty
    public String getPath() {
        return this.path;
    }

    @JsonProperty
    public String getSegmentId() {
        return this.segmentId;
    }

    @JsonProperty
    public int getNumberOfBlocklets() {
        return this.numberOfBlocklets;
    }

    @JsonProperty
    public String[] getDeleteDeltaFiles() {
        return this.deleteDeltaFiles;
    }

    @JsonProperty
    public String getDetailInfo() {
        return this.detailInfo;
    }

    public void setDetailInfo(BlockletDetailInfo blockletDetailInfo) {
        Gson gson = new Gson();
        this.detailInfo = gson.toJson((Object)blockletDetailInfo);
    }

    @JsonCreator
    public CarbonLocalInputSplit(@JsonProperty(value="segmentId") String segmentId, @JsonProperty(value="path") String path, @JsonProperty(value="start") long start, @JsonProperty(value="length") long length, @JsonProperty(value="locations") List<String> locations, @JsonProperty(value="numberOfBlocklets") int numberOfBlocklets, @JsonProperty(value="version") short version, @JsonProperty(value="deleteDeltaFiles") String[] deleteDeltaFiles, @JsonProperty(value="detailInfo") String detailInfo) {
        this.path = path;
        this.start = start;
        this.length = length;
        this.segmentId = segmentId;
        this.locations = locations;
        this.numberOfBlocklets = numberOfBlocklets;
        this.version = version;
        this.deleteDeltaFiles = deleteDeltaFiles;
        this.detailInfo = detailInfo;
    }

    public static CarbonInputSplit convertSplit(CarbonLocalInputSplit carbonLocalInputSplit) {
        CarbonInputSplit inputSplit = new CarbonInputSplit(carbonLocalInputSplit.getSegmentId(), "0", new Path(carbonLocalInputSplit.getPath()), carbonLocalInputSplit.getStart(), carbonLocalInputSplit.getLength(), carbonLocalInputSplit.getLocations().toArray(new String[carbonLocalInputSplit.getLocations().size()]), carbonLocalInputSplit.getNumberOfBlocklets(), ColumnarFormatVersion.valueOf((short)carbonLocalInputSplit.getVersion()), carbonLocalInputSplit.getDeleteDeltaFiles());
        Gson gson = new Gson();
        BlockletDetailInfo blockletDetailInfo = (BlockletDetailInfo)gson.fromJson(carbonLocalInputSplit.detailInfo, BlockletDetailInfo.class);
        try {
            blockletDetailInfo.readColumnSchema(blockletDetailInfo.getColumnSchemaBinary());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        inputSplit.setDetailInfo(blockletDetailInfo);
        return inputSplit;
    }
}

