/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.presto;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.predicate.Domain;
import com.facebook.presto.spi.predicate.Range;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.Decimals;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.SmallintType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.scan.expression.ColumnExpression;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.scan.expression.LiteralExpression;
import org.apache.carbondata.core.scan.expression.conditional.EqualToExpression;
import org.apache.carbondata.core.scan.expression.conditional.GreaterThanEqualToExpression;
import org.apache.carbondata.core.scan.expression.conditional.GreaterThanExpression;
import org.apache.carbondata.core.scan.expression.conditional.InExpression;
import org.apache.carbondata.core.scan.expression.conditional.LessThanEqualToExpression;
import org.apache.carbondata.core.scan.expression.conditional.LessThanExpression;
import org.apache.carbondata.core.scan.expression.conditional.ListExpression;
import org.apache.carbondata.core.scan.expression.logical.AndExpression;
import org.apache.carbondata.core.scan.expression.logical.OrExpression;
import org.apache.carbondata.presto.CarbondataColumnHandle;

public class PrestoFilterUtil {
    private static Map<Integer, Expression> filterMap = new HashMap<Integer, Expression>();

    private static DataType Spi2CarbondataTypeMapper(CarbondataColumnHandle carbondataColumnHandle) {
        Type colType = carbondataColumnHandle.getColumnType();
        if (colType == BooleanType.BOOLEAN) {
            return DataTypes.BOOLEAN;
        }
        if (colType == SmallintType.SMALLINT) {
            return DataTypes.SHORT;
        }
        if (colType == IntegerType.INTEGER) {
            return DataTypes.INT;
        }
        if (colType == BigintType.BIGINT) {
            return DataTypes.LONG;
        }
        if (colType == DoubleType.DOUBLE) {
            return DataTypes.DOUBLE;
        }
        if (colType == VarcharType.VARCHAR) {
            return DataTypes.STRING;
        }
        if (colType == DateType.DATE) {
            return DataTypes.DATE;
        }
        if (colType == TimestampType.TIMESTAMP) {
            return DataTypes.TIMESTAMP;
        }
        if (colType.equals(DecimalType.createDecimalType((int)carbondataColumnHandle.getPrecision(), (int)carbondataColumnHandle.getScale()))) {
            return DataTypes.createDecimalType((int)carbondataColumnHandle.getPrecision(), (int)carbondataColumnHandle.getScale());
        }
        return DataTypes.STRING;
    }

    static Expression parseFilterExpression(TupleDomain<ColumnHandle> originalConstraint) {
        Expression finalFilters;
        ImmutableList.Builder filters = ImmutableList.builder();
        for (ColumnHandle c : ((Map)originalConstraint.getDomains().get()).keySet()) {
            CarbondataColumnHandle cdch = (CarbondataColumnHandle)c;
            Type type = cdch.getColumnType();
            DataType coltype = PrestoFilterUtil.Spi2CarbondataTypeMapper(cdch);
            ColumnExpression colExpression = new ColumnExpression(cdch.getColumnName(), coltype);
            Domain domain = (Domain)((Map)originalConstraint.getDomains().get()).get(c);
            Preconditions.checkArgument((boolean)domain.getType().isOrderable(), (Object)"Domain type must be orderable");
            ArrayList<Object> singleValues = new ArrayList<Object>();
            HashMap<Object, List> valueExpressionMap = new HashMap<Object, List>();
            block11: for (Range range : domain.getValues().getRanges().getOrderedRanges()) {
                Object value;
                if (range.isSingleValue()) {
                    value = PrestoFilterUtil.ConvertDataByType(range.getLow().getValue(), type);
                    singleValues.add(value);
                    continue;
                }
                if (!range.getLow().isLowerUnbounded()) {
                    value = PrestoFilterUtil.ConvertDataByType(range.getLow().getValue(), type);
                    switch (range.getLow().getBound()) {
                        case ABOVE: {
                            if (type == TimestampType.TIMESTAMP) break;
                            GreaterThanEqualToExpression greater = new GreaterThanExpression((Expression)colExpression, (Expression)new LiteralExpression(value, coltype));
                            valueExpressionMap.computeIfAbsent(value, key -> new ArrayList()).add(greater);
                            break;
                        }
                        case EXACTLY: {
                            GreaterThanEqualToExpression greater = new GreaterThanEqualToExpression((Expression)colExpression, (Expression)new LiteralExpression(value, coltype));
                            valueExpressionMap.computeIfAbsent(value, key -> new ArrayList()).add(greater);
                            break;
                        }
                        case BELOW: {
                            throw new IllegalArgumentException("Low marker should never use BELOW bound");
                        }
                        default: {
                            throw new AssertionError((Object)("Unhandled bound: " + range.getLow().getBound()));
                        }
                    }
                }
                if (range.getHigh().isUpperUnbounded()) continue;
                value = PrestoFilterUtil.ConvertDataByType(range.getHigh().getValue(), type);
                switch (range.getHigh().getBound()) {
                    case ABOVE: {
                        throw new IllegalArgumentException("High marker should never use ABOVE bound");
                    }
                    case EXACTLY: {
                        LessThanEqualToExpression less = new LessThanEqualToExpression((Expression)colExpression, (Expression)new LiteralExpression(value, coltype));
                        valueExpressionMap.computeIfAbsent(value, key -> new ArrayList()).add(less);
                        continue block11;
                    }
                    case BELOW: {
                        LessThanExpression less2 = new LessThanExpression((Expression)colExpression, (Expression)new LiteralExpression(value, coltype));
                        valueExpressionMap.computeIfAbsent(value, key -> new ArrayList()).add(less2);
                        continue block11;
                    }
                }
                throw new AssertionError((Object)("Unhandled bound: " + range.getHigh().getBound()));
            }
            if (singleValues.size() == 1) {
                EqualToExpression ex;
                if (coltype.equals(DataTypes.STRING)) {
                    ex = new EqualToExpression((Expression)colExpression, (Expression)new LiteralExpression(singleValues.get(0), coltype));
                } else if (coltype.equals(DataTypes.TIMESTAMP) || coltype.equals(DataTypes.DATE)) {
                    Long value = (Long)singleValues.get(0);
                    ex = new EqualToExpression((Expression)colExpression, (Expression)new LiteralExpression((Object)value, coltype));
                } else {
                    ex = new EqualToExpression((Expression)colExpression, (Expression)new LiteralExpression(singleValues.get(0), coltype));
                }
                filters.add((Object)ex);
                continue;
            }
            if (singleValues.size() > 1) {
                ListExpression candidates = null;
                List exs = singleValues.stream().map(a -> new LiteralExpression(a, coltype)).collect(Collectors.toList());
                candidates = new ListExpression(exs);
                filters.add((Object)new InExpression((Expression)colExpression, (Expression)candidates));
                continue;
            }
            if (valueExpressionMap.size() <= 0) continue;
            ArrayList<Expression> valuefilters = new ArrayList<Expression>();
            Expression finalFilters2 = null;
            for (Map.Entry entry : valueExpressionMap.entrySet()) {
                List expressions = (List)valueExpressionMap.get(entry.getKey());
                if (expressions.size() == 1) {
                    finalFilters2 = (Expression)expressions.get(0);
                } else if (expressions.size() >= 2) {
                    finalFilters2 = new OrExpression((Expression)expressions.get(0), (Expression)expressions.get(1));
                    for (int i = 2; i < expressions.size(); ++i) {
                        finalFilters2 = new OrExpression(finalFilters2, (Expression)expressions.get(i));
                    }
                }
                valuefilters.add(finalFilters2);
            }
            if (valuefilters.size() == 1) {
                finalFilters2 = (Expression)valuefilters.get(0);
            } else if (valuefilters.size() >= 2) {
                finalFilters2 = new AndExpression((Expression)valuefilters.get(0), (Expression)valuefilters.get(1));
                for (int i = 2; i < valuefilters.size(); ++i) {
                    finalFilters2 = new AndExpression(finalFilters2, (Expression)valuefilters.get(i));
                }
            }
            filters.add((Object)finalFilters2);
        }
        ImmutableList tmp = filters.build();
        if (tmp.size() > 1) {
            finalFilters = new AndExpression((Expression)tmp.get(0), (Expression)tmp.get(1));
            if (tmp.size() > 2) {
                for (int i = 2; i < tmp.size(); ++i) {
                    finalFilters = new AndExpression(finalFilters, (Expression)tmp.get(i));
                }
            }
        } else if (tmp.size() == 1) {
            finalFilters = (Expression)tmp.get(0);
        } else {
            return null;
        }
        return finalFilters;
    }

    private static Object ConvertDataByType(Object rawdata, Type type) {
        if (type.equals(IntegerType.INTEGER) || type.equals(SmallintType.SMALLINT)) {
            return Integer.valueOf(rawdata.toString());
        }
        if (type.equals(BigintType.BIGINT)) {
            return rawdata;
        }
        if (type.equals(VarcharType.VARCHAR)) {
            if (rawdata instanceof Slice) {
                return ((Slice)rawdata).toStringUtf8();
            }
            return rawdata;
        }
        if (type.equals(BooleanType.BOOLEAN)) {
            return rawdata;
        }
        if (type.equals(DateType.DATE)) {
            Calendar c = Calendar.getInstance();
            c.setTime(new Date(0L));
            c.add(6, ((Long)rawdata).intValue());
            Date date = c.getTime();
            return date.getTime() * 1000L;
        }
        if (type instanceof DecimalType) {
            if (rawdata instanceof Double) {
                return new BigDecimal((Double)rawdata);
            }
            if (rawdata instanceof Long) {
                return new BigDecimal(new BigInteger(String.valueOf(rawdata)), ((DecimalType)type).getScale());
            }
            if (rawdata instanceof Slice) {
                return new BigDecimal(Decimals.decodeUnscaledValue((Slice)((Slice)rawdata)), ((DecimalType)type).getScale());
            }
        } else if (type.equals(TimestampType.TIMESTAMP)) {
            return (Long)rawdata * 1000L;
        }
        return rawdata;
    }

    static Expression getFilters(Integer key) {
        return filterMap.get(key);
    }

    static void setFilter(Integer tableId, Expression filter) {
        filterMap.put(tableId, filter);
    }
}

