/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.presto;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.type.DecimalType;
import java.math.BigDecimal;
import org.apache.carbondata.presto.CarbondataErrorCode;

public class CarbondataUtil {
    public static long shortDecimalPartitionKey(String value, DecimalType type, String name) {
        return CarbondataUtil.decimalPartitionKey(value, type, name).unscaledValue().longValue();
    }

    private static BigDecimal decimalPartitionKey(String value, DecimalType type, String name) {
        try {
            BigDecimal decimal = new BigDecimal(value);
            decimal = decimal.setScale(type.getScale(), 7);
            if (decimal.precision() > type.getPrecision()) {
                throw new PrestoException((ErrorCodeSupplier)CarbondataErrorCode.CARBON_INVALID_TYPE_VALUE, String.format("Invalid type value '%s' for %s type key: %s", value, type.toString(), name));
            }
            return decimal;
        }
        catch (NumberFormatException e) {
            throw new PrestoException((ErrorCodeSupplier)CarbondataErrorCode.CARBON_INVALID_TYPE_VALUE, String.format("Invalid type value '%s' for %s type key: %s", value, type.toString(), name));
        }
    }
}

