/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.presto;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableLayoutResult;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.SchemaNotFoundException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.SmallintType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonMeasure;
import org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema;
import org.apache.carbondata.presto.CarbondataColumnHandle;
import org.apache.carbondata.presto.CarbondataConnectorId;
import org.apache.carbondata.presto.CarbondataTableHandle;
import org.apache.carbondata.presto.CarbondataTableLayoutHandle;
import org.apache.carbondata.presto.Types;
import org.apache.carbondata.presto.impl.CarbonTableReader;

public class CarbondataMetadata
implements ConnectorMetadata {
    private final String connectorId;
    private CarbonTableReader carbonTableReader;
    private Map<String, ColumnHandle> columnHandleMap;

    @Inject
    public CarbondataMetadata(CarbondataConnectorId connectorId, CarbonTableReader reader) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null").toString();
        this.carbonTableReader = Objects.requireNonNull(reader, "client is null");
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return this.listSchemaNamesInternal();
    }

    public List<String> listSchemaNamesInternal() {
        return this.carbonTableReader.getSchemaNames();
    }

    public List<SchemaTableName> listTables(ConnectorSession session, String schemaNameOrNull) {
        Object schemaNames = schemaNameOrNull != null ? ImmutableList.of((Object)schemaNameOrNull) : this.carbonTableReader.getSchemaNames();
        ImmutableList.Builder builder = ImmutableList.builder();
        Iterator iterator = schemaNames.iterator();
        while (iterator.hasNext()) {
            String schemaName = (String)iterator.next();
            for (String tableName : this.carbonTableReader.getTableNames(schemaName)) {
                builder.add((Object)new SchemaTableName(schemaName, tableName));
            }
        }
        return builder.build();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Objects.requireNonNull(prefix, "SchemaTablePrefix is null");
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (SchemaTableName tableName : this.listTables(session, prefix)) {
            ConnectorTableMetadata tableMetadata = this.getTableMetadata(tableName);
            if (tableMetadata == null) continue;
            columns.put((Object)tableName, (Object)tableMetadata.getColumns());
        }
        return columns.build();
    }

    private List<SchemaTableName> listTables(ConnectorSession session, SchemaTablePrefix prefix) {
        if (prefix.getSchemaName() == null) {
            return this.listTables(session, prefix.getSchemaName());
        }
        return ImmutableList.of((Object)new SchemaTableName(prefix.getSchemaName(), prefix.getTableName()));
    }

    private ConnectorTableMetadata getTableMetadata(SchemaTableName schemaTableName) {
        if (!this.listSchemaNamesInternal().contains(schemaTableName.getSchemaName())) {
            throw new SchemaNotFoundException(schemaTableName.getSchemaName());
        }
        CarbonTable carbonTable = this.carbonTableReader.getTable(schemaTableName);
        LinkedList<ColumnMetadata> columnsMetaList = new LinkedList<ColumnMetadata>();
        List carbonColumns = carbonTable.getCreateOrderColumn(schemaTableName.getTableName());
        for (CarbonColumn col : carbonColumns) {
            Type columnType = CarbondataMetadata.carbonDataType2SpiMapper(col.getColumnSchema());
            ColumnMetadata columnMeta = new ColumnMetadata(col.getColumnSchema().getColumnName(), columnType);
            columnsMetaList.add(columnMeta);
        }
        return new ConnectorTableMetadata(schemaTableName, columnsMetaList);
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        Type spiType;
        ColumnSchema cs;
        CarbondataTableHandle handle = Types.checkType(tableHandle, CarbondataTableHandle.class, "tableHandle");
        Preconditions.checkArgument((boolean)handle.getConnectorId().equals(this.connectorId), (Object)"tableHandle is not for this connector");
        String schemaName = handle.getSchemaTableName().getSchemaName();
        if (!this.listSchemaNamesInternal().contains(schemaName)) {
            throw new SchemaNotFoundException(schemaName);
        }
        CarbonTable cb = this.carbonTableReader.getTable(handle.getSchemaTableName());
        ImmutableMap.Builder columnHandles = ImmutableMap.builder();
        String tableName = handle.getSchemaTableName().getTableName();
        for (CarbonDimension column : cb.getDimensionByTableName(tableName)) {
            cs = column.getColumnSchema();
            spiType = CarbondataMetadata.carbonDataType2SpiMapper(cs);
            columnHandles.put((Object)cs.getColumnName(), (Object)new CarbondataColumnHandle(this.connectorId, cs.getColumnName(), spiType, column.getSchemaOrdinal(), column.getKeyOrdinal(), column.getColumnGroupOrdinal(), false, cs.getColumnGroupId(), cs.getColumnUniqueId(), cs.isUseInvertedIndex(), cs.getPrecision(), cs.getScale()));
        }
        for (CarbonMeasure measure : cb.getMeasureByTableName(tableName)) {
            cs = measure.getColumnSchema();
            spiType = CarbondataMetadata.carbonDataType2SpiMapper(cs);
            columnHandles.put((Object)cs.getColumnName(), (Object)new CarbondataColumnHandle(this.connectorId, cs.getColumnName(), spiType, cs.getSchemaOrdinal(), measure.getOrdinal(), cs.getColumnGroupId(), true, cs.getColumnGroupId(), cs.getColumnUniqueId(), cs.isUseInvertedIndex(), cs.getPrecision(), cs.getScale()));
        }
        this.columnHandleMap = columnHandles.build();
        return this.columnHandleMap;
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        Types.checkType(tableHandle, CarbondataTableHandle.class, "tableHandle");
        return Types.checkType(columnHandle, CarbondataColumnHandle.class, "columnHandle").getColumnMetadata();
    }

    public ConnectorTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        return new CarbondataTableHandle(this.connectorId, tableName);
    }

    public List<ConnectorTableLayoutResult> getTableLayouts(ConnectorSession session, ConnectorTableHandle table, Constraint<ColumnHandle> constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        CarbondataTableHandle handle = Types.checkType(table, CarbondataTableHandle.class, "table");
        ConnectorTableLayout layout = new ConnectorTableLayout((ConnectorTableLayoutHandle)new CarbondataTableLayoutHandle(handle, (TupleDomain<ColumnHandle>)constraint.getSummary()));
        return ImmutableList.of((Object)new ConnectorTableLayoutResult(layout, constraint.getSummary()));
    }

    public ConnectorTableLayout getTableLayout(ConnectorSession session, ConnectorTableLayoutHandle handle) {
        return new ConnectorTableLayout(handle);
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle table) {
        return this.getTableMetadataInternal(table);
    }

    public ConnectorTableMetadata getTableMetadataInternal(ConnectorTableHandle table) {
        CarbondataTableHandle carbondataTableHandle = Types.checkType(table, CarbondataTableHandle.class, "table");
        Preconditions.checkArgument((boolean)carbondataTableHandle.getConnectorId().equals(this.connectorId), (Object)"tableHandle is not for this connector");
        return this.getTableMetadata(carbondataTableHandle.getSchemaTableName());
    }

    public static Type carbonDataType2SpiMapper(ColumnSchema columnSchema) {
        DataType colType = columnSchema.getDataType();
        if (colType == DataTypes.BOOLEAN) {
            return BooleanType.BOOLEAN;
        }
        if (colType == DataTypes.SHORT) {
            return SmallintType.SMALLINT;
        }
        if (colType == DataTypes.INT) {
            return IntegerType.INTEGER;
        }
        if (colType == DataTypes.LONG) {
            return BigintType.BIGINT;
        }
        if (colType == DataTypes.FLOAT || colType == DataTypes.DOUBLE) {
            return DoubleType.DOUBLE;
        }
        if (DataTypes.isDecimal((DataType)colType)) {
            if (columnSchema.getPrecision() > 0) {
                return DecimalType.createDecimalType((int)columnSchema.getPrecision(), (int)columnSchema.getScale());
            }
            return DecimalType.createDecimalType();
        }
        if (colType == DataTypes.STRING) {
            return VarcharType.VARCHAR;
        }
        if (colType == DataTypes.DATE) {
            return DateType.DATE;
        }
        if (colType == DataTypes.TIMESTAMP) {
            return TimestampType.TIMESTAMP;
        }
        return VarcharType.VARCHAR;
    }
}

