/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.presto.readers;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.DictionaryBlock;
import com.facebook.presto.spi.block.SliceArrayBlock;
import com.facebook.presto.spi.type.Type;
import io.airlift.slice.Slices;
import java.io.IOException;
import org.apache.carbondata.presto.readers.AbstractStreamReader;

public class SliceStreamReader
extends AbstractStreamReader {
    private boolean isDictionary;
    private SliceArrayBlock dictionaryBlock;

    public SliceStreamReader() {
    }

    public SliceStreamReader(boolean isDictionary, SliceArrayBlock dictionaryBlock) {
        this.isDictionary = isDictionary;
        this.dictionaryBlock = dictionaryBlock;
    }

    @Override
    public Block readBlock(Type type) throws IOException {
        BlockBuilder builder;
        block7: {
            int numberOfRows;
            block6: {
                numberOfRows = 0;
                builder = null;
                if (!this.isVectorReader) break block6;
                numberOfRows = this.batchSize;
                builder = type.createBlockBuilder(new BlockBuilderStatus(), numberOfRows);
                if (this.columnVector == null) break block7;
                if (this.isDictionary) {
                    int[] values = new int[numberOfRows];
                    for (int i = 0; i < numberOfRows; ++i) {
                        if (this.columnVector.isNullAt(i)) continue;
                        values[i] = this.columnVector.getInt(i);
                    }
                    DictionaryBlock block = new DictionaryBlock(this.batchSize, (Block)this.dictionaryBlock, values);
                    return block;
                }
                for (int i = 0; i < numberOfRows; ++i) {
                    if (this.columnVector.isNullAt(i)) {
                        builder.appendNull();
                        continue;
                    }
                    type.writeSlice(builder, Slices.wrappedBuffer((byte[])this.columnVector.getArray(i).toByteArray()));
                }
                break block7;
            }
            numberOfRows = this.streamData.length;
            builder = type.createBlockBuilder(new BlockBuilderStatus(), numberOfRows);
            if (this.streamData != null) {
                for (int i = 0; i < numberOfRows; ++i) {
                    type.writeSlice(builder, Slices.utf8Slice((String)this.streamData[i].toString()));
                }
            }
        }
        return builder.build();
    }
}

