/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.presto.readers;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.Type;
import java.io.IOException;
import org.apache.carbondata.presto.readers.AbstractStreamReader;

public class LongStreamReader
extends AbstractStreamReader {
    @Override
    public Block readBlock(Type type) throws IOException {
        int numberOfRows = 0;
        BlockBuilder builder = null;
        if (this.isVectorReader) {
            numberOfRows = this.batchSize;
            builder = type.createBlockBuilder(new BlockBuilderStatus(), numberOfRows);
            if (this.columnVector != null) {
                if (this.columnVector.anyNullsSet()) {
                    this.handleNullInVector(type, numberOfRows, builder);
                } else {
                    this.populateVector(type, numberOfRows, builder);
                }
            }
        } else {
            numberOfRows = this.streamData.length;
            builder = type.createBlockBuilder(new BlockBuilderStatus(), numberOfRows);
            if (this.streamData != null) {
                for (int i = 0; i < numberOfRows; ++i) {
                    type.writeLong(builder, ((Long)this.streamData[i]).longValue());
                }
            }
        }
        return builder.build();
    }

    private void handleNullInVector(Type type, int numberOfRows, BlockBuilder builder) {
        for (int i = 0; i < numberOfRows; ++i) {
            if (this.columnVector.isNullAt(i)) {
                builder.appendNull();
                continue;
            }
            type.writeLong(builder, this.columnVector.getLong(i));
        }
    }

    private void populateVector(Type type, int numberOfRows, BlockBuilder builder) {
        for (int i = 0; i < numberOfRows; ++i) {
            type.writeLong(builder, this.columnVector.getLong(i));
        }
    }
}

