/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.presto.readers;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.Type;
import java.io.IOException;
import org.apache.carbondata.presto.readers.AbstractStreamReader;

public class DoubleStreamReader
extends AbstractStreamReader {
    @Override
    public Block readBlock(Type type) throws IOException {
        BlockBuilder builder;
        if (this.isVectorReader) {
            int numberOfRows = this.batchSize;
            builder = type.createBlockBuilder(new BlockBuilderStatus(), numberOfRows);
            if (this.columnVector != null) {
                if (this.columnVector.anyNullsSet()) {
                    this.handleNullInVector(type, numberOfRows, builder);
                } else {
                    this.populateVector(type, numberOfRows, builder);
                }
            }
        } else {
            int numberOfRows = this.streamData.length;
            builder = type.createBlockBuilder(new BlockBuilderStatus(), numberOfRows);
            if (this.streamData != null) {
                for (int i = 0; i < numberOfRows; ++i) {
                    type.writeDouble(builder, ((Double)this.streamData[i]).doubleValue());
                }
            }
        }
        return builder.build();
    }

    private void handleNullInVector(Type type, int numberOfRows, BlockBuilder builder) {
        for (int i = 0; i < numberOfRows; ++i) {
            if (this.columnVector.isNullAt(i)) {
                builder.appendNull();
                continue;
            }
            type.writeDouble(builder, this.columnVector.getDouble(i));
        }
    }

    private void populateVector(Type type, int numberOfRows, BlockBuilder builder) {
        for (int i = 0; i < numberOfRows; ++i) {
            type.writeDouble(builder, this.columnVector.getDouble(i));
        }
    }
}

