/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.presto.impl;

import com.facebook.presto.hadoop.;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.classloader.ThreadContextClassLoader;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.carbondata.core.datastore.filesystem.CarbonFile;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.CarbonMetadata;
import org.apache.carbondata.core.metadata.CarbonTableIdentifier;
import org.apache.carbondata.core.metadata.converter.ThriftWrapperSchemaConverterImpl;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.reader.ThriftReader;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.service.impl.PathFactory;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.carbondata.format.TableInfo;
import org.apache.carbondata.hadoop.CarbonInputSplit;
import org.apache.carbondata.hadoop.api.CarbonTableInputFormat;
import org.apache.carbondata.presto.impl.CarbonLocalInputSplit;
import org.apache.carbondata.presto.impl.CarbonTableCacheModel;
import org.apache.carbondata.presto.impl.CarbonTableConfig;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.thrift.TBase;

public class CarbonTableReader {
    private static final PathFilter DefaultFilter = new PathFilter(){

        public boolean accept(Path path) {
            return CarbonTablePath.isCarbonDataFile((String)path.getName());
        }
    };
    private CarbonTableConfig config;
    private List<SchemaTableName> tableList;
    private CarbonFile carbonFileList;
    private FileFactory.FileType fileType;
    private ConcurrentHashMap<SchemaTableName, CarbonTableCacheModel> cc;

    @Inject
    public CarbonTableReader(CarbonTableConfig config) {
        this.config = Objects.requireNonNull(config, "CarbonTableConfig is null");
        this.cc = new ConcurrentHashMap();
    }

    public CarbonTableCacheModel getCarbonCache(SchemaTableName table) {
        if (!this.cc.containsKey(table) || this.cc.get(table) == null) {
            block16: {
                try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(FileFactory.class.getClassLoader());){
                    if (this.carbonFileList != null) break block16;
                    this.fileType = FileFactory.getFileType((String)this.config.getStorePath());
                    try {
                        this.carbonFileList = FileFactory.getCarbonFile((String)this.config.getStorePath(), (FileFactory.FileType)this.fileType);
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                }
            }
            this.updateSchemaTables();
            this.parseCarbonMetadata(table);
        }
        if (this.cc.containsKey(table)) {
            return this.cc.get(table);
        }
        return null;
    }

    public List<String> getSchemaNames() {
        return this.updateSchemaList();
    }

    private boolean updateCarbonFile() {
        if (this.carbonFileList == null) {
            this.fileType = FileFactory.getFileType((String)this.config.getStorePath());
            try {
                this.carbonFileList = FileFactory.getCarbonFile((String)this.config.getStorePath(), (FileFactory.FileType)this.fileType);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return true;
    }

    private List<String> updateSchemaList() {
        this.updateCarbonFile();
        if (this.carbonFileList != null) {
            return Stream.of(this.carbonFileList.listFiles()).map(CarbonFile::getName).collect(Collectors.toList());
        }
        return ImmutableList.of();
    }

    public Set<String> getTableNames(String schema) {
        Objects.requireNonNull(schema, "schema is null");
        return this.updateTableList(schema);
    }

    private Set<String> updateTableList(String schemaName) {
        List schema = Stream.of(this.carbonFileList.listFiles()).filter(a -> schemaName.equals(a.getName())).collect(Collectors.toList());
        if (schema.size() > 0) {
            return Stream.of(((CarbonFile)schema.get(0)).listFiles()).map(CarbonFile::getName).collect(Collectors.toSet());
        }
        return ImmutableSet.of();
    }

    public CarbonTable getTable(SchemaTableName schemaTableName) {
        try {
            this.updateSchemaTables();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Objects.requireNonNull(schemaTableName, "schemaTableName is null");
        CarbonTable table = this.loadTableMetadata(schemaTableName);
        return table;
    }

    private void updateSchemaTables() {
        if (this.carbonFileList == null) {
            this.updateSchemaList();
        }
        this.tableList = new LinkedList<SchemaTableName>();
        for (CarbonFile cf : this.carbonFileList.listFiles()) {
            if (cf.getName().endsWith(".mdt")) continue;
            for (CarbonFile table : cf.listFiles()) {
                this.tableList.add(new SchemaTableName(cf.getName(), table.getName()));
            }
        }
    }

    private CarbonTable loadTableMetadata(SchemaTableName schemaTableName) {
        for (SchemaTableName table : this.tableList) {
            if (!table.equals((Object)schemaTableName)) continue;
            return this.parseCarbonMetadata(table);
        }
        throw new TableNotFoundException(schemaTableName);
    }

    private CarbonTable parseCarbonMetadata(SchemaTableName table) {
        CarbonTable result = null;
        try {
            CarbonTableCacheModel cache = this.cc.getOrDefault(table, new CarbonTableCacheModel());
            if (cache.isValid()) {
                return cache.carbonTable;
            }
            String storePath = this.config.getStorePath();
            cache.carbonTableIdentifier = new CarbonTableIdentifier(table.getSchemaName(), table.getTableName(), UUID.randomUUID().toString());
            cache.carbonTablePath = PathFactory.getInstance().getCarbonTablePath(storePath, cache.carbonTableIdentifier, null);
            this.cc.put(table, cache);
            ThriftReader.TBaseCreator createTBase = new ThriftReader.TBaseCreator(){

                public TBase create() {
                    return new TableInfo();
                }
            };
            ThriftReader thriftReader = new ThriftReader(cache.carbonTablePath.getSchemaFilePath(), createTBase);
            thriftReader.open();
            TableInfo tableInfo = (TableInfo)thriftReader.read();
            thriftReader.close();
            ThriftWrapperSchemaConverterImpl schemaConverter = new ThriftWrapperSchemaConverterImpl();
            org.apache.carbondata.core.metadata.schema.table.TableInfo wrapperTableInfo = schemaConverter.fromExternalToWrapperTableInfo(tableInfo, table.getSchemaName(), table.getTableName(), storePath);
            wrapperTableInfo.setMetaDataFilepath(CarbonTablePath.getFolderContainingFile((String)cache.carbonTablePath.getSchemaFilePath()));
            CarbonMetadata.getInstance().loadTableMetadata(wrapperTableInfo);
            cache.tableInfo = wrapperTableInfo;
            result = cache.carbonTable = CarbonMetadata.getInstance().getCarbonTable(cache.carbonTableIdentifier.getTableUniqueName());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return result;
    }

    public List<CarbonLocalInputSplit> getInputSplits2(CarbonTableCacheModel tableCacheModel, Expression filters) {
        ArrayList<CarbonLocalInputSplit> result = new ArrayList<CarbonLocalInputSplit>();
        CarbonTable carbonTable = tableCacheModel.carbonTable;
        org.apache.carbondata.core.metadata.schema.table.TableInfo tableInfo = tableCacheModel.tableInfo;
        Configuration config = new Configuration();
        config.set("mapreduce.input.carboninputformat.segmentnumbers", "");
        String carbonTablePath = PathFactory.getInstance().getCarbonTablePath(carbonTable.getAbsoluteTableIdentifier().getStorePath(), carbonTable.getCarbonTableIdentifier(), null).getPath();
        config.set("mapreduce.input.fileinputformat.inputdir", carbonTablePath);
        try {
            CarbonTableInputFormat.setTableInfo((Configuration)config, (org.apache.carbondata.core.metadata.schema.table.TableInfo)tableInfo);
            CarbonTableInputFormat<Object> carbonTableInputFormat = this.createInputFormat(config, carbonTable.getAbsoluteTableIdentifier(), filters);
            JobConf jobConf = new JobConf(config);
            Job job = Job.getInstance((Configuration)jobConf);
            List splits = carbonTableInputFormat.getSplits((JobContext)job);
            CarbonInputSplit carbonInputSplit = null;
            .Gson gson = new .Gson();
            if (splits != null && splits.size() > 0) {
                for (InputSplit inputSplit : splits) {
                    carbonInputSplit = (CarbonInputSplit)inputSplit;
                    result.add(new CarbonLocalInputSplit(carbonInputSplit.getSegmentId(), carbonInputSplit.getPath().toString(), carbonInputSplit.getStart(), carbonInputSplit.getLength(), Arrays.asList(carbonInputSplit.getLocations()), carbonInputSplit.getNumberOfBlocklets(), carbonInputSplit.getVersion().number(), carbonInputSplit.getDeleteDeltaFiles(), gson.toJson((Object)carbonInputSplit.getDetailInfo())));
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating Splits from CarbonTableInputFormat", e);
        }
        return result;
    }

    private CarbonTableInputFormat<Object> createInputFormat(Configuration conf, AbsoluteTableIdentifier identifier, Expression filterExpression) throws IOException {
        CarbonTableInputFormat format = new CarbonTableInputFormat();
        CarbonTableInputFormat.setTablePath((Configuration)conf, (String)identifier.appendWithLocalPrefix(identifier.getTablePath()));
        CarbonTableInputFormat.setFilterPredicates((Configuration)conf, (Expression)filterExpression);
        return format;
    }
}

