/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.presto;

import org.apache.carbondata.core.scan.result.vector.CarbonColumnVector;
import org.apache.spark.sql.execution.vectorized.ColumnVector;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;

public class ColumnarVectorWrapper
implements CarbonColumnVector {
    private ColumnVector columnVector;
    private boolean[] filteredRows;
    private int counter;
    private boolean filteredRowsExist;

    public ColumnarVectorWrapper(ColumnVector columnVector, boolean[] filteredRows) {
        this.columnVector = columnVector;
        this.filteredRows = filteredRows;
    }

    public void putBoolean(int rowId, boolean value) {
        if (!this.filteredRows[rowId]) {
            this.columnVector.putBoolean(this.counter++, value);
        }
    }

    public void putFloat(int rowId, float value) {
        if (!this.filteredRows[rowId]) {
            this.columnVector.putFloat(this.counter++, value);
        }
    }

    public void putShort(int rowId, short value) {
        if (!this.filteredRows[rowId]) {
            this.columnVector.putShort(this.counter++, value);
        }
    }

    public void putShorts(int rowId, int count, short value) {
        if (this.filteredRowsExist) {
            for (int i = 0; i < count; ++i) {
                if (!this.filteredRows[rowId]) {
                    this.columnVector.putShort(this.counter++, value);
                }
                ++rowId;
            }
        } else {
            this.columnVector.putShorts(rowId, count, value);
        }
    }

    public void putInt(int rowId, int value) {
        if (!this.filteredRows[rowId]) {
            this.columnVector.putInt(this.counter++, value);
        }
    }

    public void putInts(int rowId, int count, int value) {
        if (this.filteredRowsExist) {
            for (int i = 0; i < count; ++i) {
                if (!this.filteredRows[rowId]) {
                    this.columnVector.putInt(this.counter++, value);
                }
                ++rowId;
            }
        } else {
            this.columnVector.putInts(rowId, count, value);
        }
    }

    public void putLong(int rowId, long value) {
        if (!this.filteredRows[rowId]) {
            this.columnVector.putLong(this.counter++, value);
        }
    }

    public void putLongs(int rowId, int count, long value) {
        if (this.filteredRowsExist) {
            for (int i = 0; i < count; ++i) {
                if (!this.filteredRows[rowId]) {
                    this.columnVector.putLong(this.counter++, value);
                }
                ++rowId;
            }
        } else {
            this.columnVector.putLongs(rowId, count, value);
        }
    }

    public void putDecimal(int rowId, Decimal value, int precision) {
        if (!this.filteredRows[rowId]) {
            this.columnVector.putDecimal(this.counter++, value, precision);
        }
    }

    public void putDecimals(int rowId, int count, Decimal value, int precision) {
        for (int i = 0; i < count; ++i) {
            if (!this.filteredRows[rowId]) {
                this.columnVector.putDecimal(this.counter++, value, precision);
            }
            ++rowId;
        }
    }

    public void putDouble(int rowId, double value) {
        if (!this.filteredRows[rowId]) {
            this.columnVector.putDouble(this.counter++, value);
        }
    }

    public void putDoubles(int rowId, int count, double value) {
        if (this.filteredRowsExist) {
            for (int i = 0; i < count; ++i) {
                if (!this.filteredRows[rowId]) {
                    this.columnVector.putDouble(this.counter++, value);
                }
                ++rowId;
            }
        } else {
            this.columnVector.putDoubles(rowId, count, value);
        }
    }

    public void putBytes(int rowId, byte[] value) {
        if (!this.filteredRows[rowId]) {
            this.columnVector.putByteArray(this.counter++, value);
        }
    }

    public void putBytes(int rowId, int count, byte[] value) {
        for (int i = 0; i < count; ++i) {
            if (!this.filteredRows[rowId]) {
                this.columnVector.putByteArray(this.counter++, value);
            }
            ++rowId;
        }
    }

    public void putBytes(int rowId, int offset, int length, byte[] value) {
        if (!this.filteredRows[rowId]) {
            this.columnVector.putByteArray(this.counter++, value, offset, length);
        }
    }

    public void putNull(int rowId) {
        if (!this.filteredRows[rowId]) {
            this.columnVector.putNull(this.counter++);
        }
    }

    public void putNulls(int rowId, int count) {
        if (this.filteredRowsExist) {
            for (int i = 0; i < count; ++i) {
                if (!this.filteredRows[rowId]) {
                    this.columnVector.putNull(this.counter++);
                }
                ++rowId;
            }
        } else {
            this.columnVector.putNulls(rowId, count);
        }
    }

    public boolean isNull(int rowId) {
        return this.columnVector.isNullAt(rowId);
    }

    public void putObject(int rowId, Object obj) {
    }

    public Object getData(int rowId) {
        return null;
    }

    public void reset() {
        this.counter = 0;
        this.filteredRowsExist = false;
    }

    public DataType getType() {
        return this.columnVector.dataType();
    }

    public void setFilteredRowsExist(boolean filteredRowsExist) {
        this.filteredRowsExist = filteredRowsExist;
    }
}

