/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.presto;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.connector.ConnectorRecordSetProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.scan.model.QueryModel;
import org.apache.carbondata.core.service.impl.PathFactory;
import org.apache.carbondata.hadoop.CarbonInputSplit;
import org.apache.carbondata.hadoop.CarbonProjection;
import org.apache.carbondata.hadoop.api.CarbonTableInputFormat;
import org.apache.carbondata.presto.CarbondataColumnHandle;
import org.apache.carbondata.presto.CarbondataConnectorId;
import org.apache.carbondata.presto.CarbondataRecordSet;
import org.apache.carbondata.presto.CarbondataSplit;
import org.apache.carbondata.presto.PrestoFilterUtil;
import org.apache.carbondata.presto.Types;
import org.apache.carbondata.presto.impl.CarbonLocalInputSplit;
import org.apache.carbondata.presto.impl.CarbonTableCacheModel;
import org.apache.carbondata.presto.impl.CarbonTableReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TaskAttemptContextImpl;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskType;

public class CarbondataRecordSetProvider
implements ConnectorRecordSetProvider {
    private final String connectorId;
    private final CarbonTableReader carbonTableReader;

    @Inject
    public CarbondataRecordSetProvider(CarbondataConnectorId connectorId, CarbonTableReader reader) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null").toString();
        this.carbonTableReader = reader;
    }

    public RecordSet getRecordSet(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorSplit split, List<? extends ColumnHandle> columns) {
        QueryModel queryModel;
        TaskAttemptContextImpl hadoopAttemptContext;
        CarbondataSplit carbondataSplit = Types.checkType(split, CarbondataSplit.class, "split is not class CarbondataSplit");
        Preconditions.checkArgument((boolean)carbondataSplit.getConnectorId().equals(this.connectorId), (Object)"split is not for this connector");
        CarbonProjection carbonProjection = new CarbonProjection();
        ImmutableList.Builder handles = ImmutableList.builder();
        for (ColumnHandle columnHandle : columns) {
            handles.add((Object)Types.checkType(columnHandle, CarbondataColumnHandle.class, "handle"));
            carbonProjection.addColumn(((CarbondataColumnHandle)columnHandle).getColumnName());
        }
        CarbonTableCacheModel tableCacheModel = this.carbonTableReader.getCarbonCache(carbondataSplit.getSchemaTableName());
        Preconditions.checkNotNull((Object)tableCacheModel, (Object)"tableCacheModel should not be null");
        Preconditions.checkNotNull((Object)tableCacheModel.carbonTable, (Object)"tableCacheModel.carbonTable should not be null");
        Preconditions.checkNotNull((Object)tableCacheModel.tableInfo, (Object)"tableCacheModel.tableInfo should not be null");
        CarbonTable carbonTable = tableCacheModel.carbonTable;
        try {
            Configuration conf = new Configuration();
            conf.set("mapreduce.input.carboninputformat.segmentnumbers", "");
            String carbonTablePath = PathFactory.getInstance().getCarbonTablePath(carbonTable.getAbsoluteTableIdentifier().getStorePath(), carbonTable.getCarbonTableIdentifier(), null).getPath();
            conf.set("mapreduce.input.fileinputformat.inputdir", carbonTablePath);
            JobConf jobConf = new JobConf(conf);
            CarbonTableInputFormat<Object> carbonTableInputFormat = this.createInputFormat((Configuration)jobConf, tableCacheModel.carbonTable, PrestoFilterUtil.parseFilterExpression(carbondataSplit.getConstraints()), carbonProjection);
            hadoopAttemptContext = new TaskAttemptContextImpl(jobConf, new TaskAttemptID("", 1, TaskType.MAP, 0, 0));
            CarbonInputSplit carbonInputSplit = CarbonLocalInputSplit.convertSplit(carbondataSplit.getLocalInputSplit());
            queryModel = carbonTableInputFormat.getQueryModel((InputSplit)carbonInputSplit, (TaskAttemptContext)hadoopAttemptContext);
            queryModel.setVectorReader(true);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to get the Query Model ", e);
        }
        return new CarbondataRecordSet(carbonTable, session, carbondataSplit, (List<CarbondataColumnHandle>)handles.build(), queryModel, (org.apache.hadoop.mapred.TaskAttemptContext)hadoopAttemptContext);
    }

    private CarbonTableInputFormat<Object> createInputFormat(Configuration conf, CarbonTable carbonTable, Expression filterExpression, CarbonProjection projection) {
        AbsoluteTableIdentifier identifier = carbonTable.getAbsoluteTableIdentifier();
        CarbonTableInputFormat format = new CarbonTableInputFormat();
        try {
            CarbonTableInputFormat.setTablePath((Configuration)conf, (String)identifier.appendWithLocalPrefix(identifier.getTablePath()));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create the CarbonTableInputFormat", e);
        }
        CarbonTableInputFormat.setFilterPredicates((Configuration)conf, (Expression)filterExpression);
        CarbonTableInputFormat.setColumnProjection((Configuration)conf, (CarbonProjection)projection);
        return format;
    }
}

