/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.presto;

import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.type.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.carbondata.common.CarbonIterator;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.scan.executor.QueryExecutor;
import org.apache.carbondata.core.scan.executor.QueryExecutorFactory;
import org.apache.carbondata.core.scan.executor.exception.QueryExecutionException;
import org.apache.carbondata.core.scan.model.QueryModel;
import org.apache.carbondata.core.scan.result.iterator.AbstractDetailQueryResultIterator;
import org.apache.carbondata.hadoop.CarbonInputSplit;
import org.apache.carbondata.presto.CarbonDictionaryDecodeReadSupport;
import org.apache.carbondata.presto.CarbonVectorizedRecordReader;
import org.apache.carbondata.presto.CarbondataColumnHandle;
import org.apache.carbondata.presto.CarbondataRecordCursor;
import org.apache.carbondata.presto.CarbondataSplit;
import org.apache.carbondata.presto.Types;
import org.apache.carbondata.presto.impl.CarbonLocalInputSplit;
import org.apache.hadoop.mapred.TaskAttemptContext;

public class CarbondataRecordSet
implements RecordSet {
    private QueryModel queryModel;
    private CarbondataSplit split;
    private List<CarbondataColumnHandle> columns;
    private QueryExecutor queryExecutor;
    private CarbonDictionaryDecodeReadSupport readSupport;

    public CarbondataRecordSet(CarbonTable carbonTable, ConnectorSession session, ConnectorSplit split, List<CarbondataColumnHandle> columns, QueryModel queryModel, TaskAttemptContext taskAttemptContext) {
        this.split = Types.checkType(split, CarbondataSplit.class, "connectorSplit");
        this.queryModel = queryModel;
        this.columns = columns;
        this.readSupport = new CarbonDictionaryDecodeReadSupport();
    }

    public List<Type> getColumnTypes() {
        return this.columns.stream().map(a -> a.getColumnType()).collect(Collectors.toList());
    }

    public RecordCursor cursor() {
        CarbonLocalInputSplit carbonLocalInputSplit = this.split.getLocalInputSplit();
        ArrayList<CarbonInputSplit> splitList = new ArrayList<CarbonInputSplit>(1);
        splitList.add(CarbonLocalInputSplit.convertSplit(carbonLocalInputSplit));
        List tableBlockInfoList = CarbonInputSplit.createBlocks(splitList);
        this.queryModel.setTableBlockInfos(tableBlockInfoList);
        this.queryExecutor = QueryExecutorFactory.getQueryExecutor((QueryModel)this.queryModel);
        try {
            this.readSupport.initialize(this.queryModel.getProjectionColumns(), this.queryModel.getAbsoluteTableIdentifier());
            CarbonIterator iterator = this.queryExecutor.execute(this.queryModel);
            CarbonVectorizedRecordReader vectorReader = new CarbonVectorizedRecordReader(this.queryExecutor, this.queryModel, (AbstractDetailQueryResultIterator)iterator);
            CarbondataRecordCursor rc = new CarbondataRecordCursor(this.readSupport, vectorReader, this.columns, this.split);
            return rc;
        }
        catch (QueryExecutionException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }
}

