/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.presto;

import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.Decimals;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.base.Preconditions;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.List;
import org.apache.carbondata.core.cache.dictionary.Dictionary;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.presto.CarbonDictionaryDecodeReadSupport;
import org.apache.carbondata.presto.CarbonVectorizedRecordReader;
import org.apache.carbondata.presto.CarbondataColumnHandle;
import org.apache.carbondata.presto.CarbondataSplit;
import org.apache.carbondata.presto.CarbondataUtil;
import scala.Int;
import scala.Tuple3;

public class CarbondataRecordCursor
implements RecordCursor {
    private static final Logger log = Logger.get(CarbondataRecordCursor.class);
    private final List<CarbondataColumnHandle> columnHandles;
    private Object[] fields;
    private CarbondataSplit split;
    private CarbonDictionaryDecodeReadSupport readSupport;
    private Tuple3<DataType, Dictionary, Int>[] dictionary;
    CarbonVectorizedRecordReader vectorizedRecordReader;
    private long totalBytes;
    private long nanoStart;
    private long nanoEnd;

    public CarbondataRecordCursor(CarbonDictionaryDecodeReadSupport readSupport, CarbonVectorizedRecordReader vectorizedRecordReader, List<CarbondataColumnHandle> columnHandles, CarbondataSplit split) {
        this.vectorizedRecordReader = vectorizedRecordReader;
        this.columnHandles = columnHandles;
        this.readSupport = readSupport;
        this.totalBytes = 0L;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public long getCompletedBytes() {
        return this.totalBytes;
    }

    public long getReadTimeNanos() {
        return this.nanoStart > 0L ? (this.nanoEnd == 0L ? System.nanoTime() : this.nanoEnd) - this.nanoStart : 0L;
    }

    public Type getType(int field) {
        Preconditions.checkArgument((field < this.columnHandles.size() ? 1 : 0) != 0, (Object)"Invalid field index");
        return this.columnHandles.get(field).getColumnType();
    }

    public boolean advanceNextPosition() {
        if (this.nanoStart == 0L) {
            this.nanoStart = System.nanoTime();
        }
        return false;
    }

    public boolean getBoolean(int field) {
        this.checkFieldType(field, (Type)BooleanType.BOOLEAN);
        return (Boolean)this.getFieldValue(field);
    }

    public long getLong(int field) {
        Object obj = this.getFieldValue(field);
        Long timeStr = 0L;
        timeStr = obj instanceof Integer ? Long.valueOf(((Integer)obj).longValue()) : (obj instanceof Long ? (Long)obj : Long.valueOf(Math.round(Double.parseDouble(obj.toString()))));
        Type actual = this.getType(field);
        if (actual instanceof TimestampType) {
            return new Timestamp(timeStr).getTime() / 1000L;
        }
        if (Decimals.isShortDecimal((Type)actual)) {
            return CarbondataUtil.shortDecimalPartitionKey(obj.toString(), (DecimalType)actual, this.columnHandles.get(field).getColumnName());
        }
        return timeStr;
    }

    public double getDouble(int field) {
        this.checkFieldType(field, (Type)DoubleType.DOUBLE);
        return (Double)this.getFieldValue(field);
    }

    public Slice getSlice(int field) {
        Type decimalType = this.getType(field);
        if (decimalType instanceof DecimalType) {
            DecimalType actual = (DecimalType)decimalType;
            CarbondataColumnHandle carbondataColumnHandle = this.columnHandles.get(field);
            if (carbondataColumnHandle.getPrecision() > 0) {
                this.checkFieldType(field, (Type)DecimalType.createDecimalType((int)carbondataColumnHandle.getPrecision(), (int)carbondataColumnHandle.getScale()));
            } else {
                this.checkFieldType(field, (Type)DecimalType.createDecimalType());
            }
            Object fieldValue = this.getFieldValue(field);
            BigDecimal bigDecimalValue = new BigDecimal(fieldValue.toString());
            if (Decimals.isShortDecimal((Type)decimalType)) {
                return Slices.utf8Slice((String)Decimals.toString((long)bigDecimalValue.longValue(), (int)actual.getScale()));
            }
            if (bigDecimalValue.scale() > actual.getScale()) {
                BigInteger unscaledDecimal = Decimals.rescale((BigInteger)bigDecimalValue.unscaledValue(), (int)bigDecimalValue.scale(), (int)bigDecimalValue.scale());
                Slice decimalSlice = Decimals.encodeUnscaledValue((BigInteger)unscaledDecimal);
                return Slices.utf8Slice((String)Decimals.toString((Slice)decimalSlice, (int)actual.getScale()));
            }
            BigInteger unscaledDecimal = Decimals.rescale((BigInteger)bigDecimalValue.unscaledValue(), (int)bigDecimalValue.scale(), (int)actual.getScale());
            Slice decimalSlice = Decimals.encodeUnscaledValue((BigInteger)unscaledDecimal);
            return Slices.utf8Slice((String)Decimals.toString((Slice)decimalSlice, (int)actual.getScale()));
        }
        this.checkFieldType(field, (Type)VarcharType.VARCHAR);
        return Slices.utf8Slice((String)this.getFieldValue(field).toString());
    }

    public Object getObject(int field) {
        return null;
    }

    public boolean isNull(int field) {
        Preconditions.checkArgument((field < this.columnHandles.size() ? 1 : 0) != 0, (Object)"Invalid field index");
        return this.getFieldValue(field) == null;
    }

    Object getFieldValue(int field) {
        Preconditions.checkState((this.fields != null ? 1 : 0) != 0, (Object)"Cursor has not been advanced yet");
        return this.fields[field];
    }

    private void checkFieldType(int field, Type expected) {
        Type actual = this.getType(field);
        Preconditions.checkArgument((boolean)actual.equals(expected), (String)"Expected field %s to be type %s but is %s", (Object[])new Object[]{field, expected, actual});
    }

    public void close() {
        this.nanoEnd = System.nanoTime();
    }

    public CarbonVectorizedRecordReader getVectorizedRecordReader() {
        return this.vectorizedRecordReader;
    }

    public CarbonDictionaryDecodeReadSupport getReadSupport() {
        return this.readSupport;
    }
}

