/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.presto;

import com.facebook.presto.hadoop.;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.LazyBlock;
import com.facebook.presto.spi.block.LazyBlockLoader;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.carbondata.common.logging.LogService;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.presto.CarbonDictionaryDecodeReadSupport;
import org.apache.carbondata.presto.CarbonVectorizedRecordReader;
import org.apache.carbondata.presto.CarbondataRecordCursor;
import org.apache.carbondata.presto.readers.StreamReader;
import org.apache.carbondata.presto.readers.StreamReaders;
import org.apache.carbondata.processing.newflow.exception.CarbonDataLoadingException;
import org.apache.spark.sql.execution.vectorized.ColumnarBatch;

class CarbondataPageSource
implements ConnectorPageSource {
    private static final LogService logger = LogServiceFactory.getLogService((String)CarbondataPageSource.class.getName());
    private final RecordCursor cursor;
    private final List<Type> types;
    private final PageBuilder pageBuilder;
    private boolean closed;
    private CarbonVectorizedRecordReader vectorReader;
    private CarbonDictionaryDecodeReadSupport<Object[]> readSupport;
    private long sizeOfData = 0L;
    private final StreamReader[] readers;
    private int batchId;
    private long nanoStart;
    private long nanoEnd;

    CarbondataPageSource(RecordSet recordSet) {
        this(Objects.requireNonNull(recordSet, "recordSet is null").getColumnTypes(), recordSet.cursor());
    }

    private CarbondataPageSource(List<Type> types, RecordCursor cursor) {
        this.cursor = Objects.requireNonNull(cursor, "cursor is null");
        this.types = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(types, "types is null")));
        this.pageBuilder = new PageBuilder(this.types);
        this.readSupport = ((CarbondataRecordCursor)cursor).getReadSupport();
        this.vectorReader = ((CarbondataRecordCursor)cursor).getVectorizedRecordReader();
        this.readers = this.createStreamReaders();
    }

    public long getTotalBytes() {
        return this.sizeOfData;
    }

    public long getCompletedBytes() {
        return this.sizeOfData;
    }

    public long getReadTimeNanos() {
        return this.nanoStart > 0L ? (this.nanoEnd == 0L ? System.nanoTime() : this.nanoEnd) - this.nanoStart : 0L;
    }

    public boolean isFinished() {
        return this.closed && this.pageBuilder.isEmpty();
    }

    public Page getNextPage() {
        if (this.nanoStart == 0L) {
            this.nanoStart = System.nanoTime();
        }
        ColumnarBatch columnarBatch = null;
        int batchSize = 0;
        try {
            ++this.batchId;
            if (this.vectorReader.nextKeyValue()) {
                Object vectorBatch = this.vectorReader.getCurrentValue();
                if (vectorBatch != null && vectorBatch instanceof ColumnarBatch && (batchSize = (columnarBatch = (ColumnarBatch)vectorBatch).numRows()) == 0) {
                    this.close();
                    return null;
                }
            } else {
                this.close();
                return null;
            }
            if (columnarBatch == null) {
                return null;
            }
            Block[] blocks = new Block[this.types.size()];
            for (int column = 0; column < blocks.length; ++column) {
                Type type = this.types.get(column);
                this.readers[column].setBatchSize(columnarBatch.numRows());
                this.readers[column].setVectorReader(true);
                this.readers[column].setVector(columnarBatch.column(column));
                blocks[column] = new LazyBlock(batchSize, (LazyBlockLoader)new CarbondataBlockLoader(column, type));
            }
            Page page = new Page(batchSize, blocks);
            this.sizeOfData += (long)columnarBatch.capacity();
            return page;
        }
        catch (PrestoException e) {
            this.closeWithSuppression(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.closeWithSuppression(e);
            throw new CarbonDataLoadingException("Exception when creating the Carbon data Block", (Throwable)e);
        }
        catch (InterruptedException e) {
            this.closeWithSuppression(e);
            throw new CarbonDataLoadingException("Exception when creating the Carbon data Block", (Throwable)e);
        }
        catch (IOException e) {
            this.closeWithSuppression(e);
            throw new CarbonDataLoadingException("Exception when creating the Carbon data Block", (Throwable)e);
        }
    }

    public long getSystemMemoryUsage() {
        return this.sizeOfData;
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.vectorReader.close();
            this.cursor.close();
            this.nanoEnd = System.nanoTime();
        }
        catch (Exception e) {
            throw .Throwables.propagate((Throwable)e);
        }
    }

    protected void closeWithSuppression(Throwable throwable) {
        block2: {
            Objects.requireNonNull(throwable, "throwable is null");
            try {
                this.close();
            }
            catch (RuntimeException e) {
                logger.error((Throwable)e, e.getMessage());
                if (throwable == e) break block2;
                throwable.addSuppressed(e);
            }
        }
    }

    private StreamReader[] createStreamReaders() {
        Objects.requireNonNull(this.types);
        StreamReader[] readers = new StreamReader[this.types.size()];
        for (int i = 0; i < this.types.size(); ++i) {
            readers[i] = StreamReaders.createStreamReader(this.types.get(i), this.readSupport.getSliceArrayBlock(i));
        }
        return readers;
    }

    private final class CarbondataBlockLoader
    implements LazyBlockLoader<LazyBlock> {
        private final int expectedBatchId;
        private final int columnIndex;
        private final Type type;
        private boolean loaded;

        public CarbondataBlockLoader(int columnIndex, Type type) {
            this.expectedBatchId = CarbondataPageSource.this.batchId;
            this.columnIndex = columnIndex;
            this.type = Objects.requireNonNull(type, "type is null");
        }

        public final void load(LazyBlock lazyBlock) {
            if (this.loaded) {
                return;
            }
            Preconditions.checkState((CarbondataPageSource.this.batchId == this.expectedBatchId ? 1 : 0) != 0);
            try {
                Block block = CarbondataPageSource.this.readers[this.columnIndex].readBlock(this.type);
                lazyBlock.setBlock(block);
            }
            catch (IOException e) {
                throw new CarbonDataLoadingException("Error in Reading Data from Carbondata ", (Throwable)e);
            }
            this.loaded = true;
        }
    }
}

