/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.presto;

import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.ConnectorRecordSetProvider;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import io.airlift.configuration.ConfigBinder;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.carbondata.presto.CarbondataConnectorId;
import org.apache.carbondata.presto.CarbondataHandleResolver;
import org.apache.carbondata.presto.CarbondataMetadata;
import org.apache.carbondata.presto.CarbondataPageSourceProvider;
import org.apache.carbondata.presto.CarbondataRecordSetProvider;
import org.apache.carbondata.presto.CarbondataSplitManager;
import org.apache.carbondata.presto.impl.CarbonTableConfig;
import org.apache.carbondata.presto.impl.CarbonTableReader;

public class CarbondataModule
implements Module {
    private final String connectorId;
    private final TypeManager typeManager;

    public CarbondataModule(String connectorId, TypeManager typeManager) {
        this.connectorId = Objects.requireNonNull(connectorId, "connector id is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    public void configure(Binder binder) {
        binder.bind(TypeManager.class).toInstance((Object)this.typeManager);
        binder.bind(CarbondataConnectorId.class).toInstance((Object)new CarbondataConnectorId(this.connectorId));
        binder.bind(CarbondataMetadata.class).in(Scopes.SINGLETON);
        binder.bind(CarbonTableReader.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorSplitManager.class).to(CarbondataSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorRecordSetProvider.class).to(CarbondataRecordSetProvider.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorPageSourceProvider.class).to(CarbondataPageSourceProvider.class).in(Scopes.SINGLETON);
        binder.bind(CarbondataHandleResolver.class).in(Scopes.SINGLETON);
        binder.bind(CarbondataRecordSetProvider.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(CarbonTableConfig.class);
    }

    public static final class TypeDeserializer
    extends FromStringDeserializer<Type> {
        private final TypeManager typeManager;

        @Inject
        public TypeDeserializer(TypeManager typeManager) {
            super(Type.class);
            this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        }

        protected Type _deserialize(String value, DeserializationContext context) {
            Type type = this.typeManager.getType(TypeSignature.parseTypeSignature((String)value));
            Preconditions.checkArgument((type != null ? 1 : 0) != 0, (String)"Unknown type %s", (Object[])new Object[]{value});
            return type;
        }
    }
}

