/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.presto;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.type.Type;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class CarbondataColumnHandle
implements ColumnHandle {
    private final String connectorId;
    private final String columnName;
    private final Type columnType;
    private final int ordinalPosition;
    private final int keyOrdinal;
    private final int columnGroupOrdinal;
    private final int columnGroupId;
    private final String columnUniqueId;
    private final boolean isInvertedIndex;
    private int scale;
    private int precision;
    private final boolean isMeasure;

    public boolean isInvertedIndex() {
        return this.isInvertedIndex;
    }

    public boolean isMeasure() {
        return this.isMeasure;
    }

    public int getKeyOrdinal() {
        return this.keyOrdinal;
    }

    public int getColumnGroupOrdinal() {
        return this.columnGroupOrdinal;
    }

    public int getColumnGroupId() {
        return this.columnGroupId;
    }

    public String getColumnUniqueId() {
        return this.columnUniqueId;
    }

    @JsonCreator
    public CarbondataColumnHandle(@JsonProperty(value="connectorId") String connectorId, @JsonProperty(value="columnName") String columnName, @JsonProperty(value="columnType") Type columnType, @JsonProperty(value="ordinalPosition") int ordinalPosition, @JsonProperty(value="keyOrdinal") int keyOrdinal, @JsonProperty(value="columnGroupOrdinal") int columnGroupOrdinal, @JsonProperty(value="isMeasure") boolean isMeasure, @JsonProperty(value="columnGroupId") int columnGroupId, @JsonProperty(value="columnUniqueId") String columnUniqueId, @JsonProperty(value="isInvertedIndex") boolean isInvertedIndex, @JsonProperty(value="precision") int precision, @JsonProperty(value="scale") int scale) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
        this.columnName = Objects.requireNonNull(columnName, "columnName is null");
        this.columnType = Objects.requireNonNull(columnType, "columnType is null");
        this.ordinalPosition = Objects.requireNonNull(Integer.valueOf(ordinalPosition), "ordinalPosition is null");
        this.keyOrdinal = Objects.requireNonNull(Integer.valueOf(keyOrdinal), "keyOrdinal is null");
        this.columnGroupOrdinal = Objects.requireNonNull(Integer.valueOf(columnGroupOrdinal), "columnGroupOrdinal is null");
        this.isMeasure = isMeasure;
        this.columnGroupId = Objects.requireNonNull(Integer.valueOf(columnGroupId), "columnGroupId is null");
        this.columnUniqueId = columnUniqueId;
        this.isInvertedIndex = Objects.requireNonNull(Boolean.valueOf(isInvertedIndex), "isInvertedIndex is null");
        this.precision = precision;
        this.scale = scale;
    }

    @JsonProperty
    public String getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    public String getColumnName() {
        return this.columnName;
    }

    @JsonProperty
    public Type getColumnType() {
        return this.columnType;
    }

    @JsonProperty
    public int getOrdinalPosition() {
        return this.ordinalPosition;
    }

    public ColumnMetadata getColumnMetadata() {
        return new ColumnMetadata(this.columnName, this.columnType, null, false);
    }

    public int hashCode() {
        return Objects.hash(this.connectorId, this.columnName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CarbondataColumnHandle other = (CarbondataColumnHandle)obj;
        return Objects.equals(this.connectorId, other.connectorId) && Objects.equals(this.columnName, other.columnName);
    }

    public String toString() {
        return com.google.common.base.Objects.toStringHelper((Object)this).add("connectorId", (Object)this.connectorId).add("columnName", (Object)this.columnName).add("columnType", (Object)this.columnType).add("ordinalPosition", this.ordinalPosition).toString();
    }

    @JsonProperty
    public int getScale() {
        return this.scale;
    }

    @JsonProperty
    public int getPrecision() {
        return this.precision;
    }
}

