/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hive.test.server;

import java.io.File;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hive.service.Service;
import org.apache.hive.service.cli.CLIService;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.server.HiveServer2;
import org.apache.log4j.Logger;

public class HiveEmbeddedServer2 {
    private String SCRATCH_DIR = "";
    private static final Logger log = LogServiceFactory.getLogService((String)Hive.class.getName());
    private HiveServer2 hiveServer;
    private HiveConf config;
    private int port;

    public void start(String storePath) throws Exception {
        log.info((Object)"Starting Hive Local/Embedded Server...");
        this.SCRATCH_DIR = storePath;
        if (this.hiveServer == null) {
            this.config = this.configure();
            this.hiveServer = new HiveServer2();
            this.port = MetaStoreUtils.findFreePort();
            this.config.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_PORT, this.port);
            this.config.setBoolVar(HiveConf.ConfVars.HADOOPMAPREDINPUTDIRRECURSIVE, true);
            this.config.setBoolVar(HiveConf.ConfVars.HIVE_HADOOP_SUPPORTS_SUBDIRECTORIES, true);
            this.hiveServer.init(this.config);
            this.hiveServer.start();
            this.waitForStartup();
        }
    }

    public int getFreePort() {
        log.info((Object)("Free Port Available is " + this.port));
        return this.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void waitForStartup() throws Exception {
        long timeout = TimeUnit.MINUTES.toMillis(1L);
        long unitOfWait = TimeUnit.SECONDS.toMillis(1L);
        CLIService hs2Client = this.getServiceClientInternal();
        SessionHandle sessionHandle = null;
        int interval = 0;
        while ((long)interval < timeout / unitOfWait) {
            Thread.sleep(unitOfWait);
            try {
                HashMap sessionConf = new HashMap();
                sessionHandle = hs2Client.openSession("foo", "bar", sessionConf);
            }
            catch (Exception exception) {
                hs2Client.closeSession(sessionHandle);
                catch (Throwable throwable) {
                    hs2Client.closeSession(sessionHandle);
                    throw throwable;
                }
            }
            hs2Client.closeSession(sessionHandle);
            return;
            ++interval;
        }
        throw new TimeoutException("Couldn't get a hold of HiveServer2...");
    }

    private CLIService getServiceClientInternal() {
        for (Service service : this.hiveServer.getServices()) {
            if (!(service instanceof CLIService)) continue;
            return (CLIService)service;
        }
        throw new IllegalStateException("Cannot find CLIService");
    }

    private HiveConf configure() throws Exception {
        log.info((Object)"Setting The Hive Conf Variables");
        String scratchDir = this.SCRATCH_DIR;
        File scratchDirFile = new File(scratchDir);
        Configuration cfg = new Configuration();
        HiveConf conf = new HiveConf(cfg, HiveConf.class);
        conf.addToRestrictList("columns.comments");
        conf.set("hive.scratch.dir.permission", "777");
        conf.setVar(HiveConf.ConfVars.SCRATCHDIRPERMISSION, "777");
        if (!scratchDirFile.exists()) {
            if (!scratchDirFile.mkdirs()) {
                throw new IllegalArgumentException("could not create the directory:" + scratchDir);
            }
            if (!scratchDirFile.setWritable(true, false)) {
                throw new IllegalArgumentException("could not set write permissions for the directory:" + scratchDir);
            }
        }
        conf.set("hive.metastore.warehouse.dir", scratchDir + "/warehouse");
        conf.set("hive.metastore.metadb.dir", scratchDir + "/metastore_db");
        conf.set("hive.exec.scratchdir", scratchDir);
        conf.set("fs.permissions.umask-mode", "022");
        conf.set("javax.jdo.option.ConnectionURL", "jdbc:derby:;databaseName=" + scratchDir + "/metastore_db;create=true");
        conf.set("hive.metastore.local", "true");
        conf.set("hive.aux.jars.path", "");
        conf.set("hive.added.jars.path", "");
        conf.set("hive.added.files.path", "");
        conf.set("hive.added.archives.path", "");
        conf.set("fs.default.name", "file:///");
        conf.set(HiveConf.ConfVars.SUBMITLOCALTASKVIACHILD.varname, "false");
        Field field = Configuration.class.getDeclaredField("properties");
        field.setAccessible(true);
        Properties props = (Properties)field.get(conf);
        props.remove("mapred.job.tracker");
        props.remove("mapreduce.framework.name");
        props.setProperty("fs.default.name", "file:///");
        Field tss = SessionState.class.getDeclaredField("tss");
        tss.setAccessible(true);
        return new HiveConf(conf);
    }

    public void stop() {
        if (this.hiveServer != null) {
            log.info((Object)"Stopping Hive Local/Embedded Server...");
            this.hiveServer.stop();
            this.hiveServer = null;
            this.config = null;
            log.info((Object)"Hive Local/Embedded Server Stopped SucessFully...");
        }
    }
}

