/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hive;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.apache.carbondata.core.datastore.block.TableBlockInfo;
import org.apache.carbondata.core.scan.executor.exception.QueryExecutionException;
import org.apache.carbondata.core.scan.model.QueryModel;
import org.apache.carbondata.core.scan.result.iterator.ChunkRowIterator;
import org.apache.carbondata.hadoop.CarbonRecordReader;
import org.apache.carbondata.hadoop.readsupport.CarbonReadSupport;
import org.apache.carbondata.hive.CarbonHiveInputSplit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;

class CarbonHiveRecordReader
extends CarbonRecordReader<ArrayWritable>
implements RecordReader<Void, ArrayWritable> {
    private ArrayWritable valueObj = null;
    private long recordReaderCounter = 0L;
    private int[] columnIds;

    public CarbonHiveRecordReader(QueryModel queryModel, CarbonReadSupport<ArrayWritable> readSupport, InputSplit inputSplit, JobConf jobConf) throws IOException {
        super(queryModel, readSupport, (Configuration)jobConf);
        this.initialize(inputSplit, (Configuration)jobConf);
    }

    private void initialize(InputSplit inputSplit, Configuration conf) throws IOException {
        if (!(inputSplit instanceof CarbonHiveInputSplit)) {
            throw new RuntimeException("unsupported input split type: " + inputSplit);
        }
        ArrayList<CarbonHiveInputSplit> splitList = new ArrayList<CarbonHiveInputSplit>(1);
        splitList.add((CarbonHiveInputSplit)inputSplit);
        List<TableBlockInfo> tableBlockInfoList = CarbonHiveInputSplit.createBlocks(splitList);
        this.queryModel.setTableBlockInfos(tableBlockInfoList);
        this.readSupport.initialize(this.queryModel.getProjectionColumns(), this.queryModel.getTable());
        try {
            this.carbonIterator = new ChunkRowIterator(this.queryExecutor.execute(this.queryModel));
        }
        catch (QueryExecutionException e) {
            throw new IOException(e.getMessage(), e.getCause());
        }
        String colIds = conf.get("hive.io.file.readcolumn.ids");
        String columnTypeProperty = conf.get("columns.types");
        ArrayList columnTypes = columnTypeProperty.length() == 0 ? new ArrayList() : TypeInfoUtils.getTypeInfosFromTypeString((String)columnTypeProperty);
        if (this.valueObj == null) {
            this.valueObj = new ArrayWritable(Writable.class, new Writable[columnTypes.size()]);
        }
        if (null != colIds && !colIds.equals("")) {
            String[] arraySelectedColId = colIds.split(",");
            this.columnIds = new int[arraySelectedColId.length];
            int columnId = 0;
            for (int j = 0; j < arraySelectedColId.length; ++j) {
                this.columnIds[j] = columnId = Integer.parseInt(arraySelectedColId[j]);
            }
        }
    }

    public boolean next(Void aVoid, ArrayWritable value) throws IOException {
        if (this.carbonIterator.hasNext()) {
            Object obj = this.readSupport.readRow((Object[])this.carbonIterator.next());
            ++this.recordReaderCounter;
            Writable[] objArray = (Writable[])obj;
            Writable[] sysArray = new Writable[value.get().length];
            if (this.columnIds != null && this.columnIds.length > 0 && objArray.length == this.columnIds.length) {
                for (int i = 0; i < this.columnIds.length; ++i) {
                    sysArray[this.columnIds[i]] = objArray[i];
                }
                value.set(sysArray);
            } else {
                value.set(objArray);
            }
            return true;
        }
        return false;
    }

    public Void createKey() {
        return null;
    }

    public ArrayWritable createValue() {
        return this.valueObj;
    }

    public long getPos() throws IOException {
        return this.recordReaderCounter;
    }

    public float getProgress() throws IOException {
        return 0.0f;
    }

    private ArrayWritable createStruct(Object obj, StructObjectInspector inspector) throws SerDeException {
        List fields = inspector.getAllStructFieldRefs();
        Writable[] arr = new Writable[fields.size()];
        for (int i = 0; i < fields.size(); ++i) {
            StructField field = (StructField)fields.get(i);
            Object subObj = inspector.getStructFieldData(obj, field);
            ObjectInspector subInspector = field.getFieldObjectInspector();
            arr[i] = this.createObject(subObj, subInspector);
        }
        return new ArrayWritable(Writable.class, arr);
    }

    private ArrayWritable createArray(Object obj, ListObjectInspector inspector) throws SerDeException {
        List sourceArray = inspector.getList(obj);
        ObjectInspector subInspector = inspector.getListElementObjectInspector();
        ArrayList<Writable> array = new ArrayList<Writable>();
        if (sourceArray != null) {
            for (Object curObj : sourceArray) {
                Writable newObj = this.createObject(curObj, subInspector);
                if (newObj == null) continue;
                array.add(newObj);
            }
        }
        if (array.size() > 0) {
            ArrayWritable subArray = new ArrayWritable(((Writable)array.get(0)).getClass(), array.toArray(new Writable[array.size()]));
            return new ArrayWritable(Writable.class, new Writable[]{subArray});
        }
        return null;
    }

    private Writable createPrimitive(Object obj, PrimitiveObjectInspector inspector) throws SerDeException {
        if (obj == null) {
            return null;
        }
        switch (inspector.getPrimitiveCategory()) {
            case VOID: {
                return null;
            }
            case DOUBLE: {
                return new DoubleWritable(((Double)obj).doubleValue());
            }
            case INT: {
                return new IntWritable(((Integer)obj).intValue());
            }
            case LONG: {
                return new LongWritable(((Long)obj).longValue());
            }
            case SHORT: {
                return new ShortWritable(((Short)obj).shortValue());
            }
            case BOOLEAN: {
                return new BooleanWritable(((Boolean)obj).booleanValue());
            }
            case VARCHAR: {
                return new Text(obj.toString());
            }
            case BINARY: {
                return new BytesWritable((byte[])obj);
            }
            case DATE: {
                return new DateWritable(new Date(Long.parseLong(String.valueOf(obj.toString()))));
            }
            case TIMESTAMP: {
                return new TimestampWritable(new Timestamp((Long)obj));
            }
            case STRING: {
                return new Text(obj.toString());
            }
            case CHAR: {
                return new Text(obj.toString());
            }
            case DECIMAL: {
                return new HiveDecimalWritable(HiveDecimal.create((BigDecimal)((BigDecimal)obj)));
            }
        }
        throw new SerDeException("Unknown primitive : " + inspector.getPrimitiveCategory());
    }

    private Writable createObject(Object obj, ObjectInspector inspector) throws SerDeException {
        switch (inspector.getCategory()) {
            case STRUCT: {
                return this.createStruct(obj, (StructObjectInspector)inspector);
            }
            case LIST: {
                return this.createArray(obj, (ListObjectInspector)inspector);
            }
            case PRIMITIVE: {
                return this.createPrimitive(obj, (PrimitiveObjectInspector)inspector);
            }
        }
        throw new SerDeException("Unknown data type" + inspector.getCategory());
    }
}

