/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hive;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.carbondata.hive.CarbonObjectInspector;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeSpec;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;

@SerDeSpec(schemaProps={"columns", "columns.types"})
class CarbonHiveSerDe
extends AbstractSerDe {
    private final SerDeStats stats = new SerDeStats();
    private ObjectInspector objInspector;
    private LAST_OPERATION status;
    private long serializedSize;
    private long deserializedSize;

    public void initialize(@Nullable Configuration configuration, Properties tbl) throws SerDeException {
        assert (configuration != null);
        String columnNameProperty = tbl.getProperty("columns");
        String columnTypeProperty = tbl.getProperty("columns.types");
        List<Object> columnNames = columnNameProperty.length() == 0 ? new ArrayList() : Arrays.asList(columnNameProperty.split(","));
        ArrayList columnTypes = columnTypeProperty.length() == 0 ? new ArrayList() : TypeInfoUtils.getTypeInfosFromTypeString((String)columnTypeProperty);
        TypeInfo rowTypeInfo = TypeInfoFactory.getStructTypeInfo(columnNames, columnTypes);
        this.objInspector = new CarbonObjectInspector((StructTypeInfo)rowTypeInfo);
        this.serializedSize = 0L;
        this.deserializedSize = 0L;
        this.status = LAST_OPERATION.UNKNOWN;
    }

    public Class<? extends Writable> getSerializedClass() {
        return ArrayWritable.class;
    }

    public Writable serialize(Object obj, ObjectInspector objectInspector) throws SerDeException {
        if (!this.objInspector.getCategory().equals((Object)ObjectInspector.Category.STRUCT)) {
            throw new SerDeException("Cannot serializeStartKey " + this.objInspector.getCategory() + ". Can only serializeStartKey a struct");
        }
        this.serializedSize += (long)((StructObjectInspector)this.objInspector).getAllStructFieldRefs().size();
        this.status = LAST_OPERATION.SERIALIZE;
        return this.createStruct(obj, (StructObjectInspector)this.objInspector);
    }

    private ArrayWritable createStruct(Object obj, StructObjectInspector inspector) throws SerDeException {
        List fields = inspector.getAllStructFieldRefs();
        Writable[] arr = new Writable[fields.size()];
        for (int i = 0; i < fields.size(); ++i) {
            StructField field = (StructField)fields.get(i);
            Object subObj = inspector.getStructFieldData(obj, field);
            ObjectInspector subInspector = field.getFieldObjectInspector();
            arr[i] = this.createObject(subObj, subInspector);
        }
        return new ArrayWritable(Writable.class, arr);
    }

    private ArrayWritable createArray(Object obj, ListObjectInspector inspector) throws SerDeException {
        List sourceArray = inspector.getList(obj);
        ObjectInspector subInspector = inspector.getListElementObjectInspector();
        ArrayList<Writable> array = new ArrayList<Writable>();
        if (sourceArray != null) {
            for (Object curObj : sourceArray) {
                Writable newObj = this.createObject(curObj, subInspector);
                if (newObj == null) continue;
                array.add(newObj);
            }
        }
        if (array.size() > 0) {
            ArrayWritable subArray = new ArrayWritable(((Writable)array.get(0)).getClass(), array.toArray(new Writable[array.size()]));
            return new ArrayWritable(Writable.class, new Writable[]{subArray});
        }
        return null;
    }

    private Writable createPrimitive(Object obj, PrimitiveObjectInspector inspector) throws SerDeException {
        if (obj == null) {
            return null;
        }
        switch (inspector.getPrimitiveCategory()) {
            case VOID: {
                return null;
            }
            case DOUBLE: {
                return new DoubleWritable(((DoubleObjectInspector)inspector).get(obj));
            }
            case INT: {
                return new IntWritable(((IntObjectInspector)inspector).get(obj));
            }
            case LONG: {
                return new LongWritable(((LongObjectInspector)inspector).get(obj));
            }
            case SHORT: {
                return new ShortWritable(((ShortObjectInspector)inspector).get(obj));
            }
            case TIMESTAMP: {
                return ((TimestampObjectInspector)inspector).getPrimitiveWritableObject(obj);
            }
            case DATE: {
                return ((DateObjectInspector)inspector).getPrimitiveWritableObject(obj);
            }
            case STRING: {
                return ((StringObjectInspector)inspector).getPrimitiveWritableObject(obj);
            }
            case CHAR: {
                return ((StringObjectInspector)inspector).getPrimitiveWritableObject(obj);
            }
            case DECIMAL: {
                return ((HiveDecimalObjectInspector)inspector).getPrimitiveWritableObject(obj);
            }
        }
        throw new SerDeException("Unknown primitive : " + inspector.getPrimitiveCategory());
    }

    private Writable createObject(Object obj, ObjectInspector inspector) throws SerDeException {
        switch (inspector.getCategory()) {
            case STRUCT: {
                return this.createStruct(obj, (StructObjectInspector)inspector);
            }
            case LIST: {
                return this.createArray(obj, (ListObjectInspector)inspector);
            }
            case PRIMITIVE: {
                return this.createPrimitive(obj, (PrimitiveObjectInspector)inspector);
            }
        }
        throw new SerDeException("Unknown data type" + inspector.getCategory());
    }

    public SerDeStats getSerDeStats() {
        assert (this.status != LAST_OPERATION.UNKNOWN);
        if (this.status == LAST_OPERATION.SERIALIZE) {
            this.stats.setRawDataSize(this.serializedSize);
        } else {
            this.stats.setRawDataSize(this.deserializedSize);
        }
        return this.stats;
    }

    public Object deserialize(Writable writable) throws SerDeException {
        this.status = LAST_OPERATION.DESERIALIZE;
        if (writable instanceof ArrayWritable) {
            this.deserializedSize += (long)((StructObjectInspector)this.objInspector).getAllStructFieldRefs().size();
            return writable;
        }
        return null;
    }

    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.objInspector;
    }

    private static enum LAST_OPERATION {
        SERIALIZE,
        DESERIALIZE,
        UNKNOWN;

    }
}

