/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hive;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.exception.InvalidConfigurationException;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.schema.SchemaReader;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.TableInfo;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.scan.model.QueryModel;
import org.apache.carbondata.core.scan.model.QueryModelBuilder;
import org.apache.carbondata.core.util.DataTypeConverter;
import org.apache.carbondata.core.util.DataTypeConverterImpl;
import org.apache.carbondata.core.util.ObjectSerializationUtil;
import org.apache.carbondata.hadoop.CarbonInputSplit;
import org.apache.carbondata.hadoop.api.CarbonTableInputFormat;
import org.apache.carbondata.hive.CarbonDictionaryDecodeReadSupport;
import org.apache.carbondata.hive.CarbonHiveInputSplit;
import org.apache.carbondata.hive.CarbonHiveRecordReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.InvalidPathException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.CombineHiveInputFormat;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.util.StringUtils;
import org.apache.log4j.Logger;

public class MapredCarbonInputFormat
extends CarbonTableInputFormat<ArrayWritable>
implements InputFormat<Void, ArrayWritable>,
CombineHiveInputFormat.AvoidSplitCombination {
    private static final String CARBON_TABLE = "mapreduce.input.carboninputformat.table";
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)MapredCarbonInputFormat.class.getCanonicalName());

    private static void populateCarbonTable(Configuration configuration, String paths) throws IOException, InvalidConfigurationException {
        String dirs = configuration.get("mapreduce.input.fileinputformat.inputdir", "");
        String[] inputPaths = StringUtils.split((String)dirs);
        String validInputPath = null;
        if (inputPaths.length == 0) {
            throw new InvalidPathException("No input paths specified in job");
        }
        if (paths != null) {
            for (String inputPath : inputPaths) {
                if (!paths.startsWith(inputPath.replace("file:", ""))) continue;
                validInputPath = inputPath;
                break;
            }
        }
        if (null == validInputPath) {
            throw new InvalidPathException("No input paths specified in job");
        }
        AbsoluteTableIdentifier absoluteTableIdentifier = AbsoluteTableIdentifier.from(validInputPath, (String)MapredCarbonInputFormat.getDatabaseName((Configuration)configuration), (String)MapredCarbonInputFormat.getTableName((Configuration)configuration));
        CarbonTable carbonTable = SchemaReader.readCarbonTableFromStore((AbsoluteTableIdentifier)absoluteTableIdentifier);
        configuration.set(CARBON_TABLE, ObjectSerializationUtil.convertObjectToString((Object)carbonTable));
        MapredCarbonInputFormat.setTableInfo((Configuration)configuration, (TableInfo)carbonTable.getTableInfo());
    }

    private static CarbonTable getCarbonTable(Configuration configuration, String path) throws IOException, InvalidConfigurationException {
        MapredCarbonInputFormat.populateCarbonTable(configuration, path);
        String carbonTableStr = configuration.get(CARBON_TABLE);
        return (CarbonTable)ObjectSerializationUtil.convertStringToObject((String)carbonTableStr);
    }

    public InputSplit[] getSplits(JobConf jobConf, int numSplits) throws IOException {
        Job jobContext = Job.getInstance((Configuration)jobConf);
        List splitList = super.getSplits((JobContext)jobContext);
        InputSplit[] splits = new InputSplit[splitList.size()];
        for (int i = 0; i < splitList.size(); ++i) {
            CarbonInputSplit split = (CarbonInputSplit)splitList.get(i);
            splits[i] = new CarbonHiveInputSplit(split.getSegmentId(), split.getPath(), split.getStart(), split.getLength(), split.getLocations(), split.getNumberOfBlocklets(), split.getVersion(), split.getBlockStorageIdMap());
        }
        return splits;
    }

    public RecordReader<Void, ArrayWritable> getRecordReader(InputSplit inputSplit, JobConf jobConf, Reporter reporter) throws IOException {
        String path = null;
        if (inputSplit instanceof CarbonHiveInputSplit) {
            path = ((CarbonHiveInputSplit)inputSplit).getPath().toString();
        }
        QueryModel queryModel = null;
        try {
            queryModel = this.getQueryModel((Configuration)jobConf, path);
        }
        catch (InvalidConfigurationException e) {
            LOGGER.error((Object)("Failed to create record reader: " + e.getMessage()));
            return null;
        }
        CarbonDictionaryDecodeReadSupport<ArrayWritable> readSupport = new CarbonDictionaryDecodeReadSupport<ArrayWritable>();
        return new CarbonHiveRecordReader(queryModel, readSupport, inputSplit, jobConf);
    }

    private QueryModel getQueryModel(Configuration configuration, String path) throws IOException, InvalidConfigurationException {
        CarbonTable carbonTable = MapredCarbonInputFormat.getCarbonTable(configuration, path);
        AbsoluteTableIdentifier identifier = carbonTable.getAbsoluteTableIdentifier();
        String projectionString = this.getProjection(configuration, carbonTable, identifier.getCarbonTableIdentifier().getTableName());
        String[] projectionColumns = projectionString.split(",");
        QueryModel queryModel = new QueryModelBuilder(carbonTable).projectColumns(projectionColumns).filterExpression(this.getFilterPredicates(configuration)).dataConverter((DataTypeConverter)new DataTypeConverterImpl()).build();
        return queryModel;
    }

    private String getProjection(Configuration configuration, CarbonTable carbonTable, String tableName) {
        String projection = MapredCarbonInputFormat.getColumnProjection((Configuration)configuration);
        if (projection == null) {
            projection = configuration.get("hive.io.file.readcolumn.names");
        }
        List carbonColumns = carbonTable.getCreateOrderColumn(tableName);
        ArrayList<String> carbonColumnNames = new ArrayList<String>();
        StringBuilder allColumns = new StringBuilder();
        StringBuilder projectionColumns = new StringBuilder();
        for (CarbonColumn column : carbonColumns) {
            carbonColumnNames.add(column.getColName().toLowerCase());
            allColumns.append(column.getColName() + ",");
        }
        if (!projection.equals("")) {
            String[] columnNames;
            for (String col : columnNames = projection.split(",")) {
                if (!carbonColumnNames.contains(col.toLowerCase())) continue;
                projectionColumns.append(col + ",");
            }
            return projectionColumns.substring(0, projectionColumns.lastIndexOf(","));
        }
        return allColumns.substring(0, allColumns.lastIndexOf(","));
    }

    public boolean shouldSkipCombine(Path path, Configuration conf) throws IOException {
        return true;
    }
}

