/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hive;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.carbondata.hive.CarbonArrayInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.SettableStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.Writable;

class CarbonObjectInspector
extends SettableStructObjectInspector {
    private final TypeInfo typeInfo;
    private final List<StructField> fields;
    private final HashMap<String, StructFieldImpl> fieldsByName;

    public CarbonObjectInspector(StructTypeInfo rowTypeInfo) {
        this.typeInfo = rowTypeInfo;
        ArrayList fieldNames = rowTypeInfo.getAllStructFieldNames();
        ArrayList fieldInfos = rowTypeInfo.getAllStructFieldTypeInfos();
        this.fields = new ArrayList<StructField>(fieldNames.size());
        this.fieldsByName = new HashMap();
        for (int i = 0; i < fieldNames.size(); ++i) {
            String name = (String)fieldNames.get(i);
            TypeInfo fieldInfo = (TypeInfo)fieldInfos.get(i);
            StructFieldImpl field = new StructFieldImpl(name, this.getObjectInspector(fieldInfo), i);
            this.fields.add(field);
            this.fieldsByName.put(name, field);
        }
    }

    private ObjectInspector getObjectInspector(TypeInfo typeInfo) {
        if (typeInfo.equals((Object)TypeInfoFactory.doubleTypeInfo)) {
            return PrimitiveObjectInspectorFactory.writableDoubleObjectInspector;
        }
        if (typeInfo.equals((Object)TypeInfoFactory.intTypeInfo)) {
            return PrimitiveObjectInspectorFactory.writableIntObjectInspector;
        }
        if (typeInfo.equals((Object)TypeInfoFactory.longTypeInfo)) {
            return PrimitiveObjectInspectorFactory.writableLongObjectInspector;
        }
        if (typeInfo.equals((Object)TypeInfoFactory.stringTypeInfo)) {
            return PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        }
        if (typeInfo instanceof DecimalTypeInfo) {
            return PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)((DecimalTypeInfo)typeInfo));
        }
        if (typeInfo.getCategory().equals((Object)ObjectInspector.Category.STRUCT)) {
            return new CarbonObjectInspector((StructTypeInfo)typeInfo);
        }
        if (typeInfo.getCategory().equals((Object)ObjectInspector.Category.LIST)) {
            TypeInfo subTypeInfo = ((ListTypeInfo)typeInfo).getListElementTypeInfo();
            return new CarbonArrayInspector(this.getObjectInspector(subTypeInfo));
        }
        if (typeInfo.equals((Object)TypeInfoFactory.shortTypeInfo)) {
            return PrimitiveObjectInspectorFactory.writableShortObjectInspector;
        }
        if (typeInfo.equals((Object)TypeInfoFactory.timestampTypeInfo)) {
            return PrimitiveObjectInspectorFactory.writableTimestampObjectInspector;
        }
        if (typeInfo.equals((Object)TypeInfoFactory.dateTypeInfo)) {
            return PrimitiveObjectInspectorFactory.writableDateObjectInspector;
        }
        if (((CharTypeInfo)typeInfo).getPrimitiveCategory().name().equals("CHAR")) {
            return PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        }
        throw new UnsupportedOperationException("Unknown field type: " + typeInfo);
    }

    public ObjectInspector.Category getCategory() {
        return ObjectInspector.Category.STRUCT;
    }

    public String getTypeName() {
        return this.typeInfo.getTypeName();
    }

    public List<? extends StructField> getAllStructFieldRefs() {
        return this.fields;
    }

    public Object getStructFieldData(Object data, StructField fieldRef) {
        if (data == null) {
            return null;
        }
        if (data instanceof ArrayWritable) {
            ArrayWritable arr = (ArrayWritable)data;
            return arr.get()[((StructFieldImpl)fieldRef).getIndex()];
        }
        boolean isArray = !(data instanceof List);
        int listSize = isArray ? ((Object[])data).length : ((List)data).size();
        int fieldID = fieldRef.getFieldID();
        return fieldID >= listSize ? null : (isArray ? ((Object[])data)[fieldID] : (Object)((List)data).get(fieldID));
    }

    public StructField getStructFieldRef(String name) {
        return this.fieldsByName.get(name);
    }

    public List<Object> getStructFieldsDataAsList(Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof ArrayWritable) {
            ArrayWritable arr = (ArrayWritable)data;
            Writable[] arrWritable = arr.get();
            return new ArrayList<Writable>(Arrays.asList(arrWritable));
        }
        throw new UnsupportedOperationException("Cannot inspect " + data.getClass().getCanonicalName());
    }

    public Object create() {
        ArrayList<Object> list = new ArrayList<Object>(this.fields.size());
        for (int i = 0; i < this.fields.size(); ++i) {
            list.add(null);
        }
        return list;
    }

    public Object setStructFieldData(Object struct, StructField field, Object fieldValue) {
        ArrayList list = (ArrayList)struct;
        list.set(((StructFieldImpl)field).getIndex(), fieldValue);
        return list;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        CarbonObjectInspector other = (CarbonObjectInspector)((Object)obj);
        return this.typeInfo == other.typeInfo || this.typeInfo != null && this.typeInfo.equals((Object)other.typeInfo);
    }

    public int hashCode() {
        int hash = 5;
        hash = 29 * hash + (this.typeInfo != null ? this.typeInfo.hashCode() : 0);
        return hash;
    }

    private static class StructFieldImpl
    implements StructField {
        private final String name;
        private final ObjectInspector inspector;
        private final int index;

        public StructFieldImpl(String name, ObjectInspector inspector, int index) {
            this.name = name;
            this.inspector = inspector;
            this.index = index;
        }

        public String getFieldComment() {
            return "";
        }

        public String getFieldName() {
            return this.name;
        }

        public int getIndex() {
            return this.index;
        }

        public ObjectInspector getFieldObjectInspector() {
            return this.inspector;
        }

        public int getFieldID() {
            return this.index;
        }
    }
}

