/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hiveexample;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.carbondata.common.logging.LogService;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.hive.server.HiveEmbeddedServer2;
import org.apache.spark.sql.CarbonSession$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class HiveExample$ {
    public static final HiveExample$ MODULE$;
    private final String driverName;

    static {
        new HiveExample$();
    }

    private String driverName() {
        return this.driverName;
    }

    public void main(String[] args) {
        BoxedUnit boxedUnit;
        String rootPath = new File(new StringBuilder().append((Object)this.getClass().getResource("/").getPath()).append((Object)"../../../..").toString()).getCanonicalPath();
        String store = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/integration/hive/target/store"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rootPath}));
        String warehouse = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/integration/hive/target/warehouse"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rootPath}));
        String metaStore_Db = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/integration/hive/target/carbon_metaStore_db"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rootPath}));
        LogService logger = LogServiceFactory.getLogService((String)this.getClass().getCanonicalName());
        String resultId = "";
        String resultName = "";
        String resultSalary = "";
        SparkSession carbonSession = CarbonSession$.MODULE$.CarbonBuilder(SparkSession$.MODULE$.builder().master("local").appName("HiveExample").config("carbonSession.sql.warehouse.dir", warehouse).enableHiveSupport()).getOrCreateCarbonSession(store, metaStore_Db);
        carbonSession.sql(new StringOps(Predef$.MODULE$.augmentString("DROP TABLE IF EXISTS HIVE_CARBON_EXAMPLE")).stripMargin());
        carbonSession.sql(new StringOps(Predef$.MODULE$.augmentString("CREATE TABLE HIVE_CARBON_EXAMPLE (ID int,NAME string,SALARY double) STORED BY\n          |'CARBONDATA' ")).stripMargin());
        carbonSession.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           LOAD DATA LOCAL INPATH '", "/integration/hive/src/main/resources/data.csv' INTO\n           TABLE\n         HIVE_CARBON_EXAMPLE\n           "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rootPath})));
        carbonSession.sql("SELECT * FROM HIVE_CARBON_EXAMPLE").show();
        carbonSession.stop();
        try {
            boxedUnit = Class.forName(this.driverName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            boxedUnit = BoxedUnit.UNIT;
        }
        HiveEmbeddedServer2 hiveEmbeddedServer2 = new HiveEmbeddedServer2();
        hiveEmbeddedServer2.start();
        int port = hiveEmbeddedServer2.getFreePort();
        Connection connection = DriverManager.getConnection(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"jdbc:hive2://localhost:", "/default"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)port)})), "", "");
        Statement statement = connection.createStatement();
        logger.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"============HIVE CLI IS STARTED ON PORT ", " =============="})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)port)})));
        statement.execute("CREATE TABLE IF NOT EXISTS HIVE_CARBON_EXAMPLE  (ID int, NAME string,SALARY double)");
        statement.execute("ALTER TABLE HIVE_CARBON_EXAMPLE SET FILEFORMAT INPUTFORMAT \"org.apache.carbondata.hive.MapredCarbonInputFormat\"OUTPUTFORMAT \"org.apache.carbondata.hive.MapredCarbonOutputFormat\"SERDE \"org.apache.carbondata.hive.CarbonHiveSerDe\" ");
        statement.execute(new StringBuilder().append((Object)"ALTER TABLE HIVE_CARBON_EXAMPLE SET LOCATION ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'file:///", "/hive_carbon_example' "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{store}))).toString());
        String sql = "SELECT * FROM HIVE_CARBON_EXAMPLE";
        ResultSet resultSet = statement.executeQuery(sql);
        int rowsFetched = 0;
        while (resultSet.next()) {
            if (rowsFetched == 0) {
                Predef$.MODULE$.println((Object)"+---++-------++--------------+");
                Predef$.MODULE$.println((Object)"| ID|| NAME || SALARY        |");
                Predef$.MODULE$.println((Object)"+---++-------++--------------+");
                resultId = resultSet.getString("id");
                resultName = resultSet.getString("name");
                resultSalary = resultSet.getString("salary");
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"| ", " |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultId}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"| ", " |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultName}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"| ", "  |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultSalary}))).toString());
                Predef$.MODULE$.println((Object)"+---++-------++--------------+");
            } else {
                resultId = resultSet.getString("ID");
                resultName = resultSet.getString("NAME");
                resultSalary = resultSet.getString("SALARY");
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"| ", " |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultId}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"| ", " |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultName}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"| ", "   |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultSalary}))).toString());
                Predef$.MODULE$.println((Object)"+---++-------++--------------+");
            }
            ++rowsFetched;
        }
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"******Total Number Of Rows Fetched ****** ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)rowsFetched)})));
        logger.info("Fetching the Individual Columns ");
        int individualColRowsFetched = 0;
        ResultSet resultIndividualCol = statement.executeQuery("SELECT NAME FROM HIVE_CARBON_EXAMPLE");
        while (resultIndividualCol.next()) {
            if (individualColRowsFetched == 0) {
                Predef$.MODULE$.println((Object)"+--------------+");
                Predef$.MODULE$.println((Object)"| NAME         |");
                Predef$.MODULE$.println((Object)"+---++---------+");
                resultName = resultIndividualCol.getString("name");
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"| ", "    |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultName})));
                Predef$.MODULE$.println((Object)"+---++---------+");
            } else {
                resultName = resultIndividualCol.getString("NAME");
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"| ", "      |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultName})));
                Predef$.MODULE$.println((Object)"+---++---------+");
            }
            ++individualColRowsFetched;
        }
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)" ********** Total Rows Fetched When Quering The Individual Column **********").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)individualColRowsFetched)}))).toString());
        logger.info("Fetching the Out Of Order Columns ");
        ResultSet resultOutOfOrderCol = statement.executeQuery("SELECT SALARY,ID,NAME FROM HIVE_CARBON_EXAMPLE");
        int outOfOrderColFetched = 0;
        while (resultOutOfOrderCol.next()) {
            if (outOfOrderColFetched == 0) {
                Predef$.MODULE$.println((Object)"+---++-------++--------------+");
                Predef$.MODULE$.println((Object)"| Salary|| ID || NAME        |");
                Predef$.MODULE$.println((Object)"+---++-------++--------------+");
                resultId = resultOutOfOrderCol.getString("id");
                resultName = resultOutOfOrderCol.getString("name");
                resultSalary = resultOutOfOrderCol.getString("salary");
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"| ", " |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultSalary}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"| ", " |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultId}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"| ", "  |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultName}))).toString());
                Predef$.MODULE$.println((Object)"+---++-------++--------------+");
            } else {
                resultId = resultOutOfOrderCol.getString("ID");
                resultName = resultOutOfOrderCol.getString("NAME");
                resultSalary = resultOutOfOrderCol.getString("SALARY");
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"| ", " |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultSalary}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"| ", " |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultId}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"| ", "   |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultName}))).toString());
                Predef$.MODULE$.println((Object)"+---++-------++--------------+");
            }
            ++outOfOrderColFetched;
        }
        hiveEmbeddedServer2.stop();
        System.exit(0);
    }

    private HiveExample$() {
        MODULE$ = this;
        this.driverName = "org.apache.hive.jdbc.HiveDriver";
    }
}

