/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hive;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.carbondata.core.datastore.block.BlockletInfos;
import org.apache.carbondata.core.datastore.block.Distributable;
import org.apache.carbondata.core.datastore.block.TableBlockInfo;
import org.apache.carbondata.core.metadata.ColumnarFormatVersion;
import org.apache.carbondata.core.mutate.UpdateVO;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.carbondata.hadoop.internal.index.Block;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileSplit;

public class CarbonHiveInputSplit
extends FileSplit
implements Distributable,
Serializable,
Writable,
Block {
    private static final long serialVersionUID = 3520344046772190208L;
    private String taskId;
    private String segmentId;
    private String bucketId;
    private List<String> invalidSegments;
    private int numberOfBlocklets;
    private ColumnarFormatVersion version;
    private Map<String, String> blockStorageIdMap = new HashMap<String, String>(16);
    private List<UpdateVO> invalidTimestampsList;

    public CarbonHiveInputSplit() {
        this.segmentId = null;
        this.taskId = "0";
        this.bucketId = "0";
        this.numberOfBlocklets = 0;
        this.invalidSegments = new ArrayList<String>();
        this.version = CarbonProperties.getInstance().getFormatVersion();
    }

    public CarbonHiveInputSplit(String segmentId, Path path, long start, long length, String[] locations, ColumnarFormatVersion version) {
        super(path, start, length, locations);
        this.segmentId = segmentId;
        this.taskId = CarbonTablePath.DataFileUtil.getTaskNo((String)path.getName());
        this.bucketId = CarbonTablePath.DataFileUtil.getBucketNo((String)path.getName());
        this.invalidSegments = new ArrayList<String>();
        this.version = version;
    }

    public CarbonHiveInputSplit(String segmentId, Path path, long start, long length, String[] locations, int numberOfBlocklets, ColumnarFormatVersion version) {
        this(segmentId, path, start, length, locations, version);
        this.numberOfBlocklets = numberOfBlocklets;
    }

    public CarbonHiveInputSplit(String segmentId, Path path, long start, long length, String[] locations, int numberOfBlocklets, ColumnarFormatVersion version, Map<String, String> blockStorageIdMap) {
        this(segmentId, path, start, length, locations, numberOfBlocklets, version);
        this.blockStorageIdMap = blockStorageIdMap;
    }

    public static CarbonHiveInputSplit from(String segmentId, FileSplit split, ColumnarFormatVersion version) throws IOException {
        return new CarbonHiveInputSplit(segmentId, split.getPath(), split.getStart(), split.getLength(), split.getLocations(), version);
    }

    public static List<TableBlockInfo> createBlocks(List<CarbonHiveInputSplit> splitList) {
        ArrayList<TableBlockInfo> tableBlockInfoList = new ArrayList<TableBlockInfo>();
        for (CarbonHiveInputSplit split : splitList) {
            BlockletInfos blockletInfos = new BlockletInfos(split.getNumberOfBlocklets(), 0, split.getNumberOfBlocklets());
            try {
                tableBlockInfoList.add(new TableBlockInfo(split.getPath().toString(), split.getStart(), split.getSegmentId(), split.getLocations(), split.getLength(), blockletInfos, split.getVersion(), null));
            }
            catch (IOException e) {
                throw new RuntimeException("fail to get location of split: " + split, e);
            }
        }
        return tableBlockInfoList;
    }

    public static TableBlockInfo getTableBlockInfo(CarbonHiveInputSplit inputSplit) {
        BlockletInfos blockletInfos = new BlockletInfos(inputSplit.getNumberOfBlocklets(), 0, inputSplit.getNumberOfBlocklets());
        try {
            return new TableBlockInfo(inputSplit.getPath().toString(), inputSplit.getStart(), inputSplit.getSegmentId(), inputSplit.getLocations(), inputSplit.getLength(), blockletInfos, inputSplit.getVersion(), null);
        }
        catch (IOException e) {
            throw new RuntimeException("fail to get location of split: " + inputSplit, e);
        }
    }

    public String getSegmentId() {
        return this.segmentId;
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.segmentId = in.readUTF();
        this.version = ColumnarFormatVersion.valueOf((short)in.readShort());
        this.bucketId = in.readUTF();
        int numInvalidSegment = in.readInt();
        this.invalidSegments = new ArrayList<String>(numInvalidSegment);
        for (int i = 0; i < numInvalidSegment; ++i) {
            this.invalidSegments.add(in.readUTF());
        }
        this.numberOfBlocklets = in.readInt();
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeUTF(this.segmentId);
        out.writeShort(this.version.number());
        out.writeUTF(this.bucketId);
        out.writeInt(this.invalidSegments.size());
        for (String invalidSegment : this.invalidSegments) {
            out.writeUTF(invalidSegment);
        }
        out.writeInt(this.numberOfBlocklets);
    }

    public List<String> getInvalidSegments() {
        return this.invalidSegments;
    }

    public void setInvalidSegments(List<String> invalidSegments) {
        this.invalidSegments = invalidSegments;
    }

    public void setInvalidTimestampRange(List<UpdateVO> invalidTimestamps) {
        this.invalidTimestampsList = invalidTimestamps;
    }

    public List<UpdateVO> getInvalidTimestampRange() {
        return this.invalidTimestampsList;
    }

    public int getNumberOfBlocklets() {
        return this.numberOfBlocklets;
    }

    public ColumnarFormatVersion getVersion() {
        return this.version;
    }

    public void setVersion(ColumnarFormatVersion version) {
        this.version = version;
    }

    public String getBucketId() {
        return this.bucketId;
    }

    public int compareTo(Distributable o) {
        int compareResult;
        double seg2;
        if (o == null) {
            return -1;
        }
        CarbonHiveInputSplit other = (CarbonHiveInputSplit)o;
        double seg1 = Double.parseDouble(this.segmentId);
        if (Double.compare(seg1, seg2 = Double.parseDouble(other.getSegmentId())) < 0) {
            return -1;
        }
        if (Double.compare(seg1, seg2) > 0) {
            return 1;
        }
        String filePath1 = this.getPath().getName();
        String filePath2 = other.getPath().getName();
        if (CarbonTablePath.isCarbonDataFile((String)filePath1)) {
            int otherBucketNo;
            int otherTaskId;
            int firstTaskId = Integer.parseInt(CarbonTablePath.DataFileUtil.getTaskNo((String)filePath1));
            if (firstTaskId != (otherTaskId = Integer.parseInt(CarbonTablePath.DataFileUtil.getTaskNo((String)filePath2)))) {
                return firstTaskId - otherTaskId;
            }
            int firstBucketNo = Integer.parseInt(CarbonTablePath.DataFileUtil.getBucketNo((String)filePath1));
            if (firstBucketNo != (otherBucketNo = Integer.parseInt(CarbonTablePath.DataFileUtil.getBucketNo((String)filePath2)))) {
                return firstBucketNo - otherBucketNo;
            }
            int firstPartNo = Integer.parseInt(CarbonTablePath.DataFileUtil.getPartNo((String)filePath1));
            int SecondPartNo = Integer.parseInt(CarbonTablePath.DataFileUtil.getPartNo((String)filePath2));
            compareResult = firstPartNo - SecondPartNo;
        } else {
            compareResult = filePath1.compareTo(filePath2);
        }
        if (compareResult != 0) {
            return compareResult;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CarbonHiveInputSplit)) {
            return false;
        }
        CarbonHiveInputSplit other = (CarbonHiveInputSplit)obj;
        return 0 == this.compareTo(other);
    }

    public int hashCode() {
        int result = this.taskId.hashCode();
        result = 31 * result + this.segmentId.hashCode();
        result = 31 * result + this.bucketId.hashCode();
        result = 31 * result + this.invalidSegments.hashCode();
        result = 31 * result + this.numberOfBlocklets;
        return result;
    }

    public String getBlockPath() {
        return this.getPath().getName();
    }

    public List<Long> getMatchedBlocklets() {
        return null;
    }

    public boolean fullScan() {
        return true;
    }

    public Map<String, String> getBlockStorageIdMap() {
        return this.blockStorageIdMap;
    }
}

