/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hive;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.carbondata.core.cache.Cache;
import org.apache.carbondata.core.cache.CacheProvider;
import org.apache.carbondata.core.cache.CacheType;
import org.apache.carbondata.core.cache.dictionary.Dictionary;
import org.apache.carbondata.core.cache.dictionary.DictionaryColumnUniqueIdentifier;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.encoder.Encoding;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.hadoop.readsupport.CarbonReadSupport;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.util.GenericArrayData;

public class CarbonDictionaryDecodeReadSupport<T>
implements CarbonReadSupport<T> {
    protected Dictionary[] dictionaries;
    protected DataType[] dataTypes;
    protected CarbonColumn[] carbonColumns;
    protected Writable[] writableArr;

    public void initialize(CarbonColumn[] carbonColumns, CarbonTable carbonTable) throws IOException {
        this.carbonColumns = carbonColumns;
        this.dictionaries = new Dictionary[carbonColumns.length];
        this.dataTypes = new DataType[carbonColumns.length];
        for (int i = 0; i < carbonColumns.length; ++i) {
            if (carbonColumns[i].hasEncoding(Encoding.DICTIONARY) && !carbonColumns[i].hasEncoding(Encoding.DIRECT_DICTIONARY) && !carbonColumns[i].isComplex().booleanValue()) {
                CacheProvider cacheProvider = CacheProvider.getInstance();
                Cache forwardDictionaryCache = cacheProvider.createCache(CacheType.FORWARD_DICTIONARY);
                this.dataTypes[i] = carbonColumns[i].getDataType();
                String dictionaryPath = (String)carbonTable.getTableInfo().getFactTable().getTableProperties().get("dictionary_path");
                this.dictionaries[i] = (Dictionary)forwardDictionaryCache.get((Object)new DictionaryColumnUniqueIdentifier(carbonTable.getAbsoluteTableIdentifier(), carbonColumns[i].getColumnIdentifier(), this.dataTypes[i], dictionaryPath));
                continue;
            }
            this.dataTypes[i] = carbonColumns[i].getDataType();
        }
    }

    public T readRow(Object[] data) {
        assert (data.length == this.dictionaries.length);
        this.writableArr = new Writable[data.length];
        for (int i = 0; i < this.dictionaries.length; ++i) {
            if (this.dictionaries[i] != null) {
                data[i] = this.dictionaries[i].getDictionaryValueForKey(((Integer)data[i]).intValue());
            }
            try {
                this.writableArr[i] = this.createWritableObject(data[i], this.carbonColumns[i]);
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return (T)this.writableArr;
    }

    public void close() {
        if (this.dictionaries == null) {
            return;
        }
        for (int i = 0; i < this.dictionaries.length; ++i) {
            CarbonUtil.clearDictionaryCache((Dictionary)this.dictionaries[i]);
        }
    }

    private Writable createWritableObject(Object obj, CarbonColumn carbonColumn) throws IOException {
        DataType dataType = carbonColumn.getDataType();
        if (DataTypes.isStructType((DataType)dataType)) {
            return this.createStruct(obj, carbonColumn);
        }
        if (DataTypes.isArrayType((DataType)dataType)) {
            return this.createArray(obj, carbonColumn);
        }
        return this.createWritablePrimitive(obj, carbonColumn);
    }

    private ArrayWritable createArray(Object obj, CarbonColumn carbonColumn) throws IOException {
        if (obj instanceof GenericArrayData) {
            Object[] objArray = ((GenericArrayData)obj).array();
            List childCarbonDimensions = null;
            CarbonDimension arrayDimension = null;
            if (carbonColumn.isDimension().booleanValue() && carbonColumn.getColumnSchema().getNumberOfChild() > 0) {
                childCarbonDimensions = ((CarbonDimension)carbonColumn).getListOfChildDimensions();
                arrayDimension = (CarbonDimension)childCarbonDimensions.get(0);
            }
            ArrayList<Writable> array = new ArrayList<Writable>();
            if (objArray != null) {
                for (int i = 0; i < objArray.length; ++i) {
                    Object curObj = objArray[i];
                    Writable newObj = this.createWritableObject(curObj, (CarbonColumn)arrayDimension);
                    array.add(newObj);
                }
            }
            if (array.size() > 0) {
                ArrayWritable subArray = new ArrayWritable(Writable.class, array.toArray(new Writable[array.size()]));
                return new ArrayWritable(Writable.class, new Writable[]{subArray});
            }
        }
        return null;
    }

    private ArrayWritable createStruct(Object obj, CarbonColumn carbonColumn) throws IOException {
        if (obj instanceof GenericInternalRow) {
            Object[] objArray = ((GenericInternalRow)obj).values();
            List childCarbonDimensions = null;
            if (carbonColumn.isDimension().booleanValue() && carbonColumn.getColumnSchema().getNumberOfChild() > 0) {
                childCarbonDimensions = ((CarbonDimension)carbonColumn).getListOfChildDimensions();
            }
            Writable[] arr = new Writable[objArray.length];
            for (int i = 0; i < objArray.length; ++i) {
                arr[i] = this.createWritableObject(objArray[i], (CarbonColumn)childCarbonDimensions.get(i));
            }
            return new ArrayWritable(Writable.class, arr);
        }
        throw new IOException("DataType not supported in Carbondata");
    }

    private Writable createWritablePrimitive(Object obj, CarbonColumn carbonColumn) throws IOException {
        DataType dataType = carbonColumn.getDataType();
        if (obj == null) {
            return null;
        }
        if (dataType == DataTypes.NULL) {
            return null;
        }
        if (dataType == DataTypes.DOUBLE) {
            return new DoubleWritable(((Double)obj).doubleValue());
        }
        if (dataType == DataTypes.INT) {
            return new IntWritable(((Integer)obj).intValue());
        }
        if (dataType == DataTypes.LONG) {
            return new LongWritable(((Long)obj).longValue());
        }
        if (dataType == DataTypes.SHORT) {
            return new ShortWritable(((Short)obj).shortValue());
        }
        if (dataType == DataTypes.DATE) {
            Calendar c = Calendar.getInstance();
            c.setTime(new Date(0L));
            c.add(6, (Integer)obj);
            Date date = new Date(c.getTime().getTime());
            return new DateWritable(date);
        }
        if (dataType == DataTypes.TIMESTAMP) {
            return new TimestampWritable(new Timestamp((Long)obj / 1000L));
        }
        if (dataType == DataTypes.STRING) {
            return new Text(obj.toString());
        }
        if (DataTypes.isDecimal((DataType)dataType)) {
            return new HiveDecimalWritable(HiveDecimal.create((BigDecimal)new BigDecimal(obj.toString())));
        }
        throw new IOException("unsupported data type:" + dataType);
    }
}

