/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hadoop.testutil;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.apache.carbondata.common.CarbonIterator;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.cache.Cache;
import org.apache.carbondata.core.cache.CacheProvider;
import org.apache.carbondata.core.cache.CacheType;
import org.apache.carbondata.core.cache.dictionary.Dictionary;
import org.apache.carbondata.core.cache.dictionary.DictionaryColumnUniqueIdentifier;
import org.apache.carbondata.core.datamap.DataMapStoreManager;
import org.apache.carbondata.core.datastore.compression.CompressorFactory;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.fileoperations.AtomicFileOperationFactory;
import org.apache.carbondata.core.fileoperations.AtomicFileOperations;
import org.apache.carbondata.core.fileoperations.FileWriteOperation;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.CarbonMetadata;
import org.apache.carbondata.core.metadata.CarbonTableIdentifier;
import org.apache.carbondata.core.metadata.ColumnIdentifier;
import org.apache.carbondata.core.metadata.converter.ThriftWrapperSchemaConverterImpl;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.encoder.Encoding;
import org.apache.carbondata.core.metadata.schema.SchemaEvolution;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.TableSchema;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema;
import org.apache.carbondata.core.statusmanager.LoadMetadataDetails;
import org.apache.carbondata.core.statusmanager.SegmentStatus;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.DataTypeUtil;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.carbondata.core.writer.CarbonDictionaryWriterImpl;
import org.apache.carbondata.core.writer.ThriftWriter;
import org.apache.carbondata.core.writer.sortindex.CarbonDictionarySortIndexWriterImpl;
import org.apache.carbondata.core.writer.sortindex.CarbonDictionarySortInfo;
import org.apache.carbondata.core.writer.sortindex.CarbonDictionarySortInfoPreparator;
import org.apache.carbondata.format.SchemaEvolutionEntry;
import org.apache.carbondata.format.TableInfo;
import org.apache.carbondata.processing.loading.DataLoadExecutor;
import org.apache.carbondata.processing.loading.csvinput.BlockDetails;
import org.apache.carbondata.processing.loading.csvinput.CSVInputFormat;
import org.apache.carbondata.processing.loading.csvinput.CSVRecordReaderIterator;
import org.apache.carbondata.processing.loading.model.CarbonDataLoadSchema;
import org.apache.carbondata.processing.loading.model.CarbonLoadModel;
import org.apache.carbondata.processing.util.TableOptionConstant;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.log4j.Logger;
import org.apache.thrift.TBase;

public class StoreCreator {
    private static final Logger LOG = LogServiceFactory.getLogService((String)StoreCreator.class.getCanonicalName());
    private AbsoluteTableIdentifier absoluteTableIdentifier;
    private String storePath = null;
    private String csvPath;
    private boolean dictionary;
    private List<String> sortColumns = new ArrayList<String>();

    public StoreCreator(String storePath, String csvPath) {
        this(storePath, csvPath, false);
    }

    public StoreCreator(String storePath, String csvPath, boolean dictionary) {
        this.storePath = storePath;
        this.csvPath = csvPath;
        String dbName = "testdb";
        String tableName = "testtable";
        this.sortColumns.add("date");
        this.sortColumns.add("country");
        this.sortColumns.add("name");
        this.sortColumns.add("phonetype");
        this.sortColumns.add("serialname");
        this.absoluteTableIdentifier = AbsoluteTableIdentifier.from((String)(storePath + "/testdb/testtable"), (CarbonTableIdentifier)new CarbonTableIdentifier(dbName, tableName, UUID.randomUUID().toString()));
        this.dictionary = dictionary;
    }

    public AbsoluteTableIdentifier getAbsoluteTableIdentifier() {
        return this.absoluteTableIdentifier;
    }

    public static CarbonLoadModel buildCarbonLoadModel(CarbonTable table, String factFilePath, AbsoluteTableIdentifier absoluteTableIdentifier) {
        CarbonDataLoadSchema schema = new CarbonDataLoadSchema(table);
        CarbonLoadModel loadModel = new CarbonLoadModel();
        String columnCompressor = (String)table.getTableInfo().getFactTable().getTableProperties().get("carbon.column.compressor");
        if (columnCompressor == null) {
            columnCompressor = CompressorFactory.getInstance().getCompressor().getName();
        }
        loadModel.setColumnCompressor(columnCompressor);
        loadModel.setCarbonDataLoadSchema(schema);
        loadModel.setDatabaseName(absoluteTableIdentifier.getCarbonTableIdentifier().getDatabaseName());
        loadModel.setTableName(absoluteTableIdentifier.getCarbonTableIdentifier().getTableName());
        loadModel.setTableName(absoluteTableIdentifier.getCarbonTableIdentifier().getTableName());
        loadModel.setFactFilePath(factFilePath);
        loadModel.setLoadMetadataDetails(new ArrayList());
        loadModel.setTablePath(absoluteTableIdentifier.getTablePath());
        loadModel.setDateFormat(null);
        loadModel.setCarbonTransactionalTable(table.isTransactionalTable());
        loadModel.setDefaultTimestampFormat(CarbonProperties.getInstance().getProperty("carbon.timestamp.format", "dd-MM-yyyy HH:mm:ss:SSS"));
        loadModel.setDefaultDateFormat(CarbonProperties.getInstance().getProperty("carbon.date.format", "yyyy-MM-dd"));
        loadModel.setSerializationNullFormat(TableOptionConstant.SERIALIZATION_NULL_FORMAT.getName() + ",\\N");
        loadModel.setBadRecordsLoggerEnable(TableOptionConstant.BAD_RECORDS_LOGGER_ENABLE.getName() + ",false");
        loadModel.setBadRecordsAction(TableOptionConstant.BAD_RECORDS_ACTION.getName() + ",FORCE");
        loadModel.setIsEmptyDataBadRecord("IS_EMPTY_DATA_BAD_RECORD,false");
        loadModel.setCsvHeader("ID,date,country,name,phonetype,serialname,salary");
        loadModel.setCsvHeaderColumns(loadModel.getCsvHeader().split(","));
        loadModel.setTaskNo("0");
        loadModel.setSegmentId("0");
        loadModel.setFactTimeStamp(System.currentTimeMillis());
        loadModel.setMaxColumns("10");
        return loadModel;
    }

    public void createCarbonStore() throws Exception {
        CarbonLoadModel loadModel = this.createTableAndLoadModel();
        StoreCreator.loadData(loadModel, this.storePath);
    }

    public void createCarbonStore(CarbonLoadModel loadModel) throws Exception {
        StoreCreator.loadData(loadModel, this.storePath);
    }

    public void clearDataMaps() throws IOException {
        DataMapStoreManager.getInstance().clearDataMaps(this.absoluteTableIdentifier);
    }

    public CarbonLoadModel createTableAndLoadModel(boolean deleteOldStore) throws Exception {
        if (deleteOldStore) {
            File storeDir = new File(this.storePath);
            CarbonUtil.deleteFoldersAndFiles((File[])new File[]{storeDir});
        }
        CarbonTable table = this.createTable(this.absoluteTableIdentifier);
        this.writeDictionary(this.csvPath, table);
        return StoreCreator.buildCarbonLoadModel(table, this.csvPath, this.absoluteTableIdentifier);
    }

    public CarbonLoadModel createTableAndLoadModel() throws Exception {
        return this.createTableAndLoadModel(true);
    }

    public CarbonTable createTable(AbsoluteTableIdentifier identifier) throws IOException {
        org.apache.carbondata.core.metadata.schema.table.TableInfo tableInfo = new org.apache.carbondata.core.metadata.schema.table.TableInfo();
        tableInfo.setDatabaseName(identifier.getCarbonTableIdentifier().getDatabaseName());
        TableSchema tableSchema = new TableSchema();
        tableSchema.setTableName(identifier.getCarbonTableIdentifier().getTableName());
        ArrayList<ColumnSchema> columnSchemas = new ArrayList<ColumnSchema>();
        ArrayList<Encoding> encodings = new ArrayList<Encoding>();
        if (this.dictionary) {
            encodings.add(Encoding.DICTIONARY);
        }
        int schemaOrdinal = 0;
        ColumnSchema id = new ColumnSchema();
        id.setColumnName("id");
        id.setDataType(DataTypes.INT);
        id.setEncodingList(encodings);
        id.setColumnUniqueId(UUID.randomUUID().toString());
        id.setColumnReferenceId(id.getColumnUniqueId());
        id.setDimensionColumn(true);
        id.setSchemaOrdinal(schemaOrdinal++);
        if (this.sortColumns.contains(id.getColumnName())) {
            id.setSortColumn(true);
        }
        columnSchemas.add(id);
        ColumnSchema date = new ColumnSchema();
        date.setColumnName("date");
        date.setDataType(DataTypes.STRING);
        date.setEncodingList(encodings);
        date.setColumnUniqueId(UUID.randomUUID().toString());
        date.setDimensionColumn(true);
        date.setColumnReferenceId(date.getColumnUniqueId());
        date.setSchemaOrdinal(schemaOrdinal++);
        if (this.sortColumns.contains(date.getColumnName())) {
            date.setSortColumn(true);
        }
        columnSchemas.add(date);
        ColumnSchema country = new ColumnSchema();
        country.setColumnName("country");
        country.setDataType(DataTypes.STRING);
        country.setEncodingList(encodings);
        country.setColumnUniqueId(UUID.randomUUID().toString());
        country.setDimensionColumn(true);
        country.setSortColumn(true);
        country.setSchemaOrdinal(schemaOrdinal++);
        if (this.sortColumns.contains(country.getColumnName())) {
            country.setSortColumn(true);
        }
        country.setColumnReferenceId(country.getColumnUniqueId());
        columnSchemas.add(country);
        ColumnSchema name = new ColumnSchema();
        name.setColumnName("name");
        name.setDataType(DataTypes.STRING);
        name.setEncodingList(encodings);
        name.setColumnUniqueId(UUID.randomUUID().toString());
        name.setDimensionColumn(true);
        name.setSchemaOrdinal(schemaOrdinal++);
        if (this.sortColumns.contains(name.getColumnName())) {
            name.setSortColumn(true);
        }
        name.setColumnReferenceId(name.getColumnUniqueId());
        columnSchemas.add(name);
        ColumnSchema phonetype = new ColumnSchema();
        phonetype.setColumnName("phonetype");
        phonetype.setDataType(DataTypes.STRING);
        phonetype.setEncodingList(encodings);
        phonetype.setColumnUniqueId(UUID.randomUUID().toString());
        phonetype.setDimensionColumn(true);
        phonetype.setSchemaOrdinal(schemaOrdinal++);
        if (this.sortColumns.contains(phonetype.getColumnName())) {
            phonetype.setSortColumn(true);
        }
        phonetype.setColumnReferenceId(phonetype.getColumnUniqueId());
        columnSchemas.add(phonetype);
        ColumnSchema serialname = new ColumnSchema();
        serialname.setColumnName("serialname");
        serialname.setDataType(DataTypes.STRING);
        serialname.setEncodingList(encodings);
        serialname.setColumnUniqueId(UUID.randomUUID().toString());
        serialname.setDimensionColumn(true);
        serialname.setSchemaOrdinal(schemaOrdinal++);
        if (this.sortColumns.contains(serialname.getColumnName())) {
            serialname.setSortColumn(true);
        }
        serialname.setColumnReferenceId(serialname.getColumnUniqueId());
        columnSchemas.add(serialname);
        ColumnSchema salary = new ColumnSchema();
        salary.setColumnName("salary");
        salary.setDataType(DataTypes.INT);
        salary.setEncodingList(new ArrayList());
        salary.setColumnUniqueId(UUID.randomUUID().toString());
        salary.setDimensionColumn(false);
        salary.setColumnReferenceId(salary.getColumnUniqueId());
        salary.setSchemaOrdinal(schemaOrdinal++);
        columnSchemas.add(salary);
        List<ColumnSchema> columnSchemas1 = this.reArrangeColumnSchema(columnSchemas);
        tableSchema.setListOfColumns(columnSchemas1);
        SchemaEvolution schemaEvol = new SchemaEvolution();
        schemaEvol.setSchemaEvolutionEntryList(new ArrayList());
        tableSchema.setSchemaEvolution(schemaEvol);
        tableSchema.setTableId(UUID.randomUUID().toString());
        tableInfo.setTableUniqueName(identifier.getCarbonTableIdentifier().getTableUniqueName());
        tableInfo.setLastUpdatedTime(System.currentTimeMillis());
        tableInfo.setFactTable(tableSchema);
        tableInfo.setTablePath(identifier.getTablePath());
        String schemaFilePath = CarbonTablePath.getSchemaFilePath((String)identifier.getTablePath());
        String schemaMetadataPath = CarbonTablePath.getFolderContainingFile((String)schemaFilePath);
        CarbonMetadata.getInstance().loadTableMetadata(tableInfo);
        ThriftWrapperSchemaConverterImpl schemaConverter = new ThriftWrapperSchemaConverterImpl();
        TableInfo thriftTableInfo = schemaConverter.fromWrapperToExternalTableInfo(tableInfo, tableInfo.getDatabaseName(), tableInfo.getFactTable().getTableName());
        SchemaEvolutionEntry schemaEvolutionEntry = new SchemaEvolutionEntry(tableInfo.getLastUpdatedTime());
        thriftTableInfo.getFact_table().getSchema_evolution().getSchema_evolution_history().add(schemaEvolutionEntry);
        FileFactory.FileType fileType = FileFactory.getFileType((String)schemaMetadataPath);
        if (!FileFactory.isFileExist((String)schemaMetadataPath, (FileFactory.FileType)fileType)) {
            FileFactory.mkdirs((String)schemaMetadataPath, (FileFactory.FileType)fileType);
        }
        ThriftWriter thriftWriter = new ThriftWriter(schemaFilePath, false);
        thriftWriter.open();
        thriftWriter.write((TBase)thriftTableInfo);
        thriftWriter.close();
        return CarbonMetadata.getInstance().getCarbonTable(tableInfo.getTableUniqueName());
    }

    private List<ColumnSchema> reArrangeColumnSchema(List<ColumnSchema> columnSchemas) {
        ArrayList<ColumnSchema> newColumnSchema = new ArrayList<ColumnSchema>(columnSchemas.size());
        for (ColumnSchema columnSchema : columnSchemas) {
            if (!columnSchema.isSortColumn()) continue;
            newColumnSchema.add(columnSchema);
        }
        for (ColumnSchema columnSchema : columnSchemas) {
            if (columnSchema.isSortColumn() || !columnSchema.isDimensionColumn()) continue;
            newColumnSchema.add(columnSchema);
        }
        for (ColumnSchema columnSchema : columnSchemas) {
            if (columnSchema.isDimensionColumn()) continue;
            newColumnSchema.add(columnSchema);
        }
        return newColumnSchema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDictionary(String factFilePath, CarbonTable table) throws Exception {
        int i;
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(factFilePath), "UTF-8"));
        List dims = table.getDimensionByTableName(table.getTableName());
        HashSet[] set = new HashSet[dims.size()];
        for (int i2 = 0; i2 < set.length; ++i2) {
            set[i2] = new HashSet();
        }
        String line = reader.readLine();
        while (line != null) {
            String[] data = line.split(",");
            for (i = 0; i < set.length; ++i) {
                set[i].add(data[i]);
            }
            line = reader.readLine();
        }
        Cache dictCache = CacheProvider.getInstance().createCache(CacheType.REVERSE_DICTIONARY);
        for (i = 0; i < set.length; ++i) {
            ColumnIdentifier columnIdentifier = new ColumnIdentifier(((CarbonDimension)dims.get(i)).getColumnId(), null, null);
            DictionaryColumnUniqueIdentifier dictionaryColumnUniqueIdentifier = new DictionaryColumnUniqueIdentifier(table.getAbsoluteTableIdentifier(), columnIdentifier, columnIdentifier.getDataType());
            CarbonDictionaryWriterImpl writer = new CarbonDictionaryWriterImpl(dictionaryColumnUniqueIdentifier);
            for (String value : set[i]) {
                writer.write(value);
            }
            writer.close();
            writer.commit();
            Dictionary dict = (Dictionary)dictCache.get((Object)new DictionaryColumnUniqueIdentifier(this.absoluteTableIdentifier, columnIdentifier, ((CarbonDimension)dims.get(i)).getDataType()));
            CarbonDictionarySortInfoPreparator preparator = new CarbonDictionarySortInfoPreparator();
            ArrayList newDistinctValues = new ArrayList();
            CarbonDictionarySortInfo dictionarySortInfo = preparator.getDictionarySortInfo(newDistinctValues, dict, ((CarbonDimension)dims.get(i)).getDataType());
            try (CarbonDictionarySortIndexWriterImpl carbonDictionaryWriter = new CarbonDictionarySortIndexWriterImpl(dictionaryColumnUniqueIdentifier);){
                carbonDictionaryWriter.writeSortIndex(dictionarySortInfo.getSortIndex());
                carbonDictionaryWriter.writeInvertedSortIndex(dictionarySortInfo.getSortIndexInverted());
                continue;
            }
        }
        reader.close();
    }

    public void setSortColumns(List<String> sortColumns) {
        this.sortColumns = sortColumns;
    }

    public static void loadData(CarbonLoadModel loadModel, String storeLocation) throws Exception {
        if (new File(storeLocation).mkdirs()) {
            LOG.warn((Object)"mkdir is failed");
        }
        String outPutLoc = storeLocation + "/etl";
        String databaseName = loadModel.getDatabaseName();
        String tableName = loadModel.getTableName();
        String tempLocationKey = databaseName + '_' + tableName + "_1";
        CarbonProperties.getInstance().addProperty(tempLocationKey, storeLocation + "/" + databaseName + "/" + tableName);
        CarbonProperties.getInstance().addProperty("store_output_location", outPutLoc);
        CarbonProperties.getInstance().addProperty("send.signal.load", "false");
        CarbonProperties.getInstance().addProperty("carbon.is.columnar.storage", "true");
        CarbonProperties.getInstance().addProperty("carbon.dimension.split.value.in.columnar", "1");
        CarbonProperties.getInstance().addProperty("carbon.is.fullyfilled.bits", "true");
        CarbonProperties.getInstance().addProperty("is.int.based.indexer", "true");
        CarbonProperties.getInstance().addProperty("aggregate.columnar.keyblock", "true");
        CarbonProperties.getInstance().addProperty("is.compressed.keyblock", "false");
        String graphPath = outPutLoc + File.separator + loadModel.getDatabaseName() + File.separator + tableName + File.separator + 0 + File.separator + 1 + File.separator + tableName + ".ktr";
        File path = new File(graphPath);
        if (path.exists() && !path.delete()) {
            LOG.warn((Object)("delete " + path + " failed"));
        }
        BlockDetails blockDetails = new BlockDetails(new Path(loadModel.getFactFilePath()), 0L, new File(loadModel.getFactFilePath()).length(), new String[]{"localhost"});
        Configuration configuration = new Configuration();
        CSVInputFormat.setCommentCharacter((Configuration)configuration, (String)loadModel.getCommentChar());
        CSVInputFormat.setCSVDelimiter((Configuration)configuration, (String)loadModel.getCsvDelimiter());
        CSVInputFormat.setEscapeCharacter((Configuration)configuration, (String)loadModel.getEscapeChar());
        CSVInputFormat.setHeaderExtractionEnabled((Configuration)configuration, (boolean)true);
        CSVInputFormat.setQuoteCharacter((Configuration)configuration, (String)loadModel.getQuoteChar());
        CSVInputFormat.setReadBufferSize((Configuration)configuration, (String)CarbonProperties.getInstance().getProperty("carbon.csv.read.buffersize.byte", "1048576"));
        CSVInputFormat.setNumberOfColumns((Configuration)configuration, (String)String.valueOf(loadModel.getCsvHeaderColumns().length));
        CSVInputFormat.setMaxColumns((Configuration)configuration, (String)"10");
        TaskAttemptContextImpl hadoopAttemptContext = new TaskAttemptContextImpl(configuration, (org.apache.hadoop.mapreduce.TaskAttemptID)new TaskAttemptID("", 1, TaskType.MAP, 0, 0));
        CSVInputFormat format = new CSVInputFormat();
        RecordReader recordReader = format.createRecordReader((InputSplit)blockDetails, (TaskAttemptContext)hadoopAttemptContext);
        CSVRecordReaderIterator readerIterator = new CSVRecordReaderIterator(recordReader, (InputSplit)blockDetails, (TaskAttemptContext)hadoopAttemptContext);
        DataTypeUtil.clearFormatter();
        new DataLoadExecutor().execute(loadModel, new String[]{storeLocation + "/" + databaseName + "/" + tableName}, new CarbonIterator[]{readerIterator});
        StoreCreator.writeLoadMetadata(loadModel.getCarbonDataLoadSchema(), loadModel.getTableName(), loadModel.getTableName(), new ArrayList<LoadMetadataDetails>());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeLoadMetadata(CarbonDataLoadSchema schema, String databaseName, String tableName, List<LoadMetadataDetails> listOfLoadFolderDetails) throws IOException {
        LoadMetadataDetails loadMetadataDetails = new LoadMetadataDetails();
        loadMetadataDetails.setLoadEndTime(System.currentTimeMillis());
        loadMetadataDetails.setSegmentStatus(SegmentStatus.SUCCESS);
        loadMetadataDetails.setLoadName(String.valueOf(0));
        loadMetadataDetails.setLoadStartTime(loadMetadataDetails.getTimeStamp(StoreCreator.readCurrentTime()).longValue());
        listOfLoadFolderDetails.add(loadMetadataDetails);
        String dataLoadLocation = schema.getCarbonTable().getMetadataPath() + File.separator + "tablestatus";
        Gson gsonObjectToWrite = new Gson();
        BufferedWriter brWriter = null;
        AtomicFileOperations writeOperation = AtomicFileOperationFactory.getAtomicFileOperations((String)dataLoadLocation);
        try {
            DataOutputStream dataOutputStream = writeOperation.openForWrite(FileWriteOperation.OVERWRITE);
            brWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)dataOutputStream, Charset.forName("UTF-8")));
            String metadataInstance = gsonObjectToWrite.toJson((Object)listOfLoadFolderDetails.toArray());
            brWriter.write(metadataInstance);
        }
        catch (IOException ioe) {
            try {
                LOG.error((Object)("Error message: " + ioe.getLocalizedMessage()));
                writeOperation.setFailed();
                throw ioe;
            }
            catch (Throwable throwable) {
                if (null != brWriter) {
                    brWriter.flush();
                }
                CarbonUtil.closeStreams((Closeable[])new Closeable[]{brWriter});
                throw throwable;
            }
        }
        if (null != brWriter) {
            brWriter.flush();
        }
        CarbonUtil.closeStreams((Closeable[])new Closeable[]{brWriter});
        writeOperation.close();
    }

    public static String readCurrentTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss:SSS");
        String date = null;
        date = sdf.format(new Date());
        return date;
    }

    public static void main(String[] args) throws Exception {
        new StoreCreator(new File("target/store").getAbsolutePath(), new File("../hadoop/src/test/resources/data.csv").getCanonicalPath()).createCarbonStore();
    }
}

