/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hadoop.stream;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import org.apache.carbondata.core.cache.Cache;
import org.apache.carbondata.core.cache.CacheProvider;
import org.apache.carbondata.core.cache.CacheType;
import org.apache.carbondata.core.cache.dictionary.Dictionary;
import org.apache.carbondata.core.cache.dictionary.DictionaryColumnUniqueIdentifier;
import org.apache.carbondata.core.constants.CarbonCommonConstants;
import org.apache.carbondata.core.datastore.block.SegmentProperties;
import org.apache.carbondata.core.datastore.compression.CompressorFactory;
import org.apache.carbondata.core.keygenerator.directdictionary.DirectDictionaryGenerator;
import org.apache.carbondata.core.keygenerator.directdictionary.DirectDictionaryKeyGeneratorFactory;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.encoder.Encoding;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.reader.CarbonHeaderReader;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.scan.expression.exception.FilterUnsupportedException;
import org.apache.carbondata.core.scan.filter.FilterUtil;
import org.apache.carbondata.core.scan.filter.GenericQueryType;
import org.apache.carbondata.core.scan.filter.executer.FilterExecuter;
import org.apache.carbondata.core.scan.filter.intf.RowImpl;
import org.apache.carbondata.core.scan.filter.intf.RowIntf;
import org.apache.carbondata.core.scan.filter.resolver.FilterResolverIntf;
import org.apache.carbondata.core.scan.model.QueryModel;
import org.apache.carbondata.core.util.CarbonMetadataUtil;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.DataTypeUtil;
import org.apache.carbondata.format.BlockletHeader;
import org.apache.carbondata.format.BlockletMinMaxIndex;
import org.apache.carbondata.format.FileHeader;
import org.apache.carbondata.hadoop.CarbonInputSplit;
import org.apache.carbondata.hadoop.CarbonMultiBlockSplit;
import org.apache.carbondata.hadoop.api.CarbonTableInputFormat;
import org.apache.carbondata.hadoop.stream.CarbonStreamInputFormat;
import org.apache.carbondata.hadoop.stream.StreamBlockletReader;
import org.apache.carbondata.processing.util.CarbonDataProcessorUtil;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

public class StreamRecordReader
extends RecordReader<Void, Object> {
    protected CarbonTable carbonTable;
    private CarbonColumn[] storageColumns;
    private boolean[] isRequired;
    private boolean[] dimensionsIsVarcharTypeMap;
    private DataType[] measureDataTypes;
    private int dimensionCount;
    private int measureCount;
    private FileSplit fileSplit;
    private Configuration hadoopConf;
    protected StreamBlockletReader input;
    protected boolean isFirstRow = true;
    protected QueryModel model;
    private BitSet allNonNull;
    private boolean[] isNoDictColumn;
    private DirectDictionaryGenerator[] directDictionaryGenerators;
    private CacheProvider cacheProvider;
    private Cache<DictionaryColumnUniqueIdentifier, Dictionary> cache;
    private GenericQueryType[] queryTypes;
    private String compressorName;
    protected boolean isFinished = false;
    protected FilterExecuter filter;
    private boolean[] isFilterRequired;
    private Object[] filterValues;
    protected RowIntf filterRow;
    private int[] filterMap;
    protected CarbonColumn[] projection;
    private boolean[] isProjectionRequired;
    private int[] projectionMap;
    protected Object[] outputValues;
    protected boolean skipScanData;
    private boolean useRawRow = false;

    public StreamRecordReader(QueryModel mdl, boolean useRawRow) {
        this.model = mdl;
        this.useRawRow = useRawRow;
    }

    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException {
        int i;
        this.fileSplit = split instanceof CarbonInputSplit ? (CarbonInputSplit)split : (split instanceof CarbonMultiBlockSplit ? (FileSplit)((CarbonMultiBlockSplit)split).getAllSplits().get(0) : (FileSplit)split);
        this.hadoopConf = context.getConfiguration();
        if (this.model == null) {
            CarbonTableInputFormat format = new CarbonTableInputFormat();
            this.model = format.createQueryModel(split, context);
        }
        this.carbonTable = this.model.getTable();
        List dimensions = this.carbonTable.getDimensionByTableName(this.carbonTable.getTableName());
        this.dimensionCount = dimensions.size();
        List measures = this.carbonTable.getMeasureByTableName(this.carbonTable.getTableName());
        this.measureCount = measures.size();
        List carbonColumnList = this.carbonTable.getStreamStorageOrderColumn(this.carbonTable.getTableName());
        this.storageColumns = carbonColumnList.toArray(new CarbonColumn[carbonColumnList.size()]);
        this.isNoDictColumn = CarbonDataProcessorUtil.getNoDictionaryMapping((CarbonColumn[])this.storageColumns);
        this.directDictionaryGenerators = new DirectDictionaryGenerator[this.storageColumns.length];
        for (i = 0; i < this.storageColumns.length; ++i) {
            if (!this.storageColumns[i].hasEncoding(Encoding.DIRECT_DICTIONARY)) continue;
            this.directDictionaryGenerators[i] = DirectDictionaryKeyGeneratorFactory.getDirectDictionaryGenerator((DataType)this.storageColumns[i].getDataType());
        }
        this.dimensionsIsVarcharTypeMap = new boolean[this.dimensionCount];
        for (i = 0; i < this.dimensionCount; ++i) {
            this.dimensionsIsVarcharTypeMap[i] = this.storageColumns[i].getDataType() == DataTypes.VARCHAR;
        }
        this.measureDataTypes = new DataType[this.measureCount];
        for (i = 0; i < this.measureCount; ++i) {
            this.measureDataTypes[i] = this.storageColumns[this.dimensionCount + i].getDataType();
        }
        this.allNonNull = new BitSet(this.storageColumns.length);
        this.projection = this.model.getProjectionColumns();
        this.isRequired = new boolean[this.storageColumns.length];
        boolean[] isFiltlerDimensions = this.model.getIsFilterDimensions();
        boolean[] isFiltlerMeasures = this.model.getIsFilterMeasures();
        this.isFilterRequired = new boolean[this.storageColumns.length];
        this.filterMap = new int[this.storageColumns.length];
        for (int i2 = 0; i2 < this.storageColumns.length; ++i2) {
            if (this.storageColumns[i2].isDimension().booleanValue()) {
                if (!isFiltlerDimensions[this.storageColumns[i2].getOrdinal()]) continue;
                this.isRequired[i2] = true;
                this.isFilterRequired[i2] = true;
                this.filterMap[i2] = this.storageColumns[i2].getOrdinal();
                continue;
            }
            if (!isFiltlerMeasures[this.storageColumns[i2].getOrdinal()]) continue;
            this.isRequired[i2] = true;
            this.isFilterRequired[i2] = true;
            this.filterMap[i2] = this.carbonTable.getDimensionOrdinalMax() + this.storageColumns[i2].getOrdinal();
        }
        this.isProjectionRequired = new boolean[this.storageColumns.length];
        this.projectionMap = new int[this.storageColumns.length];
        block4: for (int j = 0; j < this.projection.length; ++j) {
            for (int i3 = 0; i3 < this.storageColumns.length; ++i3) {
                if (!this.storageColumns[i3].getColName().equals(this.projection[j].getColName())) continue;
                this.isRequired[i3] = true;
                this.isProjectionRequired[i3] = true;
                this.projectionMap[i3] = j;
                continue block4;
            }
        }
        if (null != this.model.getFilterExpressionResolverTree()) {
            this.initializeFilter();
        } else if (this.projection.length == 0) {
            this.skipScanData = true;
        }
    }

    private void initializeFilter() {
        List wrapperColumnSchemaList = CarbonUtil.getColumnSchemaList((List)this.carbonTable.getDimensionByTableName(this.carbonTable.getTableName()), (List)this.carbonTable.getMeasureByTableName(this.carbonTable.getTableName()));
        int[] dimLensWithComplex = new int[wrapperColumnSchemaList.size()];
        for (int i = 0; i < dimLensWithComplex.length; ++i) {
            dimLensWithComplex[i] = Integer.MAX_VALUE;
        }
        int[] dictionaryColumnCardinality = CarbonUtil.getFormattedCardinality((int[])dimLensWithComplex, (List)wrapperColumnSchemaList);
        SegmentProperties segmentProperties = new SegmentProperties(wrapperColumnSchemaList, dictionaryColumnCardinality);
        HashMap complexDimensionInfoMap = new HashMap();
        FilterResolverIntf resolverIntf = this.model.getFilterExpressionResolverTree();
        this.filter = FilterUtil.getFilterExecuterTree((FilterResolverIntf)resolverIntf, (SegmentProperties)segmentProperties, complexDimensionInfoMap);
        FilterUtil.updateIndexOfColumnExpression((Expression)resolverIntf.getFilterExpression(), (int)this.carbonTable.getDimensionOrdinalMax());
    }

    private byte[] getSyncMarker(String filePath) throws IOException {
        CarbonHeaderReader headerReader = new CarbonHeaderReader(filePath);
        FileHeader header = headerReader.readHeader();
        this.compressorName = header.isSetCompressor_name() ? header.getCompressor_name() : CompressorFactory.NativeSupportedCompressor.SNAPPY.getName();
        return header.getSync_marker();
    }

    protected void initializeAtFirstRow() throws IOException {
        this.filterValues = new Object[this.carbonTable.getDimensionOrdinalMax() + this.measureCount];
        this.filterRow = new RowImpl();
        this.filterRow.setValues(this.filterValues);
        this.outputValues = new Object[this.projection.length];
        Path file = this.fileSplit.getPath();
        byte[] syncMarker = this.getSyncMarker(file.toString());
        FileSystem fs = file.getFileSystem(this.hadoopConf);
        int bufferSize = Integer.parseInt(this.hadoopConf.get("carbon.stream.read.buffer.size", "65536"));
        FSDataInputStream fileIn = fs.open(file, bufferSize);
        fileIn.seek(this.fileSplit.getStart());
        this.input = new StreamBlockletReader(syncMarker, (InputStream)fileIn, this.fileSplit.getLength(), this.fileSplit.getStart() == 0L, this.compressorName);
        this.cacheProvider = CacheProvider.getInstance();
        this.cache = this.cacheProvider.createCache(CacheType.FORWARD_DICTIONARY);
        this.queryTypes = CarbonStreamInputFormat.getComplexDimensions(this.carbonTable, this.storageColumns, this.cache);
    }

    protected boolean nextRow() throws IOException {
        try {
            boolean hasNext;
            boolean scanMore = false;
            do {
                if (hasNext = this.input.hasNext()) {
                    if (this.skipScanData) {
                        this.input.nextRow();
                        scanMore = false;
                        continue;
                    }
                    if (this.useRawRow) {
                        this.readRawRowFromStream();
                    } else {
                        this.readRowFromStream();
                    }
                    if (null != this.filter) {
                        scanMore = !this.filter.applyFilter(this.filterRow, this.carbonTable.getDimensionOrdinalMax());
                        continue;
                    }
                    scanMore = false;
                    continue;
                }
                if (this.input.nextBlocklet()) {
                    BlockletHeader header = this.input.readBlockletHeader();
                    if (this.isScanRequired(header)) {
                        if (this.skipScanData) {
                            this.input.skipBlockletData(false);
                        } else {
                            this.input.readBlockletData(header);
                        }
                    } else {
                        this.input.skipBlockletData(true);
                    }
                    scanMore = true;
                    continue;
                }
                this.isFinished = true;
                scanMore = false;
            } while (scanMore);
            return hasNext;
        }
        catch (FilterUnsupportedException e) {
            throw new IOException("Failed to filter row in detail reader", e);
        }
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        if (this.isFirstRow) {
            this.isFirstRow = false;
            this.initializeAtFirstRow();
        }
        if (this.isFinished) {
            return false;
        }
        return this.nextRow();
    }

    public Void getCurrentKey() throws IOException, InterruptedException {
        return null;
    }

    public Object getCurrentValue() throws IOException, InterruptedException {
        return this.outputValues;
    }

    protected boolean isScanRequired(BlockletHeader header) {
        org.apache.carbondata.core.metadata.blocklet.index.BlockletMinMaxIndex minMaxIndex;
        if (this.filter != null && header.getBlocklet_index() != null && (minMaxIndex = CarbonMetadataUtil.convertExternalMinMaxIndex((BlockletMinMaxIndex)header.getBlocklet_index().getMin_max_index())) != null) {
            BitSet bitSet = this.filter.isScanRequired(minMaxIndex.getMaxValues(), minMaxIndex.getMinValues(), minMaxIndex.getIsMinMaxSet());
            return !bitSet.isEmpty();
        }
        return true;
    }

    protected void readRowFromStream() {
        byte[] b;
        int v;
        int colCount;
        this.input.nextRow();
        short nullLen = this.input.readShort();
        BitSet nullBitSet = this.allNonNull;
        if (nullLen > 0) {
            nullBitSet = BitSet.valueOf(this.input.readBytes(nullLen));
        }
        for (colCount = 0; colCount < this.isNoDictColumn.length; ++colCount) {
            if (nullBitSet.get(colCount)) {
                if (this.isFilterRequired[colCount]) {
                    this.filterValues[this.filterMap[colCount]] = CarbonCommonConstants.MEMBER_DEFAULT_VAL_ARRAY;
                }
                if (!this.isProjectionRequired[colCount]) continue;
                this.outputValues[this.projectionMap[colCount]] = null;
                continue;
            }
            if (this.isNoDictColumn[colCount]) {
                v = 0;
                v = this.dimensionsIsVarcharTypeMap[colCount] ? this.input.readInt() : (int)this.input.readShort();
                if (this.isRequired[colCount]) {
                    b = this.input.readBytes(v);
                    if (this.isFilterRequired[colCount]) {
                        this.filterValues[this.filterMap[colCount]] = b;
                    }
                    if (!this.isProjectionRequired[colCount]) continue;
                    this.outputValues[this.projectionMap[colCount]] = DataTypeUtil.getDataBasedOnDataTypeForNoDictionaryColumn((byte[])b, (DataType)this.storageColumns[colCount].getDataType());
                    continue;
                }
                this.input.skipBytes(v);
                continue;
            }
            if (null != this.directDictionaryGenerators[colCount]) {
                if (this.isRequired[colCount]) {
                    if (this.isFilterRequired[colCount]) {
                        this.filterValues[this.filterMap[colCount]] = this.input.copy(4);
                    }
                    if (this.isProjectionRequired[colCount]) {
                        this.outputValues[this.projectionMap[colCount]] = this.directDictionaryGenerators[colCount].getValueFromSurrogate(this.input.readInt());
                        continue;
                    }
                    this.input.skipBytes(4);
                    continue;
                }
                this.input.skipBytes(4);
                continue;
            }
            if (this.isRequired[colCount]) {
                if (this.isFilterRequired[colCount]) {
                    this.filterValues[this.filterMap[colCount]] = this.input.copy(4);
                }
                if (this.isProjectionRequired[colCount]) {
                    this.outputValues[this.projectionMap[colCount]] = this.input.readInt();
                    continue;
                }
                this.input.skipBytes(4);
                continue;
            }
            this.input.skipBytes(4);
        }
        while (colCount < this.dimensionCount) {
            if (nullBitSet.get(colCount)) {
                if (this.isFilterRequired[colCount]) {
                    this.filterValues[this.filterMap[colCount]] = null;
                }
                if (this.isProjectionRequired[colCount]) {
                    this.outputValues[this.projectionMap[colCount]] = null;
                }
            } else {
                v = this.input.readShort();
                if (this.isRequired[colCount]) {
                    b = this.input.readBytes(v);
                    if (this.isFilterRequired[colCount]) {
                        this.filterValues[this.filterMap[colCount]] = b;
                    }
                    if (this.isProjectionRequired[colCount]) {
                        this.outputValues[this.projectionMap[colCount]] = this.queryTypes[colCount].getDataBasedOnDataType(ByteBuffer.wrap(b));
                    }
                } else {
                    this.input.skipBytes(v);
                }
            }
            ++colCount;
        }
        int msrCount = 0;
        while (msrCount < this.measureCount) {
            if (nullBitSet.get(colCount)) {
                if (this.isFilterRequired[colCount]) {
                    this.filterValues[this.filterMap[colCount]] = null;
                }
                if (this.isProjectionRequired[colCount]) {
                    this.outputValues[this.projectionMap[colCount]] = null;
                }
            } else {
                DataType dataType = this.measureDataTypes[msrCount];
                if (dataType == DataTypes.BOOLEAN) {
                    if (this.isRequired[colCount]) {
                        boolean v2 = this.input.readBoolean();
                        if (this.isFilterRequired[colCount]) {
                            this.filterValues[this.filterMap[colCount]] = v2;
                        }
                        if (this.isProjectionRequired[colCount]) {
                            this.outputValues[this.projectionMap[colCount]] = v2;
                        }
                    } else {
                        this.input.skipBytes(1);
                    }
                } else if (dataType == DataTypes.SHORT) {
                    if (this.isRequired[colCount]) {
                        short v3 = this.input.readShort();
                        if (this.isFilterRequired[colCount]) {
                            this.filterValues[this.filterMap[colCount]] = v3;
                        }
                        if (this.isProjectionRequired[colCount]) {
                            this.outputValues[this.projectionMap[colCount]] = v3;
                        }
                    } else {
                        this.input.skipBytes(2);
                    }
                } else if (dataType == DataTypes.INT) {
                    if (this.isRequired[colCount]) {
                        int v4 = this.input.readInt();
                        if (this.isFilterRequired[colCount]) {
                            this.filterValues[this.filterMap[colCount]] = v4;
                        }
                        if (this.isProjectionRequired[colCount]) {
                            this.outputValues[this.projectionMap[colCount]] = v4;
                        }
                    } else {
                        this.input.skipBytes(4);
                    }
                } else if (dataType == DataTypes.LONG) {
                    if (this.isRequired[colCount]) {
                        long v5 = this.input.readLong();
                        if (this.isFilterRequired[colCount]) {
                            this.filterValues[this.filterMap[colCount]] = v5;
                        }
                        if (this.isProjectionRequired[colCount]) {
                            this.outputValues[this.projectionMap[colCount]] = v5;
                        }
                    } else {
                        this.input.skipBytes(8);
                    }
                } else if (dataType == DataTypes.DOUBLE) {
                    if (this.isRequired[colCount]) {
                        double v6 = this.input.readDouble();
                        if (this.isFilterRequired[colCount]) {
                            this.filterValues[this.filterMap[colCount]] = v6;
                        }
                        if (this.isProjectionRequired[colCount]) {
                            this.outputValues[this.projectionMap[colCount]] = v6;
                        }
                    } else {
                        this.input.skipBytes(8);
                    }
                } else if (DataTypes.isDecimal((DataType)dataType)) {
                    short len = this.input.readShort();
                    if (this.isRequired[colCount]) {
                        BigDecimal v7 = DataTypeUtil.byteToBigDecimal((byte[])this.input.readBytes(len));
                        if (this.isFilterRequired[colCount]) {
                            this.filterValues[this.filterMap[colCount]] = v7;
                        }
                        if (this.isProjectionRequired[colCount]) {
                            this.outputValues[this.projectionMap[colCount]] = DataTypeUtil.getDataTypeConverter().convertFromBigDecimalToDecimal((Object)v7);
                        }
                    } else {
                        this.input.skipBytes(len);
                    }
                }
            }
            ++msrCount;
            ++colCount;
        }
    }

    private void readRawRowFromStream() {
        int v;
        int colCount;
        this.input.nextRow();
        short nullLen = this.input.readShort();
        BitSet nullBitSet = this.allNonNull;
        if (nullLen > 0) {
            nullBitSet = BitSet.valueOf(this.input.readBytes(nullLen));
        }
        for (colCount = 0; colCount < this.isNoDictColumn.length; ++colCount) {
            if (nullBitSet.get(colCount)) {
                this.outputValues[colCount] = CarbonCommonConstants.MEMBER_DEFAULT_VAL_ARRAY;
                continue;
            }
            if (this.isNoDictColumn[colCount]) {
                v = 0;
                v = this.dimensionsIsVarcharTypeMap[colCount] ? this.input.readInt() : (int)this.input.readShort();
                this.outputValues[colCount] = this.input.readBytes(v);
                continue;
            }
            this.outputValues[colCount] = this.input.readInt();
        }
        while (colCount < this.dimensionCount) {
            if (nullBitSet.get(colCount)) {
                this.outputValues[colCount] = null;
            } else {
                v = this.input.readShort();
                this.outputValues[colCount] = this.input.readBytes(v);
            }
            ++colCount;
        }
        int msrCount = 0;
        while (msrCount < this.measureCount) {
            if (nullBitSet.get(colCount)) {
                this.outputValues[colCount] = null;
            } else {
                DataType dataType = this.measureDataTypes[msrCount];
                if (dataType == DataTypes.BOOLEAN) {
                    this.outputValues[colCount] = this.input.readBoolean();
                } else if (dataType == DataTypes.SHORT) {
                    this.outputValues[colCount] = this.input.readShort();
                } else if (dataType == DataTypes.INT) {
                    this.outputValues[colCount] = this.input.readInt();
                } else if (dataType == DataTypes.LONG) {
                    this.outputValues[colCount] = this.input.readLong();
                } else if (dataType == DataTypes.DOUBLE) {
                    this.outputValues[colCount] = this.input.readDouble();
                } else if (DataTypes.isDecimal((DataType)dataType)) {
                    short len = this.input.readShort();
                    this.outputValues[colCount] = DataTypeUtil.byteToBigDecimal((byte[])this.input.readBytes(len));
                }
            }
            ++msrCount;
            ++colCount;
        }
    }

    public float getProgress() {
        return 0.0f;
    }

    public void close() throws IOException {
        if (null != this.input) {
            this.input.close();
        }
    }
}

