/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hadoop.readsupport.impl;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.carbondata.core.datastore.row.CarbonRow;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.hadoop.readsupport.impl.DictionaryDecodeReadSupport;

public class CarbonRowReadSupport
extends DictionaryDecodeReadSupport<CarbonRow> {
    @Override
    public CarbonRow readRow(Object[] data) {
        assert (data.length == this.dictionaries.length);
        for (int i = 0; i < this.dictionaries.length; ++i) {
            if (this.dictionaries[i] != null) {
                data[i] = this.dictionaries[i].getDictionaryValueForKey(((Integer)data[i]).intValue());
            }
            if (this.dataTypes[i] == DataTypes.DATE) {
                Calendar c = Calendar.getInstance();
                c.setTime(new Date(0L));
                c.add(6, (Integer)data[i]);
                data[i] = new Date(c.getTime().getTime());
                continue;
            }
            if (this.dataTypes[i] != DataTypes.TIMESTAMP) continue;
            data[i] = new Timestamp((Long)data[i] / 1000L);
        }
        return new CarbonRow(data);
    }
}

