/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hadoop.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datamap.Segment;
import org.apache.carbondata.core.datamap.status.DataMapStatusManager;
import org.apache.carbondata.core.datastore.filesystem.CarbonFile;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.locks.CarbonLockFactory;
import org.apache.carbondata.core.locks.ICarbonLock;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.SegmentFileStore;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.mutate.CarbonUpdateUtil;
import org.apache.carbondata.core.statusmanager.LoadMetadataDetails;
import org.apache.carbondata.core.statusmanager.SegmentStatus;
import org.apache.carbondata.core.statusmanager.SegmentStatusManager;
import org.apache.carbondata.core.util.CarbonSessionInfo;
import org.apache.carbondata.core.util.ThreadLocalSessionInfo;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.carbondata.events.Event;
import org.apache.carbondata.events.OperationContext;
import org.apache.carbondata.events.OperationListenerBus;
import org.apache.carbondata.hadoop.api.CarbonTableOutputFormat;
import org.apache.carbondata.processing.loading.events.LoadEvents;
import org.apache.carbondata.processing.loading.model.CarbonLoadModel;
import org.apache.carbondata.processing.util.CarbonLoaderUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;
import org.apache.log4j.Logger;

public class CarbonOutputCommitter
extends FileOutputCommitter {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)CarbonOutputCommitter.class.getName());
    private ICarbonLock segmentLock;

    public CarbonOutputCommitter(Path outputPath, TaskAttemptContext context) throws IOException {
        super(outputPath, context);
    }

    public void setupJob(JobContext context) throws IOException {
        super.setupJob(context);
        boolean overwriteSet = CarbonTableOutputFormat.isOverwriteSet(context.getConfiguration());
        CarbonLoadModel loadModel = CarbonTableOutputFormat.getLoadModel(context.getConfiguration());
        if (loadModel.getSegmentId() == null) {
            CarbonLoaderUtil.readAndUpdateLoadProgressInTableMeta((CarbonLoadModel)loadModel, (boolean)overwriteSet);
        }
        this.segmentLock = CarbonLockFactory.getCarbonLockObj((AbsoluteTableIdentifier)loadModel.getCarbonDataLoadSchema().getCarbonTable().getAbsoluteTableIdentifier(), (String)(CarbonTablePath.addSegmentPrefix((String)loadModel.getSegmentId()) + ".lock"));
        if (!this.segmentLock.lockWithRetries()) {
            throw new RuntimeException("Already segment is locked for loading, not supposed happen");
        }
        CarbonTableOutputFormat.setLoadModel(context.getConfiguration(), loadModel);
    }

    public void setupTask(TaskAttemptContext context) throws IOException {
        super.setupTask(context);
    }

    public void commitJob(JobContext context) throws IOException {
        try {
            super.commitJob(context);
        }
        catch (IOException e) {
            LOGGER.warn((Object)e.getMessage());
        }
        boolean overwriteSet = CarbonTableOutputFormat.isOverwriteSet(context.getConfiguration());
        CarbonLoadModel loadModel = CarbonTableOutputFormat.getLoadModel(context.getConfiguration());
        LoadMetadataDetails newMetaEntry = loadModel.getCurrentLoadMetadataDetail();
        String readPath = CarbonTablePath.getSegmentFilesLocation((String)loadModel.getTablePath()) + "/" + loadModel.getSegmentId() + "_" + loadModel.getFactTimeStamp() + ".tmp";
        String segmentFileName = SegmentFileStore.genSegmentFileName((String)loadModel.getSegmentId(), (String)String.valueOf(loadModel.getFactTimeStamp()));
        SegmentFileStore.SegmentFile segmentFile = SegmentFileStore.mergeSegmentFiles((String)readPath, (String)segmentFileName, (String)CarbonTablePath.getSegmentFilesLocation((String)loadModel.getTablePath()));
        if (segmentFile != null) {
            if (null == newMetaEntry) {
                throw new RuntimeException("Internal Error");
            }
            SegmentFileStore.moveFromTempFolder((SegmentFileStore.SegmentFile)segmentFile, (String)(loadModel.getSegmentId() + "_" + loadModel.getFactTimeStamp() + ".tmp"), (String)loadModel.getTablePath());
            newMetaEntry.setSegmentFile(segmentFileName + ".segment");
        }
        OperationContext operationContext = (OperationContext)this.getOperationContext();
        CarbonTable carbonTable = loadModel.getCarbonDataLoadSchema().getCarbonTable();
        String uuid = "";
        if (loadModel.getCarbonDataLoadSchema().getCarbonTable().isChildDataMap() && operationContext != null) {
            uuid = operationContext.getProperty("uuid").toString();
        }
        SegmentFileStore.updateSegmentFile((CarbonTable)carbonTable, (String)loadModel.getSegmentId(), (String)(segmentFileName + ".segment"), (String)carbonTable.getCarbonTableIdentifier().getTableId(), (SegmentFileStore)new SegmentFileStore(carbonTable.getTablePath(), segmentFileName + ".segment"));
        CarbonLoaderUtil.populateNewLoadMetaEntry((LoadMetadataDetails)newMetaEntry, (SegmentStatus)SegmentStatus.SUCCESS, (long)loadModel.getFactTimeStamp(), (boolean)true);
        long segmentSize = CarbonLoaderUtil.addDataIndexSizeIntoMetaEntry((LoadMetadataDetails)newMetaEntry, (String)loadModel.getSegmentId(), (CarbonTable)carbonTable);
        if (segmentSize > 0L || overwriteSet) {
            if (operationContext != null) {
                operationContext.setProperty("current.segmentfile", (Object)newMetaEntry.getSegmentFile());
                LoadEvents.LoadTablePreStatusUpdateEvent event = new LoadEvents.LoadTablePreStatusUpdateEvent(carbonTable.getCarbonTableIdentifier(), loadModel);
                try {
                    OperationListenerBus.getInstance().fireEvent((Event)event, operationContext);
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            String uniqueId = null;
            if (overwriteSet) {
                if (!loadModel.isCarbonTransactionalTable()) {
                    CarbonLoaderUtil.deleteNonTransactionalTableForInsertOverwrite((CarbonLoadModel)loadModel);
                } else {
                    if (segmentSize == 0L) {
                        newMetaEntry.setSegmentStatus(SegmentStatus.MARKED_FOR_DELETE);
                    }
                    uniqueId = this.overwritePartitions(loadModel, newMetaEntry, uuid);
                }
            } else {
                CarbonLoaderUtil.recordNewLoadMetadata((LoadMetadataDetails)newMetaEntry, (CarbonLoadModel)loadModel, (boolean)false, (boolean)false, (String)uuid);
            }
            DataMapStatusManager.disableAllLazyDataMaps((CarbonTable)carbonTable);
            if (operationContext != null) {
                LoadEvents.LoadTablePostStatusUpdateEvent postStatusUpdateEvent = new LoadEvents.LoadTablePostStatusUpdateEvent(loadModel);
                try {
                    OperationListenerBus.getInstance().fireEvent((Event)postStatusUpdateEvent, operationContext);
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            String updateTime = context.getConfiguration().get("mapreduce.carbontable.update.timestamp", null);
            String segmentsToBeDeleted = context.getConfiguration().get("mapreduce.carbontable.segments.to.be.removed", "");
            List segmentDeleteList = Segment.toSegmentList((String[])segmentsToBeDeleted.split(","), null);
            HashSet segmentSet = new HashSet(new SegmentStatusManager(carbonTable.getAbsoluteTableIdentifier(), context.getConfiguration()).getValidAndInvalidSegments(Boolean.valueOf(carbonTable.isChildTable())).getValidSegments());
            if (updateTime != null) {
                CarbonUpdateUtil.updateTableMetadataStatus(segmentSet, (CarbonTable)carbonTable, (String)updateTime, (boolean)true, (List)segmentDeleteList);
            } else if (uniqueId != null) {
                CarbonUpdateUtil.updateTableMetadataStatus(segmentSet, (CarbonTable)carbonTable, (String)uniqueId, (boolean)true, (List)segmentDeleteList);
            }
        } else {
            CarbonLoaderUtil.updateTableStatusForFailure((CarbonLoadModel)loadModel);
        }
        if (this.segmentLock != null) {
            this.segmentLock.unlock();
        }
    }

    private String overwritePartitions(CarbonLoadModel loadModel, LoadMetadataDetails newMetaEntry, String uuid) throws IOException {
        CarbonTable table = loadModel.getCarbonDataLoadSchema().getCarbonTable();
        SegmentFileStore fileStore = new SegmentFileStore(loadModel.getTablePath(), loadModel.getSegmentId() + "_" + loadModel.getFactTimeStamp() + ".segment");
        List partitionSpecs = fileStore.getPartitionSpecs();
        if (partitionSpecs != null && partitionSpecs.size() > 0) {
            List validSegments = new SegmentStatusManager(table.getAbsoluteTableIdentifier()).getValidAndInvalidSegments(Boolean.valueOf(table.isChildTable())).getValidSegments();
            String uniqueId = String.valueOf(System.currentTimeMillis());
            ArrayList tobeUpdatedSegs = new ArrayList();
            ArrayList tobeDeletedSegs = new ArrayList();
            for (Segment segment : validSegments) {
                new SegmentFileStore(table.getTablePath(), segment.getSegmentFileName()).dropPartitions(segment, partitionSpecs, uniqueId, tobeDeletedSegs, tobeUpdatedSegs);
            }
            newMetaEntry.setUpdateStatusFileName(uniqueId);
            CarbonLoaderUtil.recordNewLoadMetadata((LoadMetadataDetails)newMetaEntry, (CarbonLoadModel)loadModel, (boolean)false, (boolean)false, (String)uuid, (List)Segment.toSegmentList(tobeDeletedSegs, null), (List)Segment.toSegmentList(tobeUpdatedSegs, null));
            return uniqueId;
        }
        return null;
    }

    private Object getOperationContext() {
        CarbonSessionInfo carbonSessionInfo = ThreadLocalSessionInfo.getCarbonSessionInfo();
        if (carbonSessionInfo != null) {
            return carbonSessionInfo.getThreadParams().getExtraInfo("partition.operationcontext");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortJob(JobContext context, JobStatus.State state) throws IOException {
        try {
            CarbonFile segmentFilePath;
            CarbonFile segTmpFolder;
            String readPath;
            super.abortJob(context, state);
            CarbonLoadModel loadModel = CarbonTableOutputFormat.getLoadModel(context.getConfiguration());
            CarbonLoaderUtil.updateTableStatusForFailure((CarbonLoadModel)loadModel);
            String segmentFileName = loadModel.getSegmentId() + "_" + loadModel.getFactTimeStamp();
            LoadMetadataDetails metadataDetail = loadModel.getCurrentLoadMetadataDetail();
            if (metadataDetail != null && !metadataDetail.getSegmentStatus().equals((Object)SegmentStatus.SUCCESS) && FileFactory.getCarbonFile((String)(readPath = CarbonTablePath.getSegmentFilesLocation((String)loadModel.getTablePath()) + "/" + segmentFileName + ".segment")).exists()) {
                metadataDetail.setSegmentFile(segmentFileName + ".segment");
            }
            if ((segTmpFolder = FileFactory.getCarbonFile((String)(CarbonTablePath.getSegmentFilesLocation((String)loadModel.getTablePath()) + "/" + segmentFileName + ".tmp"))).exists()) {
                FileFactory.deleteAllCarbonFilesOfDir((CarbonFile)segTmpFolder);
            }
            if ((segmentFilePath = FileFactory.getCarbonFile((String)(CarbonTablePath.getSegmentFilesLocation((String)loadModel.getTablePath()) + "/" + segmentFileName + ".segment"))).exists()) {
                SegmentFileStore fileStore = new SegmentFileStore(loadModel.getTablePath(), segmentFileName + ".segment");
                SegmentFileStore.removeTempFolder((Map)fileStore.getLocationMap(), (String)(segmentFileName + ".tmp"), (String)loadModel.getTablePath());
            }
            LOGGER.error((Object)("Loading failed with job status : " + state));
        }
        finally {
            if (this.segmentLock != null) {
                this.segmentLock.unlock();
            }
        }
    }
}

