/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hadoop.api;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datamap.DataMapChooser;
import org.apache.carbondata.core.datamap.DataMapFilter;
import org.apache.carbondata.core.datamap.DataMapJob;
import org.apache.carbondata.core.datamap.DataMapLevel;
import org.apache.carbondata.core.datamap.DataMapStoreManager;
import org.apache.carbondata.core.datamap.DataMapUtil;
import org.apache.carbondata.core.datamap.Segment;
import org.apache.carbondata.core.datamap.TableDataMap;
import org.apache.carbondata.core.datamap.dev.expr.DataMapExprWrapper;
import org.apache.carbondata.core.datamap.dev.expr.DataMapWrapperSimpleInfo;
import org.apache.carbondata.core.exception.InvalidConfigurationException;
import org.apache.carbondata.core.indexstore.ExtendedBlocklet;
import org.apache.carbondata.core.indexstore.PartitionSpec;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.schema.PartitionInfo;
import org.apache.carbondata.core.metadata.schema.SchemaReader;
import org.apache.carbondata.core.metadata.schema.partition.PartitionType;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.TableInfo;
import org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema;
import org.apache.carbondata.core.profiler.ExplainCollector;
import org.apache.carbondata.core.readcommitter.ReadCommittedScope;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.scan.filter.FilterUtil;
import org.apache.carbondata.core.scan.filter.resolver.FilterResolverIntf;
import org.apache.carbondata.core.scan.model.QueryModel;
import org.apache.carbondata.core.scan.model.QueryModelBuilder;
import org.apache.carbondata.core.stats.QueryStatistic;
import org.apache.carbondata.core.stats.QueryStatisticsRecorder;
import org.apache.carbondata.core.util.BlockletDataMapUtil;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.CarbonTimeStatisticsFactory;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.DataTypeConverter;
import org.apache.carbondata.core.util.DataTypeConverterImpl;
import org.apache.carbondata.core.util.ObjectSerializationUtil;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.carbondata.hadoop.CarbonInputSplit;
import org.apache.carbondata.hadoop.CarbonMultiBlockSplit;
import org.apache.carbondata.hadoop.CarbonProjection;
import org.apache.carbondata.hadoop.CarbonRecordReader;
import org.apache.carbondata.hadoop.readsupport.CarbonReadSupport;
import org.apache.carbondata.hadoop.readsupport.impl.DictionaryDecodeReadSupport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.security.Credentials;
import org.apache.log4j.Logger;

public abstract class CarbonInputFormat<T>
extends FileInputFormat<Void, T> {
    public static final String INPUT_SEGMENT_NUMBERS = "mapreduce.input.carboninputformat.segmentnumbers";
    private static final String VALIDATE_INPUT_SEGMENT_IDs = "mapreduce.input.carboninputformat.validsegments";
    private static final String ALTER_PARTITION_ID = "mapreduce.input.carboninputformat.partitionid";
    private static final Logger LOG = LogServiceFactory.getLogService((String)CarbonInputFormat.class.getName());
    private static final String FILTER_PREDICATE = "mapreduce.input.carboninputformat.filter.predicate";
    private static final String COLUMN_PROJECTION = "mapreduce.input.carboninputformat.projection";
    private static final String TABLE_INFO = "mapreduce.input.carboninputformat.tableinfo";
    private static final String CARBON_TRANSACTIONAL_TABLE = "mapreduce.input.carboninputformat.transactional";
    private static final String CARBON_READ_SUPPORT = "mapreduce.input.carboninputformat.readsupport";
    private static final String CARBON_CONVERTER = "mapreduce.input.carboninputformat.converter";
    public static final String DATABASE_NAME = "mapreduce.input.carboninputformat.databaseName";
    public static final String TABLE_NAME = "mapreduce.input.carboninputformat.tableName";
    private static final String PARTITIONS_TO_PRUNE = "mapreduce.input.carboninputformat.partitions.to.prune";
    private static final String FGDATAMAP_PRUNING = "mapreduce.input.carboninputformat.fgdatamap";
    private static final String READ_COMMITTED_SCOPE = "mapreduce.input.carboninputformat.read.committed.scope";
    protected int numSegments = 0;
    protected int numStreamSegments = 0;
    protected int numStreamFiles = 0;
    protected int hitedStreamFiles = 0;
    protected int numBlocks = 0;
    protected List fileLists = null;
    private CarbonTable carbonTable;

    public int getNumSegments() {
        return this.numSegments;
    }

    public int getNumStreamSegments() {
        return this.numStreamSegments;
    }

    public int getNumStreamFiles() {
        return this.numStreamFiles;
    }

    public int getHitedStreamFiles() {
        return this.hitedStreamFiles;
    }

    public int getNumBlocks() {
        return this.numBlocks;
    }

    public void setFileLists(List fileLists) {
        this.fileLists = fileLists;
    }

    public static void setTableInfo(Configuration configuration, TableInfo tableInfo) throws IOException {
        if (null != tableInfo) {
            configuration.set(TABLE_INFO, CarbonUtil.encodeToString((byte[])tableInfo.serialize()));
        }
    }

    protected static TableInfo getTableInfo(Configuration configuration) throws IOException {
        String tableInfoStr = configuration.get(TABLE_INFO);
        if (tableInfoStr == null) {
            return null;
        }
        TableInfo output = new TableInfo();
        output.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(CarbonUtil.decodeStringToBytes((String)tableInfoStr))));
        return output;
    }

    public CarbonTable getOrCreateCarbonTable(Configuration configuration) throws IOException {
        if (this.carbonTable == null) {
            TableInfo tableInfo = CarbonInputFormat.getTableInfo(configuration);
            CarbonTable carbonTable = tableInfo != null ? CarbonTable.buildFromTableInfo((TableInfo)tableInfo) : SchemaReader.readCarbonTableFromStore((AbsoluteTableIdentifier)this.getAbsoluteTableIdentifier(configuration));
            this.carbonTable = carbonTable;
            return carbonTable;
        }
        return this.carbonTable;
    }

    public static void setTablePath(Configuration configuration, String tablePath) {
        configuration.set("mapreduce.input.fileinputformat.inputdir", tablePath);
    }

    public static void setTransactionalTable(Configuration configuration, boolean isTransactionalTable) {
        configuration.set(CARBON_TRANSACTIONAL_TABLE, String.valueOf(isTransactionalTable));
    }

    public static void setPartitionIdList(Configuration configuration, List<String> partitionIds) {
        configuration.set(ALTER_PARTITION_ID, partitionIds.toString());
    }

    public static void setFilterPredicates(Configuration configuration, Expression filterExpression) {
        if (filterExpression == null) {
            return;
        }
        try {
            String filterString = ObjectSerializationUtil.convertObjectToString((Object)filterExpression);
            configuration.set(FILTER_PREDICATE, filterString);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while setting filter expression to Job", e);
        }
    }

    public static void setColumnProjection(Configuration configuration, String[] projectionColumns) {
        Objects.requireNonNull(projectionColumns);
        if (projectionColumns.length < 1) {
            throw new RuntimeException("Projection can't be empty");
        }
        StringBuilder builder = new StringBuilder();
        for (String column : projectionColumns) {
            builder.append(column).append(",");
        }
        String columnString = builder.toString();
        columnString = columnString.substring(0, columnString.length() - 1);
        configuration.set(COLUMN_PROJECTION, columnString);
    }

    public static void setColumnProjection(Configuration configuration, CarbonProjection projection) {
        if (projection == null || projection.isEmpty()) {
            return;
        }
        String[] allColumns = projection.getAllColumns();
        StringBuilder builder = new StringBuilder();
        for (String column : allColumns) {
            builder.append(column).append(",");
        }
        String columnString = builder.toString();
        columnString = columnString.substring(0, columnString.length() - 1);
        configuration.set(COLUMN_PROJECTION, columnString);
    }

    public static String getColumnProjection(Configuration configuration) {
        return configuration.get(COLUMN_PROJECTION);
    }

    public static void setFgDataMapPruning(Configuration configuration, boolean enable) {
        configuration.set(FGDATAMAP_PRUNING, String.valueOf(enable));
    }

    public static boolean isFgDataMapPruningEnable(Configuration configuration) {
        String enable = configuration.get(FGDATAMAP_PRUNING);
        return enable == null || enable.equalsIgnoreCase("true");
    }

    public static void setSegmentsToAccess(Configuration configuration, List<Segment> validSegments) {
        configuration.set(INPUT_SEGMENT_NUMBERS, CarbonUtil.convertToString(validSegments));
    }

    public static void setQuerySegment(Configuration conf, AbsoluteTableIdentifier identifier) {
        String dbName = identifier.getCarbonTableIdentifier().getDatabaseName().toLowerCase();
        String tbName = identifier.getCarbonTableIdentifier().getTableName().toLowerCase();
        CarbonInputFormat.getQuerySegmentToAccess(conf, dbName, tbName);
    }

    public static void setQuerySegment(Configuration conf, String segmentList) {
        if (!segmentList.trim().equals("*")) {
            CarbonInputFormat.setSegmentsToAccess(conf, Segment.toSegmentList((String[])segmentList.split(","), null));
        }
    }

    public static void setValidateSegmentsToAccess(Configuration configuration, Boolean validate) {
        configuration.set(VALIDATE_INPUT_SEGMENT_IDs, validate.toString());
    }

    public static boolean getValidateSegmentsToAccess(Configuration configuration) {
        return configuration.get(VALIDATE_INPUT_SEGMENT_IDs, "true").equalsIgnoreCase("true");
    }

    public static void setPartitionsToPrune(Configuration configuration, List<PartitionSpec> partitions) {
        if (partitions == null) {
            return;
        }
        try {
            String partitionString = ObjectSerializationUtil.convertObjectToString(new ArrayList<PartitionSpec>(partitions));
            configuration.set(PARTITIONS_TO_PRUNE, partitionString);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while setting partition information to Job" + partitions, e);
        }
    }

    public static List<PartitionSpec> getPartitionsToPrune(Configuration configuration) throws IOException {
        String partitionString = configuration.get(PARTITIONS_TO_PRUNE);
        if (partitionString != null) {
            return (List)ObjectSerializationUtil.convertStringToObject((String)partitionString);
        }
        return null;
    }

    public AbsoluteTableIdentifier getAbsoluteTableIdentifier(Configuration configuration) throws IOException {
        String tablePath = configuration.get("mapreduce.input.fileinputformat.inputdir", "");
        try {
            return AbsoluteTableIdentifier.from((String)tablePath, (String)CarbonInputFormat.getDatabaseName(configuration), (String)CarbonInputFormat.getTableName(configuration));
        }
        catch (InvalidConfigurationException e) {
            throw new IOException(e);
        }
    }

    public static void setReadCommittedScope(Configuration configuration, ReadCommittedScope committedScope) {
        if (committedScope == null) {
            return;
        }
        try {
            String subFoldersString = ObjectSerializationUtil.convertObjectToString((Object)committedScope);
            configuration.set(READ_COMMITTED_SCOPE, subFoldersString);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while setting committedScope information to Job" + committedScope, e);
        }
    }

    public static ReadCommittedScope getReadCommittedScope(Configuration configuration) throws IOException {
        String subFoldersString = configuration.get(READ_COMMITTED_SCOPE);
        if (subFoldersString != null) {
            return (ReadCommittedScope)ObjectSerializationUtil.convertStringToObject((String)subFoldersString);
        }
        return null;
    }

    public abstract List<InputSplit> getSplits(JobContext var1) throws IOException;

    List<ExtendedBlocklet> getDistributedSplit(CarbonTable table, FilterResolverIntf filterResolverIntf, List<PartitionSpec> partitionNames, List<Segment> validSegments, List<Segment> invalidSegments, List<String> segmentsToBeRefreshed) throws IOException {
        try {
            DataMapJob dataMapJob = (DataMapJob)DataMapUtil.createDataMapJob((String)"org.apache.carbondata.indexserver.DistributedDataMapJob");
            if (dataMapJob == null) {
                throw new ExceptionInInitializerError("Unable to create DistributedDataMapJob");
            }
            return DataMapUtil.executeDataMapJob((CarbonTable)table, (FilterResolverIntf)filterResolverIntf, (DataMapJob)dataMapJob, partitionNames, validSegments, invalidSegments, null, segmentsToBeRefreshed);
        }
        catch (Exception e) {
            if (CarbonProperties.getInstance().isFallBackDisabled()) {
                throw e;
            }
            LOG.error((Object)"Exception occurred while getting splits using index server. Initiating Fall back to embedded mode", (Throwable)e);
            return DataMapUtil.executeDataMapJob((CarbonTable)table, (FilterResolverIntf)filterResolverIntf, (DataMapJob)DataMapUtil.getEmbeddedJob(), partitionNames, validSegments, invalidSegments, null, (Boolean)true, segmentsToBeRefreshed);
        }
    }

    protected Expression getFilterPredicates(Configuration configuration) {
        try {
            String filterExprString = configuration.get(FILTER_PREDICATE);
            if (filterExprString == null) {
                return null;
            }
            Object filter = ObjectSerializationUtil.convertStringToObject((String)filterExprString);
            return (Expression)filter;
        }
        catch (IOException e) {
            throw new RuntimeException("Error while reading filter expression", e);
        }
    }

    protected List<CarbonInputSplit> getDataBlocksOfSegment(JobContext job, CarbonTable carbonTable, Expression expression, BitSet matchedPartitions, List<Segment> segmentIds, PartitionInfo partitionInfo, List<Integer> oldPartitionIdList, List<Segment> invalidSegments, List<String> segmentsToBeRefreshed) throws IOException {
        QueryStatisticsRecorder recorder = CarbonTimeStatisticsFactory.createDriverRecorder();
        QueryStatistic statistic = new QueryStatistic();
        TokenCache.obtainTokensForNamenodes((Credentials)job.getCredentials(), (Path[])new Path[]{new Path(carbonTable.getTablePath())}, (Configuration)job.getConfiguration());
        List<ExtendedBlocklet> prunedBlocklets = this.getPrunedBlocklets(job, carbonTable, expression, segmentIds, invalidSegments, segmentsToBeRefreshed);
        ArrayList<CarbonInputSplit> resultFilteredBlocks = new ArrayList<CarbonInputSplit>();
        int partitionIndex = 0;
        List partitionIdList = new ArrayList();
        if (partitionInfo != null && partitionInfo.getPartitionType() != PartitionType.NATIVE_HIVE) {
            partitionIdList = partitionInfo.getPartitionIds();
        }
        for (ExtendedBlocklet blocklet : prunedBlocklets) {
            if (partitionInfo != null && partitionInfo.getPartitionType() != PartitionType.NATIVE_HIVE) {
                long partitionId = Long.parseLong(CarbonTablePath.DataFileUtil.getTaskIdFromTaskNo((String)CarbonTablePath.DataFileUtil.getTaskNo((String)blocklet.getPath())));
                partitionIndex = oldPartitionIdList != null ? oldPartitionIdList.indexOf((int)partitionId) : partitionIdList.indexOf((int)partitionId);
            }
            if (partitionIndex == -1 || matchedPartitions != null && !matchedPartitions.get(partitionIndex)) continue;
            resultFilteredBlocks.add(blocklet.getInputSplit());
        }
        statistic.addStatistics("Time taken to load the Block(s) In Driver Side with Block count ", System.currentTimeMillis());
        recorder.recordStatisticsForDriver(statistic, job.getConfiguration().get("query.id"));
        return resultFilteredBlocks;
    }

    private int getBlockCount(List<ExtendedBlocklet> blocklets) {
        HashSet<String> filepaths = new HashSet<String>();
        for (ExtendedBlocklet blocklet : blocklets) {
            filepaths.add(blocklet.getPath());
        }
        return filepaths.size();
    }

    private List<ExtendedBlocklet> getPrunedBlocklets(JobContext job, CarbonTable carbonTable, Expression expression, List<Segment> segmentIds, List<Segment> invalidSegments, List<String> segmentsToBeRefreshed) throws IOException {
        ExplainCollector.addPruningInfo((String)carbonTable.getTableName());
        DataMapFilter filter = new DataMapFilter(carbonTable, expression);
        ExplainCollector.setFilterStatement((String)(expression == null ? "none" : expression.getStatement()));
        boolean distributedCG = Boolean.parseBoolean(CarbonProperties.getInstance().getProperty("carbon.enable.distributed.datamap", "false"));
        DataMapJob dataMapJob = DataMapUtil.getDataMapJob((Configuration)job.getConfiguration());
        List<PartitionSpec> partitionsToPrune = CarbonInputFormat.getPartitionsToPrune(job.getConfiguration());
        TableDataMap defaultDataMap = DataMapStoreManager.getInstance().getDefaultDataMap(carbonTable);
        List<ExtendedBlocklet> prunedBlocklets = null;
        LOG.info((Object)"Started block pruning ...");
        boolean isDistributedPruningEnabled = CarbonProperties.getInstance().isDistributedPruningEnabled(carbonTable.getDatabaseName(), carbonTable.getTableName());
        if (isDistributedPruningEnabled) {
            try {
                prunedBlocklets = this.getDistributedSplit(carbonTable, filter.getResolver(), partitionsToPrune, segmentIds, invalidSegments, segmentsToBeRefreshed);
            }
            catch (Exception e) {
                if (CarbonProperties.getInstance().isFallBackDisabled()) {
                    throw e;
                }
                prunedBlocklets = defaultDataMap.prune(segmentIds, filter, partitionsToPrune);
            }
        } else {
            DataMapExprWrapper fgDataMapExprWrapper;
            prunedBlocklets = defaultDataMap.prune(segmentIds, filter, partitionsToPrune);
            if (ExplainCollector.enabled()) {
                ExplainCollector.setDefaultDataMapPruningBlockHit((int)this.getBlockCount(prunedBlocklets));
            }
            if (prunedBlocklets.size() == 0) {
                return prunedBlocklets;
            }
            DataMapChooser chooser = new DataMapChooser(this.getOrCreateCarbonTable(job.getConfiguration()));
            DataMapExprWrapper cgDataMapExprWrapper = chooser.chooseCGDataMap(filter.getResolver());
            if (cgDataMapExprWrapper != null) {
                DataMapUtil.pruneSegments(segmentIds, (List)prunedBlocklets);
                List cgPrunedBlocklets = distributedCG && dataMapJob != null ? DataMapUtil.executeDataMapJob((CarbonTable)carbonTable, (FilterResolverIntf)filter.getResolver(), (DataMapJob)dataMapJob, partitionsToPrune, segmentIds, invalidSegments, (DataMapLevel)DataMapLevel.CG, (Boolean)true, new ArrayList()) : cgDataMapExprWrapper.prune(segmentIds, partitionsToPrune);
                prunedBlocklets = this.intersectFilteredBlocklets(carbonTable, prunedBlocklets, cgPrunedBlocklets);
                if (ExplainCollector.enabled()) {
                    ExplainCollector.recordCGDataMapPruning((DataMapWrapperSimpleInfo)DataMapWrapperSimpleInfo.fromDataMapWrapper((DataMapExprWrapper)cgDataMapExprWrapper), (int)prunedBlocklets.size(), (int)this.getBlockCount(prunedBlocklets));
                }
            }
            if (prunedBlocklets.size() == 0) {
                return prunedBlocklets;
            }
            if (CarbonInputFormat.isFgDataMapPruningEnable(job.getConfiguration()) && dataMapJob != null && (fgDataMapExprWrapper = chooser.chooseFGDataMap(filter.getResolver())) != null) {
                DataMapUtil.pruneSegments(segmentIds, prunedBlocklets);
                List fgPrunedBlocklets = DataMapUtil.executeDataMapJob((CarbonTable)carbonTable, (FilterResolverIntf)filter.getResolver(), (DataMapJob)dataMapJob, partitionsToPrune, segmentIds, invalidSegments, (DataMapLevel)fgDataMapExprWrapper.getDataMapLevel(), (Boolean)true, new ArrayList());
                prunedBlocklets = this.intersectFilteredBlocklets(carbonTable, prunedBlocklets, fgPrunedBlocklets);
                ExplainCollector.recordFGDataMapPruning((DataMapWrapperSimpleInfo)DataMapWrapperSimpleInfo.fromDataMapWrapper((DataMapExprWrapper)fgDataMapExprWrapper), (int)prunedBlocklets.size(), (int)this.getBlockCount(prunedBlocklets));
            }
        }
        LOG.info((Object)"Finished block pruning ...");
        return prunedBlocklets;
    }

    private List<ExtendedBlocklet> intersectFilteredBlocklets(CarbonTable carbonTable, List<ExtendedBlocklet> previousDataMapPrunedBlocklets, List<ExtendedBlocklet> otherDataMapPrunedBlocklets) {
        ArrayList<ExtendedBlocklet> prunedBlocklets = null;
        if (BlockletDataMapUtil.isCacheLevelBlock((CarbonTable)carbonTable)) {
            prunedBlocklets = new ArrayList();
            for (ExtendedBlocklet otherBlocklet : otherDataMapPrunedBlocklets) {
                if (!previousDataMapPrunedBlocklets.contains(otherBlocklet)) continue;
                prunedBlocklets.add(otherBlocklet);
            }
        } else {
            prunedBlocklets = (List)CollectionUtils.intersection(otherDataMapPrunedBlocklets, previousDataMapPrunedBlocklets);
        }
        return prunedBlocklets;
    }

    static List<InputSplit> convertToCarbonInputSplit(List<ExtendedBlocklet> extendedBlocklets) {
        ArrayList<InputSplit> resultFilteredBlocks = new ArrayList<InputSplit>();
        for (ExtendedBlocklet blocklet : extendedBlocklets) {
            if (blocklet == null) continue;
            resultFilteredBlocks.add((InputSplit)blocklet.getInputSplit());
        }
        return resultFilteredBlocks;
    }

    public RecordReader<Void, T> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        Configuration configuration = taskAttemptContext.getConfiguration();
        QueryModel queryModel = this.createQueryModel(inputSplit, taskAttemptContext, this.getFilterPredicates(taskAttemptContext.getConfiguration()));
        CarbonReadSupport<T> readSupport = this.getReadSupportClass(configuration);
        return new CarbonRecordReader<T>(queryModel, readSupport, taskAttemptContext.getConfiguration());
    }

    public QueryModel createQueryModel(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException {
        return this.createQueryModel(inputSplit, taskAttemptContext, this.getFilterPredicates(taskAttemptContext.getConfiguration()));
    }

    public QueryModel createQueryModel(InputSplit inputSplit, TaskAttemptContext taskAttemptContext, Expression filterExpression) throws IOException {
        Configuration configuration = taskAttemptContext.getConfiguration();
        CarbonTable carbonTable = this.getOrCreateCarbonTable(configuration);
        String projectionString = CarbonInputFormat.getColumnProjection(configuration);
        String[] projectColumns = projectionString != null ? projectionString.split(",") : new String[]{};
        this.checkAndAddImplicitExpression(filterExpression, inputSplit);
        QueryModel queryModel = new QueryModelBuilder(carbonTable).projectColumns(projectColumns).filterExpression(filterExpression).dataConverter(CarbonInputFormat.getDataTypeConverter(configuration)).build();
        return queryModel;
    }

    private void checkAndAddImplicitExpression(Expression expression, InputSplit inputSplit) {
        if (inputSplit instanceof CarbonMultiBlockSplit) {
            CarbonMultiBlockSplit split = (CarbonMultiBlockSplit)inputSplit;
            List<CarbonInputSplit> splits = split.getAllSplits();
            HashMap<String, Set> blockIdToBlockletIdMapping = new HashMap<String, Set>();
            for (CarbonInputSplit carbonInputSplit : splits) {
                Set validBlockletIds = carbonInputSplit.getValidBlockletIds();
                if (null == validBlockletIds || validBlockletIds.isEmpty()) continue;
                String uniqueBlockPath = carbonInputSplit.getFilePath();
                String shortBlockPath = CarbonTablePath.getShortBlockId((String)uniqueBlockPath.substring(uniqueBlockPath.lastIndexOf("/Part") + 1));
                blockIdToBlockletIdMapping.put(shortBlockPath, validBlockletIds);
            }
            if (!blockIdToBlockletIdMapping.isEmpty()) {
                FilterUtil.createImplicitExpressionAndSetAsRightChild((Expression)expression, blockIdToBlockletIdMapping);
            }
        }
    }

    public CarbonReadSupport<T> getReadSupportClass(Configuration configuration) {
        String readSupportClass = configuration.get(CARBON_READ_SUPPORT);
        CarbonReadSupport readSupport = null;
        if (readSupportClass != null) {
            try {
                Class<?> myClass = Class.forName(readSupportClass);
                Constructor<?> constructor = myClass.getConstructors()[0];
                Object object = constructor.newInstance(new Object[0]);
                if (object instanceof CarbonReadSupport) {
                    readSupport = (CarbonReadSupport)object;
                }
            }
            catch (ClassNotFoundException ex) {
                LOG.error((Object)("Class " + readSupportClass + "not found"), (Throwable)ex);
            }
            catch (Exception ex) {
                LOG.error((Object)("Error while creating " + readSupportClass), (Throwable)ex);
            }
        } else {
            readSupport = new DictionaryDecodeReadSupport();
        }
        return readSupport;
    }

    protected boolean isSplitable(JobContext context, Path filename) {
        try {
            FileSystem fileSystem = filename.getFileSystem(context.getConfiguration());
            if (fileSystem instanceof LocalFileSystem) {
                return false;
            }
        }
        catch (Exception e) {
            return true;
        }
        return true;
    }

    public static void setCarbonReadSupport(Configuration configuration, Class<? extends CarbonReadSupport> readSupportClass) {
        if (readSupportClass != null) {
            configuration.set(CARBON_READ_SUPPORT, readSupportClass.getName());
        }
    }

    public static void setDataTypeConverter(Configuration configuration, Class<? extends DataTypeConverter> converterClass) {
        if (null != converterClass) {
            configuration.set(CARBON_CONVERTER, converterClass.getCanonicalName());
        }
    }

    public static DataTypeConverter getDataTypeConverter(Configuration configuration) throws IOException {
        String converterClass = configuration.get(CARBON_CONVERTER);
        if (converterClass == null) {
            return new DataTypeConverterImpl();
        }
        try {
            return (DataTypeConverter)Class.forName(converterClass).newInstance();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static void setDatabaseName(Configuration configuration, String databaseName) {
        if (null != databaseName) {
            configuration.set(DATABASE_NAME, databaseName);
        }
    }

    public static String getDatabaseName(Configuration configuration) throws InvalidConfigurationException {
        String databseName = configuration.get(DATABASE_NAME);
        if (null == databseName) {
            throw new InvalidConfigurationException("Database name is not set.");
        }
        return databseName;
    }

    public static void setTableName(Configuration configuration, String tableName) {
        if (null != tableName) {
            configuration.set(TABLE_NAME, tableName);
        }
    }

    public static String getTableName(Configuration configuration) throws InvalidConfigurationException {
        String tableName = configuration.get(TABLE_NAME);
        if (tableName == null) {
            throw new InvalidConfigurationException("Table name is not set");
        }
        return tableName;
    }

    public static void setAccessStreamingSegments(Configuration configuration, Boolean validate) throws InvalidConfigurationException {
        configuration.set("carbon.query.on.preagg.streaming.." + CarbonInputFormat.getDatabaseName(configuration) + "." + CarbonInputFormat.getTableName(configuration), validate.toString());
    }

    public static boolean getAccessStreamingSegments(Configuration configuration) {
        try {
            return configuration.get("carbon.query.on.preagg.streaming.." + CarbonInputFormat.getDatabaseName(configuration) + "." + CarbonInputFormat.getTableName(configuration), "false").equalsIgnoreCase("true");
        }
        catch (InvalidConfigurationException e) {
            return false;
        }
    }

    public String[] projectAllColumns(CarbonTable carbonTable) {
        List colList = carbonTable.getTableInfo().getFactTable().getListOfColumns();
        ArrayList<String> projectColumns = new ArrayList<String>();
        for (ColumnSchema col : colList) {
            if (col.getColumnName().contains(".")) continue;
            projectColumns.add(col.getColumnName());
        }
        return projectColumns.toArray(new String[projectColumns.size()]);
    }

    private static void getQuerySegmentToAccess(Configuration conf, String dbName, String tableName) {
        String segmentNumbersFromProperty = CarbonProperties.getInstance().getProperty("carbon.input.segments." + dbName + "." + tableName, "*");
        if (!segmentNumbersFromProperty.trim().equals("*")) {
            CarbonInputFormat.setSegmentsToAccess(conf, Segment.toSegmentList((String[])segmentNumbersFromProperty.split(","), null));
        }
    }

    public static void setQuerySegment(Configuration conf, CarbonTable carbonTable) {
        String tableName = carbonTable.getTableName();
        CarbonInputFormat.getQuerySegmentToAccess(conf, carbonTable.getDatabaseName(), tableName);
    }
}

