/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hadoop;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.carbondata.core.datastore.block.Distributable;
import org.apache.carbondata.core.statusmanager.FileFormat;
import org.apache.carbondata.hadoop.CarbonInputSplit;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;

public class CarbonMultiBlockSplit
extends InputSplit
implements Serializable,
Writable {
    private List<CarbonInputSplit> splitList;
    private String[] locations;
    private FileFormat fileFormat = FileFormat.COLUMNAR_V3;
    private long length;

    public CarbonMultiBlockSplit() {
        this.splitList = null;
        this.locations = null;
        this.length = 0L;
    }

    public CarbonMultiBlockSplit(List<Distributable> blocks, String hostname) {
        this.splitList = new ArrayList<CarbonInputSplit>(blocks.size());
        for (Distributable block : blocks) {
            this.splitList.add((CarbonInputSplit)block);
        }
        this.locations = new String[]{hostname};
    }

    public CarbonMultiBlockSplit(List<CarbonInputSplit> splitList, String[] locations) {
        this.splitList = splitList;
        this.locations = locations;
        this.calculateLength();
    }

    public CarbonMultiBlockSplit(List<CarbonInputSplit> splitList, String[] locations, FileFormat fileFormat) {
        this.splitList = splitList;
        this.locations = locations;
        this.fileFormat = fileFormat;
        this.calculateLength();
    }

    public List<CarbonInputSplit> getAllSplits() {
        return this.splitList;
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public void calculateLength() {
        long total = 0L;
        if (this.splitList.size() > 0 && this.splitList.get(0).getDetailInfo() != null) {
            HashMap<String, Long> blockSizes = new HashMap<String, Long>();
            for (CarbonInputSplit carbonInputSplit : this.splitList) {
                blockSizes.put(carbonInputSplit.getBlockPath(), carbonInputSplit.getDetailInfo().getBlockSize());
            }
            for (Map.Entry entry : blockSizes.entrySet()) {
                total += ((Long)entry.getValue()).longValue();
            }
        } else {
            for (CarbonInputSplit split : this.splitList) {
                total += split.getLength();
            }
        }
        this.length = total;
    }

    public String[] getLocations() {
        return this.locations;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.splitList.size());
        for (CarbonInputSplit split : this.splitList) {
            split.write(out);
        }
        out.writeInt(this.locations.length);
        for (int i = 0; i < this.locations.length; ++i) {
            out.writeUTF(this.locations[i]);
        }
        out.writeInt(this.fileFormat.ordinal());
    }

    public void readFields(DataInput in) throws IOException {
        int numSplit = in.readInt();
        this.splitList = new ArrayList<CarbonInputSplit>(numSplit);
        for (int i = 0; i < numSplit; ++i) {
            CarbonInputSplit split = new CarbonInputSplit();
            split.readFields(in);
            this.splitList.add(split);
        }
        int len = in.readInt();
        this.locations = new String[len];
        for (int i = 0; i < len; ++i) {
            this.locations[i] = in.readUTF();
        }
        this.fileFormat = FileFormat.getByOrdinal((int)in.readInt());
    }

    public FileFormat getFileFormat() {
        return this.fileFormat;
    }

    public void setFileFormat(FileFormat fileFormat) {
        this.fileFormat = fileFormat;
    }
}

