/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hadoop;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.carbondata.core.datamap.Segment;
import org.apache.carbondata.core.datastore.block.BlockletInfos;
import org.apache.carbondata.core.datastore.block.Distributable;
import org.apache.carbondata.core.datastore.block.TableBlockInfo;
import org.apache.carbondata.core.indexstore.Blocklet;
import org.apache.carbondata.core.indexstore.BlockletDetailInfo;
import org.apache.carbondata.core.metadata.ColumnarFormatVersion;
import org.apache.carbondata.core.mutate.UpdateVO;
import org.apache.carbondata.core.statusmanager.FileFormat;
import org.apache.carbondata.core.util.ByteUtil;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.carbondata.hadoop.internal.index.Block;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

public class CarbonInputSplit
extends FileSplit
implements Distributable,
Serializable,
Writable,
Block {
    private static final long serialVersionUID = 3520344046772190207L;
    public String taskId;
    private Segment segment;
    private String bucketId;
    private String blockletId;
    private List<String> invalidSegments;
    private int numberOfBlocklets;
    private ColumnarFormatVersion version;
    private Map<String, String> blockStorageIdMap = new HashMap<String, String>(16);
    private List<UpdateVO> invalidTimestampsList;
    private String[] deleteDeltaFiles;
    private BlockletDetailInfo detailInfo;
    private FileFormat fileFormat = FileFormat.COLUMNAR_V3;
    private String dataMapWritePath;
    private Set<Integer> validBlockletIds;

    public CarbonInputSplit() {
        this.segment = null;
        this.taskId = "0";
        this.bucketId = "0";
        this.blockletId = "0";
        this.numberOfBlocklets = 0;
        this.invalidSegments = new ArrayList<String>();
        this.version = CarbonProperties.getInstance().getFormatVersion();
    }

    private CarbonInputSplit(String segmentId, String blockletId, Path path, long start, long length, String[] locations, ColumnarFormatVersion version, String[] deleteDeltaFiles, String dataMapWritePath) {
        super(path, start, length, locations);
        this.segment = Segment.toSegment((String)segmentId);
        String taskNo = CarbonTablePath.DataFileUtil.getTaskNo((String)path.getName());
        if (taskNo.contains("_")) {
            taskNo = taskNo.split("_")[0];
        }
        this.taskId = taskNo;
        this.bucketId = CarbonTablePath.DataFileUtil.getBucketNo((String)path.getName());
        this.blockletId = blockletId;
        this.invalidSegments = new ArrayList<String>();
        this.version = version;
        this.deleteDeltaFiles = deleteDeltaFiles;
        this.dataMapWritePath = dataMapWritePath;
    }

    public CarbonInputSplit(String segmentId, String blockletId, Path path, long start, long length, String[] locations, int numberOfBlocklets, ColumnarFormatVersion version, String[] deleteDeltaFiles) {
        this(segmentId, blockletId, path, start, length, locations, version, deleteDeltaFiles, null);
        this.numberOfBlocklets = numberOfBlocklets;
    }

    public CarbonInputSplit(String segmentId, Path path, long start, long length, String[] locations, FileFormat fileFormat) {
        super(path, start, length, locations);
        this.segment = Segment.toSegment((String)segmentId);
        this.fileFormat = fileFormat;
        this.taskId = "0";
        this.bucketId = "0";
        this.blockletId = "0";
        this.numberOfBlocklets = 0;
        this.invalidSegments = new ArrayList<String>();
        this.version = CarbonProperties.getInstance().getFormatVersion();
    }

    public CarbonInputSplit(String segmentId, Path path, long start, long length, String[] locations, String[] inMemoryHosts, FileFormat fileFormat) {
        super(path, start, length, locations, inMemoryHosts);
        this.segment = Segment.toSegment((String)segmentId);
        this.fileFormat = fileFormat;
        this.taskId = "0";
        this.bucketId = "0";
        this.blockletId = "0";
        this.numberOfBlocklets = 0;
        this.invalidSegments = new ArrayList<String>();
        this.version = CarbonProperties.getInstance().getFormatVersion();
    }

    public CarbonInputSplit(String segmentId, String blockletId, Path path, long start, long length, String[] locations, int numberOfBlocklets, ColumnarFormatVersion version, Map<String, String> blockStorageIdMap, String[] deleteDeltaFiles) {
        this(segmentId, blockletId, path, start, length, locations, numberOfBlocklets, version, deleteDeltaFiles);
        this.blockStorageIdMap = blockStorageIdMap;
    }

    public static CarbonInputSplit from(String segmentId, String blockletId, FileSplit split, ColumnarFormatVersion version, String dataMapWritePath) throws IOException {
        return new CarbonInputSplit(segmentId, blockletId, split.getPath(), split.getStart(), split.getLength(), split.getLocations(), version, null, dataMapWritePath);
    }

    public static List<TableBlockInfo> createBlocks(List<CarbonInputSplit> splitList) {
        ArrayList<TableBlockInfo> tableBlockInfoList = new ArrayList<TableBlockInfo>();
        for (CarbonInputSplit split : splitList) {
            BlockletInfos blockletInfos = new BlockletInfos(split.getNumberOfBlocklets(), 0, split.getNumberOfBlocklets());
            try {
                TableBlockInfo blockInfo = new TableBlockInfo(split.getPath().toString(), split.blockletId, split.getStart(), split.getSegment().toString(), split.getLocations(), split.getLength(), blockletInfos, split.getVersion(), split.getDeleteDeltaFiles());
                blockInfo.setDetailInfo(split.getDetailInfo());
                blockInfo.setDataMapWriterPath(split.dataMapWritePath);
                if (split.getDetailInfo() != null) {
                    blockInfo.setBlockOffset(split.getDetailInfo().getBlockFooterOffset());
                }
                tableBlockInfoList.add(blockInfo);
            }
            catch (IOException e) {
                throw new RuntimeException("fail to get location of split: " + split, e);
            }
        }
        return tableBlockInfoList;
    }

    public static TableBlockInfo getTableBlockInfo(CarbonInputSplit inputSplit) {
        BlockletInfos blockletInfos = new BlockletInfos(inputSplit.getNumberOfBlocklets(), 0, inputSplit.getNumberOfBlocklets());
        try {
            TableBlockInfo blockInfo = new TableBlockInfo(inputSplit.getPath().toString(), inputSplit.blockletId, inputSplit.getStart(), inputSplit.getSegment().toString(), inputSplit.getLocations(), inputSplit.getLength(), blockletInfos, inputSplit.getVersion(), inputSplit.getDeleteDeltaFiles());
            blockInfo.setDetailInfo(inputSplit.getDetailInfo());
            blockInfo.setBlockOffset(inputSplit.getDetailInfo().getBlockFooterOffset());
            return blockInfo;
        }
        catch (IOException e) {
            throw new RuntimeException("fail to get location of split: " + inputSplit, e);
        }
    }

    public String getSegmentId() {
        if (this.segment != null) {
            return this.segment.getSegmentNo();
        }
        return null;
    }

    public Segment getSegment() {
        return this.segment;
    }

    public void readFields(DataInput in) throws IOException {
        boolean dataMapWriterPathExists;
        super.readFields(in);
        this.segment = Segment.toSegment((String)in.readUTF());
        this.version = ColumnarFormatVersion.valueOf((short)in.readShort());
        this.bucketId = in.readUTF();
        this.blockletId = in.readUTF();
        int numInvalidSegment = in.readInt();
        this.invalidSegments = new ArrayList<String>(numInvalidSegment);
        for (int i = 0; i < numInvalidSegment; ++i) {
            this.invalidSegments.add(in.readUTF());
        }
        int numberOfDeleteDeltaFiles = in.readInt();
        this.deleteDeltaFiles = new String[numberOfDeleteDeltaFiles];
        for (int i = 0; i < numberOfDeleteDeltaFiles; ++i) {
            this.deleteDeltaFiles[i] = in.readUTF();
        }
        boolean detailInfoExists = in.readBoolean();
        if (detailInfoExists) {
            this.detailInfo = new BlockletDetailInfo();
            this.detailInfo.readFields(in);
        }
        if (dataMapWriterPathExists = in.readBoolean()) {
            this.dataMapWritePath = in.readUTF();
        }
        int validBlockletIdCount = in.readShort();
        this.validBlockletIds = new HashSet<Integer>(validBlockletIdCount);
        for (int i = 0; i < validBlockletIdCount; ++i) {
            this.validBlockletIds.add(Integer.valueOf(in.readShort()));
        }
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeUTF(this.segment.toString());
        out.writeShort(this.version.number());
        out.writeUTF(this.bucketId);
        out.writeUTF(this.blockletId);
        out.writeInt(this.invalidSegments.size());
        for (String invalidSegment : this.invalidSegments) {
            out.writeUTF(invalidSegment);
        }
        out.writeInt(null != this.deleteDeltaFiles ? this.deleteDeltaFiles.length : 0);
        if (null != this.deleteDeltaFiles) {
            for (int i = 0; i < this.deleteDeltaFiles.length; ++i) {
                out.writeUTF(this.deleteDeltaFiles[i]);
            }
        }
        out.writeBoolean(this.detailInfo != null);
        if (this.detailInfo != null) {
            this.detailInfo.write(out);
        }
        out.writeBoolean(this.dataMapWritePath != null);
        if (this.dataMapWritePath != null) {
            out.writeUTF(this.dataMapWritePath);
        }
        out.writeShort(this.getValidBlockletIds().size());
        for (Integer blockletId : this.getValidBlockletIds()) {
            out.writeShort(blockletId);
        }
    }

    public List<String> getInvalidSegments() {
        return this.invalidSegments;
    }

    public void setInvalidSegments(List<Segment> invalidSegments) {
        ArrayList<String> invalidSegmentIds = new ArrayList<String>();
        for (Segment segment : invalidSegments) {
            invalidSegmentIds.add(segment.getSegmentNo());
        }
        this.invalidSegments = invalidSegmentIds;
    }

    public void setInvalidTimestampRange(List<UpdateVO> invalidTimestamps) {
        this.invalidTimestampsList = invalidTimestamps;
    }

    public List<UpdateVO> getInvalidTimestampRange() {
        return this.invalidTimestampsList;
    }

    public int getNumberOfBlocklets() {
        return this.numberOfBlocklets;
    }

    public ColumnarFormatVersion getVersion() {
        return this.version;
    }

    public void setVersion(ColumnarFormatVersion version) {
        this.version = version;
    }

    public String getBucketId() {
        return this.bucketId;
    }

    public String getBlockletId() {
        return this.blockletId;
    }

    public int compareTo(Distributable o) {
        double seg2;
        if (o == null) {
            return -1;
        }
        CarbonInputSplit other = (CarbonInputSplit)o;
        int compareResult = 0;
        double seg1 = Double.parseDouble(this.segment.getSegmentNo());
        if (seg1 - (seg2 = Double.parseDouble(other.getSegmentId())) < 0.0) {
            return -1;
        }
        if (seg1 - seg2 > 0.0) {
            return 1;
        }
        String filePath1 = this.getPath().getName();
        String filePath2 = other.getPath().getName();
        if (CarbonTablePath.isCarbonDataFile((String)filePath1)) {
            int otherBucketNo;
            byte[] otherTaskId;
            byte[] firstTaskId = CarbonTablePath.DataFileUtil.getTaskNo((String)filePath1).getBytes(Charset.forName("UTF-8"));
            int compare = ByteUtil.compare((byte[])firstTaskId, (byte[])(otherTaskId = CarbonTablePath.DataFileUtil.getTaskNo((String)filePath2).getBytes(Charset.forName("UTF-8"))));
            if (compare != 0) {
                return compare;
            }
            int firstBucketNo = Integer.parseInt(CarbonTablePath.DataFileUtil.getBucketNo((String)filePath1));
            if (firstBucketNo != (otherBucketNo = Integer.parseInt(CarbonTablePath.DataFileUtil.getBucketNo((String)filePath2)))) {
                return firstBucketNo - otherBucketNo;
            }
            int firstPartNo = Integer.parseInt(CarbonTablePath.DataFileUtil.getPartNo((String)filePath1));
            int SecondPartNo = Integer.parseInt(CarbonTablePath.DataFileUtil.getPartNo((String)filePath2));
            compareResult = firstPartNo - SecondPartNo;
        } else {
            compareResult = filePath1.compareTo(filePath2);
        }
        if (compareResult != 0) {
            return compareResult;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CarbonInputSplit)) {
            return false;
        }
        CarbonInputSplit other = (CarbonInputSplit)obj;
        return 0 == this.compareTo(other);
    }

    public int hashCode() {
        int result = this.taskId.hashCode();
        result = 31 * result + this.segment.hashCode();
        result = 31 * result + this.bucketId.hashCode();
        result = 31 * result + this.invalidSegments.hashCode();
        result = 31 * result + this.numberOfBlocklets;
        return result;
    }

    @Override
    public String getBlockPath() {
        return this.getPath().getName();
    }

    @Override
    public List<Long> getMatchedBlocklets() {
        return null;
    }

    @Override
    public boolean fullScan() {
        return true;
    }

    public Map<String, String> getBlockStorageIdMap() {
        return this.blockStorageIdMap;
    }

    public String[] getDeleteDeltaFiles() {
        return this.deleteDeltaFiles;
    }

    public void setDeleteDeltaFiles(String[] deleteDeltaFiles) {
        this.deleteDeltaFiles = deleteDeltaFiles;
    }

    public BlockletDetailInfo getDetailInfo() {
        return this.detailInfo;
    }

    public void setDetailInfo(BlockletDetailInfo detailInfo) {
        this.detailInfo = detailInfo;
    }

    public FileFormat getFileFormat() {
        return this.fileFormat;
    }

    public void setFormat(FileFormat fileFormat) {
        this.fileFormat = fileFormat;
    }

    public Blocklet makeBlocklet() {
        return new Blocklet(this.getPath().getName(), this.blockletId);
    }

    public Set<Integer> getValidBlockletIds() {
        if (null == this.validBlockletIds) {
            this.validBlockletIds = new HashSet<Integer>();
        }
        return this.validBlockletIds;
    }

    public void setValidBlockletIds(Set<Integer> validBlockletIds) {
        this.validBlockletIds = validBlockletIds;
    }
}

